<?php
/*
Template Name: Blog Grid
*/
get_header();
?>
<main>
    <div id="content" class="content-idcluster">
        <?php
        while (have_posts()) : the_post();
            the_content();
        endwhile;
        ?>
    </div>

    <?php
    // Vérifie s'il y a des articles publiés
    $args = array(
        'post_type'      => 'post',
        'posts_per_page' => 1, // Vérifie s'il y a au moins un article
    );
    $check_posts = new WP_Query($args);
    if ($check_posts->have_posts()) :
    ?>
        <div class="blog-filter-container">
            <!-- Boutons de filtrage par catégorie -->
            <div class="filter-buttons">
                <button class="filter-btn active" data-category="all">Toutes</button>
                <?php
                $categories = get_categories();
                foreach ($categories as $category) {
                    echo '<button class="filter-btn" data-category="' . $category->slug . '">' . $category->name . '</button>';
                }
                ?>
            </div>

            <!-- Grille d'articles -->
            <div class="blog-grid" id="blog-grid">
                <?php
                $args = array(
                    'post_type'      => 'post',
                    'posts_per_page' => -1, // Affiche tous les articles
                );
                $query = new WP_Query($args);
                if ($query->have_posts()) :
                    while ($query->have_posts()) : $query->the_post();
                        $categories = get_the_category();
                        $category_slugs = wp_list_pluck($categories, 'slug');
                        ?>
                        <article class="blog-post <?php echo implode(' ', $category_slugs); ?>">
                         
                                <?php if (has_post_thumbnail()) : ?>
                                    <div class="post-thumbnail">
                                        <?php the_post_thumbnail('medium'); ?>
                                    </div>
                                <?php endif; ?>
                                <h3><?php the_title(); ?></h3>
                                <div class="post-excerpt"><?php the_excerpt(); ?></div>
                           
                        </article>
                        <?php
                    endwhile;
                    wp_reset_postdata();
                endif;
                ?>
            </div>
        </div>
    <?php
    endif; // Fin de la condition pour vérifier s'il y a des articles
    ?>
</main>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const filterButtons = document.querySelectorAll('.filter-btn');
    const blogPosts = document.querySelectorAll('.blog-post');

    if (filterButtons.length > 0 && blogPosts.length > 0) {
        filterButtons.forEach(button => {
            button.addEventListener('click', () => {
                // Réinitialise les boutons actifs
                filterButtons.forEach(btn => btn.classList.remove('active'));
                button.classList.add('active');
                const category = button.getAttribute('data-category');

                // Filtre les articles
                blogPosts.forEach(post => {
                    if (category === 'all' || post.classList.contains(category)) {
                        post.style.display = 'block';
                    } else {
                        post.style.display = 'none';
                    }
                });
            });
        });
    }
});
</script>

<?php get_footer(); ?>
