jQuery(document).ready(function($) {
    // Fonctionnalité de filtrage des articles
    $('.filter-button').on('click', function() {
        var category = $(this).data('category');
        $.ajax({
            url: ajax_object.ajax_url,
            type: 'POST',
            data: {
                action: 'filter_posts',
                category: category
            },
            success: function(response) {
                $('#posts-container').html(response);
            }
        });
    });

    // Fonctionnalité de glisser-déposer pour réorganiser les articles
    $('#the-list').sortable({
        update: function(event, ui) {
            var post_order = $(this).sortable('toArray').toString();
            $.ajax({
                url: ajax_object.ajax_url,
                method: 'POST',
                data: {
                    action: 'save_posts_order',
                    posts_order: post_order
                }
            });
        }
    });
});
