<?php
function mon_theme_setup() {
  register_nav_menus(array(
    'header-menu' => __('Header Menu', 'idcluster'),
  ));
}

add_action('after_setup_theme', function() {
    // Active la prise en charge des styles et des thèmes de blocs Gutenberg
    add_theme_support('wp-block-styles');
});
function ekno_add_security_headers() {
    // HSTS
    header("Strict-Transport-Security: max-age=31536000; includeSubDomains; preload");

    // CSP: autorisation pour jQuery et les scripts en ligne
    header("Content-Security-Policy: default-src 'self'; script-src 'self' https://code.jquery.com 'unsafe-inline' 'unsafe-eval'; style-src 'self' 'unsafe-inline'; img-src 'self' data:; object-src 'none';");

    // Clickjacking
    header("X-Frame-Options: SAMEORIGIN");

    // MIME sniffing
    header("X-Content-Type-Options: nosniff");

    // Référents
    header("Referrer-Policy: no-referrer-when-downgrade");

    // Permissions
    header("Permissions-Policy: geolocation=(), microphone=(), camera=()");

    // Certificate Transparency
    header("Expect-CT: max-age=86400, enforce, report-uri=\"https://rapport.up.thera.fr//ct\"");
}
add_action('send_headers', 'ekno_add_security_headers');
// ajouter une image ou logo pour les publications 
add_theme_support('post-thumbnails');

// supprimer l'acces single page pour les start up
function redirect_single_posts_to_custom_page() {
    // Vérifie si on est sur un article individuel (single post)
    if (is_single() && 'post' === get_post_type()) {
        // Redirige vers l'URL souhaitée
        wp_redirect('https://up.thera.fr/nos-start-up/', 301);
        exit;
    }
}
add_action('template_redirect', 'redirect_single_posts_to_custom_page');


// 1. Charger le CSS sur la page de connexion
function mon_login_stylesheet() {
  wp_enqueue_style( 'mon-login-css', get_stylesheet_directory_uri() . '/login.css' );
}
add_action( 'login_enqueue_scripts', 'mon_login_stylesheet' );

// 2. Modifier l’URL du logo de connexion
function mon_login_logo_url() {
  return home_url(); // ou URL de votre landing page
}
add_filter( 'login_headerurl', 'mon_login_logo_url' );

// 3. Modifier le titre alt du logo
function mon_login_logo_title() {
  return 'Bienvenue sur MonSite';
}
add_filter( 'login_headertext', 'mon_login_logo_title' );

// Désactive les commentaires partout (front-end + back-end)
function disable_all_comments() {
    // Désactive les commentaires dans les types de contenu
    $post_types = get_post_types();
    foreach ($post_types as $post_type) {
        if (post_type_supports($post_type, 'comments')) {
            remove_post_type_support($post_type, 'comments');
            remove_post_type_support($post_type, 'trackbacks');
        }
    }

    // Ferme les commentaires existants
    update_option('default_comment_status', 'closed');
    update_option('default_ping_status', 'closed');

    // Masque les menus et widgets liés aux commentaires
    add_action('admin_menu', function() {
        remove_menu_page('edit-comments.php');
        remove_meta_box('dashboard_recent_comments', 'dashboard', 'normal');
    });

    // Redirige les requêtes vers les commentaires
    add_action('admin_init', function() {
        global $pagenow;
        if ($pagenow === 'edit-comments.php') {
            wp_redirect(admin_url());
            exit;
        }
    });
}
add_action('init', 'disable_all_comments');
function rename_post_object() {
    global $wp_post_types;
    $labels = &$wp_post_types['post']->labels;
    $labels->name = 'Start-ups';
    $labels->singular_name = 'Start-up';
    $labels->add_new = 'Ajouter une Start-up';
    $labels->add_new_item = 'Ajouter une nouvelle Start-up';
    $labels->edit_item = 'Modifier la Start-up';
    $labels->new_item = 'Nouvelle Start-up';
    $labels->view_item = 'Voir la Start-up';
    $labels->search_items = 'Rechercher des Start-ups';
    $labels->not_found = 'Aucune Start-up trouvée';
    $labels->not_found_in_trash = 'Aucune Start-up dans la corbeille';
    $labels->all_items = 'Toutes les Start-ups';
    $labels->menu_name = 'Start-ups';
    $labels->name_admin_bar = 'Start-up';
}
add_action('init', 'rename_post_object');


function ajouter_csp_fonts($headers) {
    $headers['Content-Security-Policy'] = "font-src 'self' data:;";
    return $headers;
}
add_filter('wp_headers', 'ajouter_csp_fonts');
?>