/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-09-09 13:25:41 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `cupaiowps_audit_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `network_id` bigint NOT NULL DEFAULT '0',
  `site_id` bigint NOT NULL DEFAULT '0',
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `level` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `event_type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `details` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `stacktrace` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created` int unsigned DEFAULT NULL,
  `country_code` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `ip` (`ip`),
  KEY `level` (`level`),
  KEY `event_type` (`event_type`)
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupaiowps_debug_log` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `logtime` int unsigned DEFAULT NULL,
  `level` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `network_id` bigint NOT NULL DEFAULT '0',
  `site_id` bigint NOT NULL DEFAULT '0',
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupaiowps_events` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int unsigned DEFAULT NULL,
  `ip_or_host` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referer_info` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country_code` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `event_data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupaiowps_global_meta` (
  `meta_id` bigint NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int unsigned DEFAULT NULL,
  `meta_key1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value2` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value3` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value4` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value5` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupaiowps_logged_in_users` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `site_id` bigint NOT NULL,
  `created` int unsigned DEFAULT NULL,
  `expires` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_id` (`user_id`),
  KEY `created` (`created`),
  KEY `expires` (`expires`),
  KEY `user_id` (`user_id`),
  KEY `site_id` (`site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupaiowps_login_lockdown` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int unsigned DEFAULT NULL,
  `release_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `released` int unsigned DEFAULT NULL,
  `failed_login_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `lock_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `unlock_key` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `is_lockout_email_sent` tinyint(1) NOT NULL DEFAULT '1',
  `backtrace_log` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ip_lookup_result` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `failed_login_ip` (`failed_login_ip`),
  KEY `is_lockout_email_sent` (`is_lockout_email_sent`),
  KEY `unlock_key` (`unlock_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupaiowps_message_store` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `message_key` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message_value` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupaiowps_permanent_block` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `block_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `country_origin` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `created` int unsigned DEFAULT NULL,
  `unblock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `blocked_ip` (`blocked_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupcmplz_cookiebanners` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `banner_version` int NOT NULL,
  `default` int NOT NULL,
  `position` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `checkbox_style` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_logo` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `logo_attachment_id` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `close_button` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `revoke` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `manage_consent_options` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `header` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `dismiss` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `save_preferences` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `view_preferences` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_functional` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_all` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_stats` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_prefs` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `accept` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message_optin` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_categories` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `disable_cookiebanner` int NOT NULL,
  `banner_width` int NOT NULL,
  `soft_cookiewall` int NOT NULL,
  `dismiss_on_scroll` int NOT NULL,
  `dismiss_on_timeout` int NOT NULL,
  `dismiss_timeout` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `accept_informational` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message_optout` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_custom_cookie_css` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `custom_css` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `statistics` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `functional_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `statistics_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `statistics_text_anonymous` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `preferences_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `marketing_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_background` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_toggles` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_border_radius` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `border_width` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `font_size` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_button_accept` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_button_deny` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_button_settings` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `buttons_border_radius` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `animation` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_box_shadow` int NOT NULL,
  `header_footer_shadow` int NOT NULL,
  `hide_preview` int NOT NULL,
  `disable_width_correction` int NOT NULL,
  `legal_documents` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupcmplz_cookies` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sync` int NOT NULL,
  `ignored` int NOT NULL,
  `retention` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `serviceID` int NOT NULL,
  `cookieFunction` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `collectedPersonalData` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `purpose` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `language` varchar(6) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `isTranslationFrom` int NOT NULL,
  `isOwnDomainCookie` int NOT NULL,
  `domain` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `deleted` int NOT NULL,
  `isMembersOnly` int NOT NULL,
  `showOnPolicy` int NOT NULL,
  `lastUpdatedDate` int NOT NULL,
  `lastAddDate` int NOT NULL,
  `firstAddDate` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupcmplz_dnsmpd` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `region` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `global_optout` int NOT NULL,
  `cross_context` int NOT NULL,
  `limit_sensitive` int NOT NULL,
  `request_for_access` int NOT NULL,
  `right_to_be_forgotten` int NOT NULL,
  `right_to_data_portability` int NOT NULL,
  `request_date` int NOT NULL,
  `resolved` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupcmplz_services` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `serviceType` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `thirdParty` int NOT NULL,
  `sharesData` int NOT NULL,
  `secondParty` int NOT NULL,
  `privacyStatementURL` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `language` varchar(6) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `isTranslationFrom` int NOT NULL,
  `sync` int NOT NULL,
  `lastUpdatedDate` int NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupcommentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupcomments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupduplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cuplinks` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cuplitespeed_url` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `url` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cache_tags` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cuplitespeed_url_file` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `url_id` bigint NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint NOT NULL COMMENT 'mobile=1',
  `webp` tinyint NOT NULL COMMENT 'webp=1',
  `expired` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupoptions` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=4335 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cuppostmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2345 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupposts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1651 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupterm_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupterm_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cuptermmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupterms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupusermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupusers` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupyoast_indexable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint DEFAULT NULL,
  `post_parent` bigint DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int DEFAULT NULL,
  `readability_score` int DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int DEFAULT NULL,
  `incoming_link_count` int DEFAULT NULL,
  `prominent_words_version` int unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int DEFAULT NULL,
  `version` int DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupyoast_indexable_hierarchy` (
  `indexable_id` int unsigned NOT NULL,
  `ancestor_id` int unsigned NOT NULL,
  `depth` int unsigned DEFAULT NULL,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupyoast_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cupyoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupyoast_primary_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint DEFAULT NULL,
  `term_id` bigint DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `cupyoast_seo_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint unsigned DEFAULT NULL,
  `target_post_id` bigint unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `target_indexable_id` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `size` int unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=99 DEFAULT CHARSET=utf8mb3;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: cupaiowps_audit_log */
INSERT INTO `cupaiowps_audit_log` VALUES("1", "1", "1", "vincent.voegel@ekno.fr", "46.218.227.220", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"vincent.voegel@ekno.fr\",\"known\":false}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:45:\"/home/xvgnwgb/check/wp-includes/pluggable.php\";s:4:\"line\";i:623;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1754463918", "");
INSERT INTO `cupaiowps_audit_log` VALUES("2", "1", "1", "vincent.voegel@ekno.fr", "46.218.227.220", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"vincent.voegel@ekno.fr\",\"known\":false}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:45:\"/home/xvgnwgb/check/wp-includes/pluggable.php\";s:4:\"line\";i:623;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1754463929", "");
INSERT INTO `cupaiowps_audit_log` VALUES("3", "1", "1", "webmaster@ekno.fr", "46.218.227.220", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"webmaster@ekno.fr\",\"known\":true}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:569;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:45:\"/home/xvgnwgb/check/wp-includes/pluggable.php\";s:4:\"line\";i:623;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1754463961", "");
INSERT INTO `cupaiowps_audit_log` VALUES("4", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1754463966", "");
INSERT INTO `cupaiowps_audit_log` VALUES("5", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Stackable - blocs Gutenberg\",\"version\":\"3.18.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4650;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754463976", "");
INSERT INTO `cupaiowps_audit_log` VALUES("6", "1", "1", "Ekno", "46.218.227.220", "info", "theme_updated", "{\"theme\":{\"name\":\"Twenty Twenty-Five\",\"version\":\"1.3\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:393;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:326;s:8:\"function\";s:19:\"event_theme_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:13:\"theme_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:62:\"/home/xvgnwgb/check/wp-admin/includes/class-theme-upgrader.php\";s:4:\"line\";i:510;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4320;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:14:\"Theme_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_ajax_update_theme\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754463982", "");
INSERT INTO `cupaiowps_audit_log` VALUES("7", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Cool Timeline\",\"version\":\"3.0.5\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754468598", "");
INSERT INTO `cupaiowps_audit_log` VALUES("8", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Cool Chronologie\",\"version\":\"3.0.5\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754468601", "");
INSERT INTO `cupaiowps_audit_log` VALUES("9", "1", "1", "Ekno", "46.218.227.220", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"Cool Chronologie\",\"version\":\"3.0.5\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754468681", "");
INSERT INTO `cupaiowps_audit_log` VALUES("10", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Timeline Block\",\"version\":\"1.7.2\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754468705", "");
INSERT INTO `cupaiowps_audit_log` VALUES("11", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Timeline Block\",\"version\":\"1.7.2\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754468717", "");
INSERT INTO `cupaiowps_audit_log` VALUES("12", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Hide Titles\",\"version\":\"1.8.7\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754472732", "");
INSERT INTO `cupaiowps_audit_log` VALUES("13", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Hide Titles\",\"version\":\"1.8.7\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754472736", "");
INSERT INTO `cupaiowps_audit_log` VALUES("14", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Timeline Block\",\"version\":\"1.2.2\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754483764", "");
INSERT INTO `cupaiowps_audit_log` VALUES("15", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Timeline Block\",\"version\":\"1.2.2\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754483773", "");
INSERT INTO `cupaiowps_audit_log` VALUES("16", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Cool Chronologie\",\"version\":\"3.0.5\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754484784", "");
INSERT INTO `cupaiowps_audit_log` VALUES("17", "1", "1", "Ekno", "46.218.227.220", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"Timeline Block\",\"version\":\"1.2.2\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754484903", "");
INSERT INTO `cupaiowps_audit_log` VALUES("18", "1", "1", "Ekno", "46.218.227.220", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"Cool Chronologie\",\"version\":\"3.0.5\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754484927", "");
INSERT INTO `cupaiowps_audit_log` VALUES("19", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Timeline Block\",\"version\":\"1.2.2\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1754484932", "");
INSERT INTO `cupaiowps_audit_log` VALUES("20", "1", "1", "vincent.voegel@ekno.fr", "46.218.227.220", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"vincent.voegel@ekno.fr\",\"known\":false}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:45:\"/home/xvgnwgb/check/wp-includes/pluggable.php\";s:4:\"line\";i:623;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1754559175", "");
INSERT INTO `cupaiowps_audit_log` VALUES("21", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1754559190", "");
INSERT INTO `cupaiowps_audit_log` VALUES("22", "1", "1", "vincent.voegel@ekno.fr", "46.218.227.220", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"vincent.voegel@ekno.fr\",\"known\":false}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:45:\"/home/xvgnwgb/check/wp-includes/pluggable.php\";s:4:\"line\";i:623;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1756280866", "");
INSERT INTO `cupaiowps_audit_log` VALUES("23", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1756280892", "");
INSERT INTO `cupaiowps_audit_log` VALUES("24", "1", "1", "Ekno", "46.218.227.220", "warning", "plugin_deleted", "{\"plugin\":{\"name\":\"Cool Chronologie\",\"version\":\"3.0.5\",\"action\":\"deleted\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4771;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756280904", "");
INSERT INTO `cupaiowps_audit_log` VALUES("25", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Stackable - blocs Gutenberg\",\"version\":\"3.18.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4650;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756280911", "");
INSERT INTO `cupaiowps_audit_log` VALUES("26", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Timeline Block\",\"version\":\"1.7.3\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4650;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756280914", "");
INSERT INTO `cupaiowps_audit_log` VALUES("27", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Wordfence Security\",\"version\":\"8.1.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4650;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756280920", "");
INSERT INTO `cupaiowps_audit_log` VALUES("28", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Daisy Titles\",\"version\":\"1.0.8\",\"action\":\"installed\",\"network\":\"\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:39:\"/home/xvgnwgb/check/wp-admin/update.php\";s:4:\"line\";i:145;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756281202", "");
INSERT INTO `cupaiowps_audit_log` VALUES("29", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Daisy Titles\",\"version\":\"1.0.8\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756281211", "");
INSERT INTO `cupaiowps_audit_log` VALUES("30", "1", "1", "Ekno", "46.218.227.220", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"Hide Titles\",\"version\":\"1.8.7\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756283294", "");
INSERT INTO `cupaiowps_audit_log` VALUES("31", "1", "1", "Ekno", "46.218.227.220", "warning", "plugin_deleted", "{\"plugin\":{\"name\":\"Hide Titles\",\"version\":\"1.8.7\",\"action\":\"deleted\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4771;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756283379", "");
INSERT INTO `cupaiowps_audit_log` VALUES("32", "1", "1", "Ekno", "46.218.227.220", "warning", "plugin_deleted", "{\"plugin\":{\"name\":\"Hello Dolly\",\"version\":\"1.7.2\",\"action\":\"deleted\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4771;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756283458", "");
INSERT INTO `cupaiowps_audit_log` VALUES("33", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Akismet Anti-spam: Spam Protection\",\"version\":\"5.5\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756283546", "");
INSERT INTO `cupaiowps_audit_log` VALUES("34", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Advanced Custom Fields\",\"version\":\"6.5.0\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756284510", "");
INSERT INTO `cupaiowps_audit_log` VALUES("35", "1", "1", "Ekno", "46.218.227.220", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"advanced-custom-fields\",\"version\":\"6.5.0\"}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756284511", "");
INSERT INTO `cupaiowps_audit_log` VALUES("36", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Advanced Custom Fields\",\"version\":\"6.5.0\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756284514", "");
INSERT INTO `cupaiowps_audit_log` VALUES("37", "1", "1", "", "54.36.142.130", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"akismet\",\"version\":\"5.5\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:68:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:478;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/update.php\";s:4:\"line\";i:861;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/update.php\";s:4:\"line\";i:304;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756303254", "");
INSERT INTO `cupaiowps_audit_log` VALUES("38", "1", "1", "vincent.voegel@ekno.fr", "46.218.227.220", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"vincent.voegel@ekno.fr\",\"known\":false}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:45:\"/home/xvgnwgb/check/wp-includes/pluggable.php\";s:4:\"line\";i:623;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1756389307", "");
INSERT INTO `cupaiowps_audit_log` VALUES("39", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1756389322", "");
INSERT INTO `cupaiowps_audit_log` VALUES("40", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1756391442", "");
INSERT INTO `cupaiowps_audit_log` VALUES("41", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Duplicate Page\",\"version\":\"4.5.5\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756397633", "");
INSERT INTO `cupaiowps_audit_log` VALUES("42", "1", "1", "Ekno", "46.218.227.220", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"duplicate-page\",\"version\":\"4.5.5\"}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756397634", "");
INSERT INTO `cupaiowps_audit_log` VALUES("43", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Duplicate Page\",\"version\":\"4.5.5\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756397638", "");
INSERT INTO `cupaiowps_audit_log` VALUES("44", "1", "1", "Ekno", "2a01:cb14:1692:5200:d811:a849:3080:527d", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1756451959", "");
INSERT INTO `cupaiowps_audit_log` VALUES("45", "1", "1", "Ekno", "2a01:cb14:1692:5200:d811:a849:3080:527d", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Contact Form 7\",\"version\":\"6.1.1\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756455976", "");
INSERT INTO `cupaiowps_audit_log` VALUES("46", "1", "1", "Ekno", "2a01:cb14:1692:5200:d811:a849:3080:527d", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"contact-form-7\",\"version\":\"6.1.1\"}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756455977", "");
INSERT INTO `cupaiowps_audit_log` VALUES("47", "1", "1", "Ekno", "2a01:cb14:1692:5200:d811:a849:3080:527d", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Contact Form 7\",\"version\":\"6.1.1\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756455984", "");
INSERT INTO `cupaiowps_audit_log` VALUES("48", "1", "1", "", "54.36.142.130", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"theme\",\"slug\":\"twentytwentyfive\",\"version\":\"1.3\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:68:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:478;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/update.php\";s:4:\"line\";i:861;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/update.php\";s:4:\"line\";i:304;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756476042", "");
INSERT INTO `cupaiowps_audit_log` VALUES("49", "1", "1", "Ekno", "2a01:cb14:1692:5200:69a8:8d72:e0b1:ac76", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1756484356", "");
INSERT INTO `cupaiowps_audit_log` VALUES("50", "1", "1", "", "54.36.142.130", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"core\",\"slug\":\"default\",\"version\":\"6.8.2\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:68:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:478;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/update.php\";s:4:\"line\";i:861;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/update.php\";s:4:\"line\";i:304;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756559841", "");
INSERT INTO `cupaiowps_audit_log` VALUES("51", "1", "1", "Ekno", "2a01:cb14:1692:5200:69a8:8d72:e0b1:ac76", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1756659825", "");
INSERT INTO `cupaiowps_audit_log` VALUES("52", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1756741053", "");
INSERT INTO `cupaiowps_audit_log` VALUES("53", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1756802597", "");
INSERT INTO `cupaiowps_audit_log` VALUES("54", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1756808986", "");
INSERT INTO `cupaiowps_audit_log` VALUES("55", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1756813263", "");
INSERT INTO `cupaiowps_audit_log` VALUES("56", "1", "1", "Ekno", "46.218.227.220", "warning", "plugin_deleted", "{\"plugin\":{\"name\":\"Wordfence Security\",\"version\":\"8.1.0\",\"action\":\"deleted\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4771;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756813295", "");
INSERT INTO `cupaiowps_audit_log` VALUES("57", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Complianz | GDPR\\/CCPA Cookie Consent\",\"version\":\"7.4.2\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756815114", "");
INSERT INTO `cupaiowps_audit_log` VALUES("58", "1", "1", "Ekno", "46.218.227.220", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"complianz-gdpr\",\"version\":\"7.4.2\"}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756815116", "");
INSERT INTO `cupaiowps_audit_log` VALUES("59", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Complianz\\u00a0|\\u00a0GDPR\\/CCPA Cookie Consent\",\"version\":\"7.4.2\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756815120", "");
INSERT INTO `cupaiowps_audit_log` VALUES("60", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Yoast SEO\",\"version\":\"25.8\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756816698", "");
INSERT INTO `cupaiowps_audit_log` VALUES("61", "1", "1", "Ekno", "46.218.227.220", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"version\":\"25.8\"}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756816700", "");
INSERT INTO `cupaiowps_audit_log` VALUES("62", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Yoast SEO\",\"version\":\"25.8\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756816705", "");
INSERT INTO `cupaiowps_audit_log` VALUES("63", "1", "1", "", "54.36.142.130", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"wordpress-seo\",\"version\":\"25.8\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:140;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:68:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:478;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:68:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:742;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/update.php\";s:4:\"line\";i:861;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/update.php\";s:4:\"line\";i:304;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1756967820", "");
INSERT INTO `cupaiowps_audit_log` VALUES("64", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1756991603", "");
INSERT INTO `cupaiowps_audit_log` VALUES("65", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1757072327", "");
INSERT INTO `cupaiowps_audit_log` VALUES("66", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1757076627", "");
INSERT INTO `cupaiowps_audit_log` VALUES("67", "1", "1", "Ekno", "2a01:cb14:1692:5200:8987:eaec:61ee:3fa5", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1757258121", "");
INSERT INTO `cupaiowps_audit_log` VALUES("68", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1757322388", "");
INSERT INTO `cupaiowps_audit_log` VALUES("69", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:105;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1757346033", "");
INSERT INTO `cupaiowps_audit_log` VALUES("70", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_installed", "{\"plugin\":{\"name\":\"LiteSpeed Cache\",\"version\":\"7.4\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1757412808", "");
INSERT INTO `cupaiowps_audit_log` VALUES("71", "1", "1", "Ekno", "46.218.227.220", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"litespeed-cache\",\"version\":\"7.4\"}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1757412810", "");
INSERT INTO `cupaiowps_audit_log` VALUES("72", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"LiteSpeed Cache\",\"version\":\"7.4\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1757412813", "");
INSERT INTO `cupaiowps_audit_log` VALUES("73", "1", "1", "webmaste@ekno.fr", "46.218.227.220", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"webmaste@ekno.fr\",\"known\":false}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:572;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:45:\"/home/xvgnwgb/check/wp-includes/pluggable.php\";s:4:\"line\";i:623;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:109;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:107;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:16;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1757421047", "");
INSERT INTO `cupaiowps_audit_log` VALUES("74", "1", "1", "Ekno", "46.218.227.220", "info", "successful_login", "{\"successful_login\":{\"username\":\"Ekno\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:620;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:622;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:667;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-includes/user.php\";s:4:\"line\";i:138;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:32:\"/home/xvgnwgb/check/wp-login.php\";s:4:\"line\";i:1323;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:72:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes/plugin.php\";s:4:\"line\";i:621;s:4:\"args\";a:1:{i:0;s:32:\"/home/xvgnwgb/check/wp-login.php\";}s:8:\"function\";s:12:\"require_once\";}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:9:\"wp_loaded\";s:5:\"class\";s:25:\"WPS\\WPS_Hide_Login\\Plugin\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:35:\"/home/xvgnwgb/check/wp-settings.php\";s:4:\"line\";i:749;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:4:\"line\";i:107;s:4:\"args\";a:1:{i:0;s:35:\"/home/xvgnwgb/check/wp-settings.php\";}s:8:\"function\";s:12:\"require_once\";}i:17;a:4:{s:4:\"file\";s:31:\"/home/xvgnwgb/check/wp-load.php\";s:4:\"line\";i:50;s:4:\"args\";a:1:{i:0;s:33:\"/home/xvgnwgb/check/wp-config.php\";}s:8:\"function\";s:12:\"require_once\";}i:18;a:4:{s:4:\"file\";s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";s:4:\"line\";i:13;s:4:\"args\";a:1:{i:0;s:31:\"/home/xvgnwgb/check/wp-load.php\";}s:8:\"function\";s:12:\"require_once\";}i:19;a:4:{s:4:\"file\";s:29:\"/home/xvgnwgb/check/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:38:\"/home/xvgnwgb/check/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1757421070", "");
INSERT INTO `cupaiowps_audit_log` VALUES("75", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_installed", "{\"plugin\":{\"name\":\"All-in-One WP Migration and Backup\",\"version\":\"7.99\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1757421093", "");
INSERT INTO `cupaiowps_audit_log` VALUES("76", "1", "1", "Ekno", "46.218.227.220", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"all-in-one-wp-migration\",\"version\":\"7.99\"}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1757421094", "");
INSERT INTO `cupaiowps_audit_log` VALUES("77", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"All-in-One WP Migration and Backup\",\"version\":\"7.99\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1757421105", "");
INSERT INTO `cupaiowps_audit_log` VALUES("78", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Yoast SEO\",\"version\":\"25.9\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:197;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:412;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4650;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1757423123", "");
INSERT INTO `cupaiowps_audit_log` VALUES("79", "1", "1", "Ekno", "46.218.227.220", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"All-in-One WP Migration and Backup\",\"version\":\"7.99\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1757423132", "");
INSERT INTO `cupaiowps_audit_log` VALUES("80", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Duplicator\",\"version\":\"1.5.13.2\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:164;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1757423161", "");
INSERT INTO `cupaiowps_audit_log` VALUES("81", "1", "1", "Ekno", "46.218.227.220", "info", "translation_updated", "{\"translation_updated\":{\"language\":\"fr_FR\",\"type\":\"plugin\",\"slug\":\"duplicator\",\"version\":\"1.5.13.2\"}}", "a:19:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:417;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:19:\"translation_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:280;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:70:\"/home/xvgnwgb/check/wp-admin/includes/class-language-pack-upgrader.php\";s:4:\"line\";i:104;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:326;s:8:\"function\";s:13:\"async_upgrade\";s:5:\"class\";s:22:\"Language_Pack_Upgrader\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:59:\"/home/xvgnwgb/check/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:988;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:63:\"/home/xvgnwgb/check/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:135;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4494;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1757423162", "");
INSERT INTO `cupaiowps_audit_log` VALUES("82", "1", "1", "Ekno", "46.218.227.220", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Duplicator\",\"version\":\"1.5.13.2\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:177;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:730;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1757423166", "");
INSERT INTO `cupaiowps_audit_log` VALUES("83", "1", "1", "Ekno", "46.218.227.220", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"LiteSpeed Cache\",\"version\":\"7.4\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:212;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:840;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:40:\"/home/xvgnwgb/check/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1757423307", "");
INSERT INTO `cupaiowps_audit_log` VALUES("84", "1", "1", "Ekno", "46.218.227.220", "warning", "plugin_deleted", "{\"plugin\":{\"name\":\"All-in-One WP Migration and Backup\",\"version\":\"7.99\",\"action\":\"deleted\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:273;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:238;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:48:\"/home/xvgnwgb/check/wp-admin/includes/plugin.php\";s:4:\"line\";i:1002;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:54:\"/home/xvgnwgb/check/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4771;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:49:\"/home/xvgnwgb/check/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:42:\"/home/xvgnwgb/check/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:43:\"/home/xvgnwgb/check/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1757423911", "");

/* INSERT TABLE DATA: cupaiowps_logged_in_users */
INSERT INTO `cupaiowps_logged_in_users` VALUES("5", "1", "Ekno", "46.218.227.220", "1", "1757258121", "1757593870");

/* INSERT TABLE DATA: cupcmplz_cookiebanners */
INSERT INTO `cupcmplz_cookiebanners` VALUES("1", "Bannière A", "17", "1", "bottom-right", "slider", "", "0", "1", "Gérer le consentement", "hover-hide-mobile", "a:2:{s:4:\"text\";s:22:\"Gérer le consentement\";s:4:\"show\";i:1;}", "a:2:{s:4:\"text\";s:7:\"Refuser\";s:4:\"show\";i:1;}", "Enregistrer les préférences", "Voir les préférences", "Fonctionnel", "a:2:{s:4:\"text\";s:9:\"Marketing\";s:4:\"show\";i:1;}", "a:2:{s:4:\"text\";s:12:\"Statistiques\";s:4:\"show\";i:1;}", "a:2:{s:4:\"text\";s:13:\"Préférences\";s:4:\"show\";i:1;}", "Accepter", "Pour offrir les meilleures expériences, nous utilisons des technologies telles que les cookies pour stocker et/ou accéder aux informations des appareils. Le fait de consentir à ces technologies nous permettra de traiter des données telles que le comportement de navigation ou les ID uniques sur ce site. Le fait de ne pas consentir ou de retirer son consentement peut avoir un effet négatif sur certaines caractéristiques et fonctions.", "view-preferences", "0", "526", "0", "0", "0", "10", "a:2:{s:4:\"text\";s:8:\"Accepter\";s:4:\"show\";i:1;}", "Pour offrir les meilleures expériences, nous utilisons des technologies telles que les cookies pour stocker et/ou accéder aux informations des appareils. Le fait de consentir à ces technologies nous permettra de traiter des données telles que le comportement de navigation ou les ID uniques sur ce site. Le fait de ne pas consentir ou de retirer son consentement peut avoir un effet négatif sur certaines caractéristiques et fonctions.", "0", "/* Container */\n.cmplz-cookiebanner{}\n\n/* Logo */\n.cmplz-cookiebanner .cmplz-logo{}\n/* Title */\n.cmplz-cookiebanner .cmplz-title{}\n/* Close icon */\n.cmplz-cookiebanner .cmplz-close{}\n\n/* Message */\n.cmplz-cookiebanner .cmplz-message{}\n\n /* All buttons */\n.cmplz-buttons .cmplz-btn{}\n/* Accept button */\n.cmplz-btn .cmplz-accept{} \n /* Deny button */\n.cmplz-btn .cmplz-deny{}\n /* Save preferences button */\n.cmplz-btn .cmplz-deny{}\n /* View preferences button */\n.cmplz-btn .cmplz-deny{}\n\n /* Document hyperlinks */\n.cmplz-links .cmplz-documents{}\n\n /* Categories */\n.cmplz-cookiebanner .cmplz-category{}\n.cmplz-cookiebanner .cmplz-category-title{} \n\n/* Manage consent tab */\n#cmplz-manage-consent .cmplz-manage-consent{} \n\n/* Soft cookie wall */\n.cmplz-soft-cookiewall{}\n\n/* Placeholder button - Per category */\n.cmplz-blocked-content-container .cmplz-blocked-content-notice{}\n\n/* Placeholder button & message - Per service */\n.cmplz-blocked-content-container .cmplz-blocked-content-notice,\n.cmplz-blocked-content-notice{}\nbutton.cmplz-accept-service{}\n\n/* Styles for the AMP notice */\n#cmplz-consent-ui, #cmplz-post-consent-ui {}\n/* Message */\n#cmplz-consent-ui .cmplz-consent-message {}\n/* Buttons */\n#cmplz-consent-ui button, #cmplz-post-consent-ui button {}", "a:0:{}", "a:2:{s:4:\"text\";s:341:\"L’accès ou le stockage technique est strictement nécessaire dans la finalité d’intérêt légitime de permettre l’utilisation d’un service spécifique explicitement demandé par l’abonné ou l’utilisateur, ou dans le seul but d’effectuer la transmission d’une communication sur un réseau de communications électroniques.\";s:4:\"show\";i:1;}", "a:2:{s:4:\"text\";s:92:\"Le stockage ou l’accès technique qui est utilisé exclusivement à des fins statistiques.\";s:4:\"show\";i:1;}", "a:2:{s:4:\"text\";s:448:\"Le stockage ou l’accès technique qui est utilisé exclusivement dans des finalités statistiques anonymes. En l’absence d’une assignation à comparaître, d’une conformité volontaire de la part de votre fournisseur d’accès à internet ou d’enregistrements supplémentaires provenant d’une tierce partie, les informations stockées ou extraites à cette seule fin ne peuvent généralement pas être utilisées pour vous identifier.\";s:4:\"show\";i:1;}", "a:2:{s:4:\"text\";s:184:\"L’accès ou le stockage technique est nécessaire dans la finalité d’intérêt légitime de stocker des préférences qui ne sont pas demandées par l’abonné ou l’internaute.\";s:4:\"show\";i:1;}", "a:2:{s:4:\"text\";s:242:\"L’accès ou le stockage technique est nécessaire pour créer des profils d’internautes afin d’envoyer des publicités, ou pour suivre l’utilisateur sur un site web ou sur plusieurs sites web ayant des finalités marketing similaires.\";s:4:\"show\";i:1;}", "a:2:{s:5:\"color\";s:7:\"#ffffff\";s:6:\"border\";s:7:\"#f2f2f2\";}", "a:2:{s:5:\"color\";s:7:\"#222222\";s:9:\"hyperlink\";s:7:\"#1E73BE\";}", "a:3:{s:10:\"background\";s:7:\"#1e73be\";s:6:\"bullet\";s:7:\"#ffffff\";s:8:\"inactive\";s:7:\"#F56E28\";}", "a:5:{s:3:\"top\";i:12;s:5:\"right\";i:12;s:6:\"bottom\";i:12;s:4:\"left\";i:12;s:4:\"type\";s:2:\"px\";}", "a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}", "12", "a:3:{s:10:\"background\";s:7:\"#1E73BE\";s:6:\"border\";s:7:\"#1E73BE\";s:4:\"text\";s:7:\"#ffffff\";}", "a:3:{s:10:\"background\";s:7:\"#f9f9f9\";s:6:\"border\";s:7:\"#f2f2f2\";s:4:\"text\";s:7:\"#222222\";}", "a:3:{s:10:\"background\";s:7:\"#f9f9f9\";s:6:\"border\";s:7:\"#f2f2f2\";s:4:\"text\";s:7:\"#333333\";}", "a:5:{s:3:\"top\";i:6;s:5:\"right\";i:6;s:6:\"bottom\";i:6;s:4:\"left\";i:6;s:4:\"type\";s:2:\"px\";}", "none", "1", "0", "0", "0", "1");

/* INSERT TABLE DATA: cupcmplz_cookies */
INSERT INTO `cupcmplz_cookies` VALUES("1", "stk__columns_new_duplicate", "", "1", "0", "", "", "0", "", "", "", "fr", "12", "0", "self", "0", "0", "1", "0", "1757331231", "1757331230");
INSERT INTO `cupcmplz_cookies` VALUES("2", "stk__design_library__block-list__view_by", "", "1", "0", "", "", "0", "", "", "", "fr", "13", "0", "self", "0", "0", "1", "0", "1757331231", "1757331230");
INSERT INTO `cupcmplz_cookies` VALUES("3", "stk__design_library__version", "", "1", "0", "", "", "0", "", "", "", "fr", "14", "0", "self", "0", "0", "1", "0", "1757331231", "1757331230");
INSERT INTO `cupcmplz_cookies` VALUES("4", "acf", "acf", "1", "1", "aucune", "", "2", "Fournir des fonctions sur toutes les pages", "aucune", "", "fr", "15", "0", "self", "0", "0", "1", "1757331233", "1757331231", "1757331230");
INSERT INTO `cupcmplz_cookies` VALUES("5", "stk__design_library__block-list__selected", "", "1", "0", "", "", "0", "", "", "", "fr", "19", "0", "self", "0", "0", "1", "0", "1757331231", "1757331230");
INSERT INTO `cupcmplz_cookies` VALUES("6", "cmplz_functional", "cmplz_functional", "1", "0", "365 jours", "", "6", "Stocker les préférences de consentement aux cookies", "aucune", "Fonctionnel", "fr", "31", "0", "thirdparty", "0", "0", "1", "1757331233", "1757331230", "1757331230");
INSERT INTO `cupcmplz_cookies` VALUES("7", "cmplz_statistics", "cmplz_statistics", "1", "0", "365 jours", "", "6", "Stocker les préférences de consentement aux cookies", "aucune", "Fonctionnel", "fr", "32", "0", "thirdparty", "0", "0", "1", "1757331233", "1757331230", "1757331230");
INSERT INTO `cupcmplz_cookies` VALUES("8", "cmplz_preferences", "cmplz_preferences", "1", "0", "365 jours", "", "6", "Stocker les préférences de consentement aux cookies", "aucune", "Fonctionnel", "fr", "33", "0", "thirdparty", "0", "0", "1", "1757331233", "1757331230", "1757331230");
INSERT INTO `cupcmplz_cookies` VALUES("9", "cmplz_marketing", "cmplz_marketing", "1", "0", "365 jours", "", "6", "Stocker les préférences de consentement aux cookies", "aucune", "Fonctionnel", "fr", "34", "0", "thirdparty", "0", "0", "1", "1757331233", "1757331230", "1757331230");
INSERT INTO `cupcmplz_cookies` VALUES("10", "WP_DATA_USER_1", "wp_data_user_1", "1", "1", "divers", "", "4", "Fournir des fonctions d’administration", "", "Fonctionnel", "fr", "16", "0", "self", "0", "0", "1", "1757331247", "1757331231", "1757331230");
INSERT INTO `cupcmplz_cookies` VALUES("11", "wpEmojiSettingsSupports", "wpemojisettingssupports", "1", "0", "session", "", "4", "Stocker les informations du navigateur", "aucune", "Fonctionnel", "fr", "20", "0", "self", "0", "0", "1", "1757331247", "1757331231", "1757331230");
INSERT INTO `cupcmplz_cookies` VALUES("12", "stk__columns_new_duplicate", "", "1", "0", "", "localstorage", "0", "", "", "", "en", "0", "0", "self", "0", "0", "1", "0", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("13", "stk__design_library__block-list__view_by", "", "1", "0", "", "localstorage", "0", "", "", "", "en", "0", "0", "self", "0", "0", "1", "0", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("14", "stk__design_library__version", "", "1", "0", "", "localstorage", "0", "", "", "", "en", "0", "0", "self", "0", "0", "1", "0", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("15", "acf", "acf", "1", "1", "expires immediately", "", "1", "provide functions across pages", "none", "", "en", "0", "0", "self", "0", "0", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("16", "WP_DATA_USER_1", "wp_data_user_1", "1", "1", "various", "Cookie", "3", "provide admin functions", "", "Functional", "en", "0", "0", "self", "0", "0", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("17", "WP_PREFERENCES_USER_*", "wp_preferences_user_", "1", "0", "persistent", "Local Storage", "3", "store user preferences", "none", "Functional", "en", "0", "0", "self", "0", "1", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("18", "WP_PREFERENCES_USER_*", "wp_preferences_user_", "1", "0", "persistante", "", "4", "Stocker les préférences des utilisateurs", "aucune", "Fonctionnel", "fr", "17", "0", "self", "0", "1", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("19", "stk__design_library__block-list__selected", "", "1", "0", "", "localstorage", "0", "", "", "", "en", "0", "0", "self", "0", "0", "1", "0", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("20", "wpEmojiSettingsSupports", "wpemojisettingssupports", "1", "0", "session", "Cookie", "3", "store browser details", "none", "Functional", "en", "0", "0", "self", "0", "0", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("21", "cmplz_banner-status", "cmplz_banner-status", "1", "0", "365 jours", "Cookie", "5", "store if the cookie banner has been dismissed", "none", "Functional", "en", "0", "0", "self", "0", "0", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("22", "cmplz_banner-status", "cmplz_banner-status", "1", "0", "365 jours", "", "6", "Mémorise si la bannière des cookies a été refusée", "aucune", "Fonctionnel", "fr", "21", "0", "self", "0", "0", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("23", "wp-settings-*", "wp-settings", "1", "0", "persistent", "", "3", "store user preferences", "", "Functional", "en", "0", "0", "self", "0", "1", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("24", "wp-settings-*", "wp-settings", "1", "0", "persistante", "", "4", "Stocker les préférences des utilisateurs", "", "Fonctionnel", "fr", "23", "0", "self", "0", "1", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("25", "wp-settings-time-*", "wp-settings-time", "1", "0", "1 year", "", "3", "store user preferences", "", "Functional", "en", "0", "0", "self", "0", "1", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("26", "wp-settings-time-*", "wp-settings-time", "1", "0", "1 an", "", "4", "Stocker les préférences des utilisateurs", "", "Fonctionnel", "fr", "25", "0", "self", "0", "1", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("27", "wordpress_logged_in_*", "wordpress_logged_in_", "1", "0", "persistent", "", "3", "Store logged in users", "", "Functional", "en", "0", "0", "self", "0", "1", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("28", "wordpress_logged_in_*", "wordpress_logged_in_", "1", "0", "persistante", "", "4", "Garder les utilisateurs connectés", "", "Fonctionnel", "fr", "27", "0", "self", "0", "1", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("29", "wordpress_test_cookie", "wordpress_test_cookie", "1", "0", "session", "Cookie", "3", "read if cookies can be placed", "", "Functional", "en", "0", "0", "self", "0", "1", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("30", "wordpress_test_cookie", "wordpress_test_cookie", "1", "0", "session", "", "4", "Vérifier si des cookies peuvent être déposés", "", "Fonctionnel", "fr", "29", "0", "self", "0", "1", "1", "1757331247", "1757331231", "1757331231");
INSERT INTO `cupcmplz_cookies` VALUES("31", "cmplz_functional", "cmplz_functional", "1", "0", "365 jours", "Cookie", "5", "store cookie consent preferences", "none", "Functional", "en", "0", "0", "thirdparty", "0", "0", "1", "1757331233", "0", "1757331233");
INSERT INTO `cupcmplz_cookies` VALUES("32", "cmplz_statistics", "cmplz_statistics", "1", "0", "365 jours", "Cookie", "5", "store cookie consent preferences", "none", "Functional", "en", "0", "0", "thirdparty", "0", "0", "1", "1757331233", "0", "1757331233");
INSERT INTO `cupcmplz_cookies` VALUES("33", "cmplz_preferences", "cmplz_preferences", "1", "0", "365 jours", "Cookie", "5", "store cookie consent preferences", "none", "Functional", "en", "0", "0", "thirdparty", "0", "0", "1", "1757331233", "0", "1757331233");
INSERT INTO `cupcmplz_cookies` VALUES("34", "cmplz_marketing", "cmplz_marketing", "1", "0", "365 jours", "Cookie", "5", "store cookie consent preferences", "none", "Functional", "en", "0", "0", "thirdparty", "0", "0", "1", "1757331233", "0", "1757331233");

/* INSERT TABLE DATA: cupcmplz_services */
INSERT INTO `cupcmplz_services` VALUES("1", "Advanced Custom Fields", "advanced-custom-fields", "content creation", "", "0", "0", "0", "", "en", "0", "1", "1757331243");
INSERT INTO `cupcmplz_services` VALUES("2", "Advanced Custom Fields", "advanced-custom-fields", "content creation", "", "0", "0", "0", "", "fr", "1", "1", "1757331243");
INSERT INTO `cupcmplz_services` VALUES("3", "WordPress", "wordpress", "website development", "", "0", "0", "0", "", "en", "0", "1", "1757331243");
INSERT INTO `cupcmplz_services` VALUES("4", "WordPress", "wordpress", "le développement du site web", "", "0", "0", "0", "", "fr", "3", "1", "1757331243");
INSERT INTO `cupcmplz_services` VALUES("5", "Complianz", "complianz", "cookie consent management", "", "0", "0", "0", "https://complianz.io/legal/privacy-statement/", "en", "0", "1", "1757331243");
INSERT INTO `cupcmplz_services` VALUES("6", "Complianz", "complianz", "la gestion du consentement aux cookies", "", "0", "0", "0", "https://complianz.io/legal/privacy-statement/", "fr", "5", "1", "1757331243");

/* INSERT TABLE DATA: cupcomments */
INSERT INTO `cupcomments` VALUES("1", "1", "Un commentateur ou commentatrice WordPress", "wapuu@wordpress.example", "https://fr.wordpress.org/", "", "2025-07-22 15:00:37", "2025-07-22 13:00:37", "Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://fr.gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: cupduplicator_packages */
INSERT INTO `cupduplicator_packages` VALUES("7", "20250909_checkup", "e72b55459130c1687111_20250909132535", "24", "2025-09-09 13:25:41", "Ekno", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-09-09 13:25:35\";s:7:\"Version\";s:8:\"1.5.13.2\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.42\";s:10:\"VersionPHP\";s:6:\"8.4.10\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:7;s:4:\"Name\";s:16:\"20250909_checkup\";s:4:\"Hash\";s:35:\"e72b55459130c1687111_20250909132535\";s:8:\"NameHash\";s:52:\"20250909_checkup_e72b55459130c1687111_20250909132535\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:62:\"20250909_checkup_e72b55459130c1687111_20250909132535_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"24.4\";s:6:\"WPUser\";s:4:\"Ekno\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:64:\"20250909_checkup_e72b55459130c1687111_20250909132535_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:19:\"/home/xvgnwgb/check\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1458;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:9856;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-09-09 13:25:35\";s:7:\"Version\";s:8:\"1.5.13.2\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:6:\"8.0.42\";s:10:\"VersionPHP\";s:6:\"8.4.10\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:16:\"20250909_checkup\";s:4:\"Hash\";s:35:\"e72b55459130c1687111_20250909132535\";s:8:\"NameHash\";s:52:\"20250909_checkup_e72b55459130c1687111_20250909132535\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:70:\"20250909_checkup_e72b55459130c1687111_20250909132535_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:33:\"/home/xvgnwgb/check/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:65:\"20250909_checkup_e72b55459130c1687111_20250909132535_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:55:\"Percona Server (GPL), Release \'33\', Revision \'9dc49998\'\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:117:\"/home/xvgnwgb/check/wp-content/backups-dup-lite/tmp/20250909_checkup_e72b55459130c1687111_20250909132535_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:28:\"/home/xvgnwgb/check/wp-admin\";i:1;s:31:\"/home/xvgnwgb/check/wp-includes\";i:2;s:40:\"/home/xvgnwgb/check/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:19:\"/home/xvgnwgb/check\";i:1;s:19:\"/home/xvgnwgb/check\";i:2;s:30:\"/home/xvgnwgb/check/wp-content\";i:3;s:38:\"/home/xvgnwgb/check/wp-content/uploads\";i:4;s:38:\"/home/xvgnwgb/check/wp-content/plugins\";i:5;s:41:\"/home/xvgnwgb/check/wp-content/mu-plugins\";i:6;s:37:\"/home/xvgnwgb/check/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:51:\"/home/xvgnwgb/check/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: cupoptions */
INSERT INTO `cupoptions` VALUES("1", "cron", "a:22:{i:1757424887;a:1:{s:26:\"aios_15_minutes_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"aios-every-15-minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1757426437;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757426438;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1757426687;a:1:{s:24:\"aiowps_hourly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1757428237;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757430037;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757433887;a:2:{s:23:\"aiowps_daily_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:23:\"aiowps_clean_old_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757466052;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1757494114;a:1:{s:27:\"acf_update_site_health_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757506320;a:2:{s:20:\"cmplz_every_day_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"cmplz_daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:29:\"cmplz_every_five_minutes_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:18:\"cmplz_five_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757507506;a:0:{}i:1757507905;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757509238;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757509252;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757509254;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1757937600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757952287;a:1:{s:24:\"aiowps_weekly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1757976581;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1758024720;a:1:{s:21:\"cmplz_every_week_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"cmplz_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1758027669;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1759407120;a:1:{s:22:\"cmplz_every_month_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:13:\"cmplz_monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `cupoptions` VALUES("2", "siteurl", "https://up.thera.fr", "on");
INSERT INTO `cupoptions` VALUES("3", "home", "https://up.thera.fr", "on");
INSERT INTO `cupoptions` VALUES("4", "blogname", "Check-up", "on");
INSERT INTO `cupoptions` VALUES("5", "blogdescription", "", "on");
INSERT INTO `cupoptions` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `cupoptions` VALUES("7", "admin_email", "webmaster@ekno.fr", "on");
INSERT INTO `cupoptions` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `cupoptions` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `cupoptions` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `cupoptions` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `cupoptions` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `cupoptions` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `cupoptions` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `cupoptions` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `cupoptions` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `cupoptions` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `cupoptions` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `cupoptions` VALUES("19", "default_category", "1", "on");
INSERT INTO `cupoptions` VALUES("20", "default_comment_status", "closed", "on");
INSERT INTO `cupoptions` VALUES("21", "default_ping_status", "closed", "on");
INSERT INTO `cupoptions` VALUES("22", "default_pingback_flag", "0", "on");
INSERT INTO `cupoptions` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `cupoptions` VALUES("24", "date_format", "j F Y", "on");
INSERT INTO `cupoptions` VALUES("25", "time_format", "G\\hi", "on");
INSERT INTO `cupoptions` VALUES("26", "links_updated_date_format", "d F Y G\\hi", "on");
INSERT INTO `cupoptions` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `cupoptions` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `cupoptions` VALUES("29", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "on");
INSERT INTO `cupoptions` VALUES("30", "rewrite_rules", "a:98:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=2&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "on");
INSERT INTO `cupoptions` VALUES("31", "hack_file", "0", "on");
INSERT INTO `cupoptions` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `cupoptions` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `cupoptions` VALUES("34", "active_plugins", "a:14:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:3;s:33:\"complianz-gdpr/complianz-gpdr.php\";i:4;s:36:\"contact-form-7/wp-contact-form-7.php\";i:5;s:29:\"daisy-titles/daisy-titles.php\";i:6;s:32:\"duplicate-page/duplicatepage.php\";i:7;s:25:\"duplicator/duplicator.php\";i:9;s:46:\"stackable-ultimate-gutenberg-blocks/plugin.php\";i:10;s:27:\"svg-support/svg-support.php\";i:11;s:31:\"timeline-block-block/plugin.php\";i:12;s:33:\"timeline-block/timeline-block.php\";i:13;s:24:\"wordpress-seo/wp-seo.php\";i:14;s:33:\"wps-hide-login/wps-hide-login.php\";}", "on");
INSERT INTO `cupoptions` VALUES("35", "category_base", "", "on");
INSERT INTO `cupoptions` VALUES("36", "ping_sites", "http://rpc.pingomatic.com/", "on");
INSERT INTO `cupoptions` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `cupoptions` VALUES("38", "gmt_offset", "", "on");
INSERT INTO `cupoptions` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `cupoptions` VALUES("40", "recently_edited", "a:5:{i:0;s:56:\"/home/xvgnwgb/check/wp-content/themes/checkup/header.php\";i:2;s:55:\"/home/xvgnwgb/check/wp-content/themes/checkup/style.css\";i:3;s:56:\"/home/xvgnwgb/check/wp-content/themes/checkup/footer.php\";i:4;s:59:\"/home/xvgnwgb/check/wp-content/themes/checkup/functions.php\";i:5;s:0:\"\";}", "off");
INSERT INTO `cupoptions` VALUES("41", "template", "checkup", "on");
INSERT INTO `cupoptions` VALUES("42", "stylesheet", "checkup", "on");
INSERT INTO `cupoptions` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `cupoptions` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `cupoptions` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `cupoptions` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `cupoptions` VALUES("47", "db_version", "60421", "on");
INSERT INTO `cupoptions` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `cupoptions` VALUES("49", "upload_path", "", "on");
INSERT INTO `cupoptions` VALUES("50", "blog_public", "0", "on");
INSERT INTO `cupoptions` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `cupoptions` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `cupoptions` VALUES("53", "tag_base", "", "on");
INSERT INTO `cupoptions` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `cupoptions` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `cupoptions` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `cupoptions` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `cupoptions` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `cupoptions` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `cupoptions` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `cupoptions` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `cupoptions` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `cupoptions` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `cupoptions` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `cupoptions` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `cupoptions` VALUES("66", "image_default_size", "", "on");
INSERT INTO `cupoptions` VALUES("67", "image_default_align", "", "on");
INSERT INTO `cupoptions` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `cupoptions` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `cupoptions` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `cupoptions` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `cupoptions` VALUES("72", "page_comments", "0", "on");
INSERT INTO `cupoptions` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `cupoptions` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `cupoptions` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `cupoptions` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `cupoptions` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("80", "uninstall_plugins", "a:5:{s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";a:2:{i:0;s:15:\"AIO_WP_Security\";i:1;s:17:\"uninstall_handler\";}s:29:\"daisy-titles/daisy-titles.php\";s:22:\"daisy_titles_uninstall\";s:27:\"hide-titles/hide-titles.php\";s:21:\"hide_titles_uninstall\";s:24:\"wordpress-seo/wp-seo.php\";s:14:\"__return_false\";s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";}", "off");
INSERT INTO `cupoptions` VALUES("81", "timezone_string", "Europe/Paris", "on");
INSERT INTO `cupoptions` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `cupoptions` VALUES("83", "page_on_front", "2", "on");
INSERT INTO `cupoptions` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `cupoptions` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `cupoptions` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `cupoptions` VALUES("87", "site_icon", "102", "on");
INSERT INTO `cupoptions` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `cupoptions` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `cupoptions` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `cupoptions` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `cupoptions` VALUES("92", "admin_email_lifespan", "1768741237", "on");
INSERT INTO `cupoptions` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `cupoptions` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `cupoptions` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `cupoptions` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `cupoptions` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `cupoptions` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `cupoptions` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `cupoptions` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `cupoptions` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `cupoptions` VALUES("102", "cupuser_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:66:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:14:\"manage_privacy\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}}", "on");
INSERT INTO `cupoptions` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `cupoptions` VALUES("104", "WPLANG", "fr_FR", "auto");
INSERT INTO `cupoptions` VALUES("105", "user_count", "1", "off");
INSERT INTO `cupoptions` VALUES("106", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Articles récents</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Commentaires récents</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:151:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Catégories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("107", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `cupoptions` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("110", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("115", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("116", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("117", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("122", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.8.2\";s:5:\"files\";a:536:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:26:\"post-content/style-rtl.css\";i:309;s:30:\"post-content/style-rtl.min.css\";i:310;s:22:\"post-content/style.css\";i:311;s:26:\"post-content/style.min.css\";i:312;s:23:\"post-date/style-rtl.css\";i:313;s:27:\"post-date/style-rtl.min.css\";i:314;s:19:\"post-date/style.css\";i:315;s:23:\"post-date/style.min.css\";i:316;s:27:\"post-excerpt/editor-rtl.css\";i:317;s:31:\"post-excerpt/editor-rtl.min.css\";i:318;s:23:\"post-excerpt/editor.css\";i:319;s:27:\"post-excerpt/editor.min.css\";i:320;s:26:\"post-excerpt/style-rtl.css\";i:321;s:30:\"post-excerpt/style-rtl.min.css\";i:322;s:22:\"post-excerpt/style.css\";i:323;s:26:\"post-excerpt/style.min.css\";i:324;s:34:\"post-featured-image/editor-rtl.css\";i:325;s:38:\"post-featured-image/editor-rtl.min.css\";i:326;s:30:\"post-featured-image/editor.css\";i:327;s:34:\"post-featured-image/editor.min.css\";i:328;s:33:\"post-featured-image/style-rtl.css\";i:329;s:37:\"post-featured-image/style-rtl.min.css\";i:330;s:29:\"post-featured-image/style.css\";i:331;s:33:\"post-featured-image/style.min.css\";i:332;s:34:\"post-navigation-link/style-rtl.css\";i:333;s:38:\"post-navigation-link/style-rtl.min.css\";i:334;s:30:\"post-navigation-link/style.css\";i:335;s:34:\"post-navigation-link/style.min.css\";i:336;s:27:\"post-template/style-rtl.css\";i:337;s:31:\"post-template/style-rtl.min.css\";i:338;s:23:\"post-template/style.css\";i:339;s:27:\"post-template/style.min.css\";i:340;s:24:\"post-terms/style-rtl.css\";i:341;s:28:\"post-terms/style-rtl.min.css\";i:342;s:20:\"post-terms/style.css\";i:343;s:24:\"post-terms/style.min.css\";i:344;s:24:\"post-title/style-rtl.css\";i:345;s:28:\"post-title/style-rtl.min.css\";i:346;s:20:\"post-title/style.css\";i:347;s:24:\"post-title/style.min.css\";i:348;s:26:\"preformatted/style-rtl.css\";i:349;s:30:\"preformatted/style-rtl.min.css\";i:350;s:22:\"preformatted/style.css\";i:351;s:26:\"preformatted/style.min.css\";i:352;s:24:\"pullquote/editor-rtl.css\";i:353;s:28:\"pullquote/editor-rtl.min.css\";i:354;s:20:\"pullquote/editor.css\";i:355;s:24:\"pullquote/editor.min.css\";i:356;s:23:\"pullquote/style-rtl.css\";i:357;s:27:\"pullquote/style-rtl.min.css\";i:358;s:19:\"pullquote/style.css\";i:359;s:23:\"pullquote/style.min.css\";i:360;s:23:\"pullquote/theme-rtl.css\";i:361;s:27:\"pullquote/theme-rtl.min.css\";i:362;s:19:\"pullquote/theme.css\";i:363;s:23:\"pullquote/theme.min.css\";i:364;s:39:\"query-pagination-numbers/editor-rtl.css\";i:365;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:366;s:35:\"query-pagination-numbers/editor.css\";i:367;s:39:\"query-pagination-numbers/editor.min.css\";i:368;s:31:\"query-pagination/editor-rtl.css\";i:369;s:35:\"query-pagination/editor-rtl.min.css\";i:370;s:27:\"query-pagination/editor.css\";i:371;s:31:\"query-pagination/editor.min.css\";i:372;s:30:\"query-pagination/style-rtl.css\";i:373;s:34:\"query-pagination/style-rtl.min.css\";i:374;s:26:\"query-pagination/style.css\";i:375;s:30:\"query-pagination/style.min.css\";i:376;s:25:\"query-title/style-rtl.css\";i:377;s:29:\"query-title/style-rtl.min.css\";i:378;s:21:\"query-title/style.css\";i:379;s:25:\"query-title/style.min.css\";i:380;s:25:\"query-total/style-rtl.css\";i:381;s:29:\"query-total/style-rtl.min.css\";i:382;s:21:\"query-total/style.css\";i:383;s:25:\"query-total/style.min.css\";i:384;s:20:\"query/editor-rtl.css\";i:385;s:24:\"query/editor-rtl.min.css\";i:386;s:16:\"query/editor.css\";i:387;s:20:\"query/editor.min.css\";i:388;s:19:\"quote/style-rtl.css\";i:389;s:23:\"quote/style-rtl.min.css\";i:390;s:15:\"quote/style.css\";i:391;s:19:\"quote/style.min.css\";i:392;s:19:\"quote/theme-rtl.css\";i:393;s:23:\"quote/theme-rtl.min.css\";i:394;s:15:\"quote/theme.css\";i:395;s:19:\"quote/theme.min.css\";i:396;s:23:\"read-more/style-rtl.css\";i:397;s:27:\"read-more/style-rtl.min.css\";i:398;s:19:\"read-more/style.css\";i:399;s:23:\"read-more/style.min.css\";i:400;s:18:\"rss/editor-rtl.css\";i:401;s:22:\"rss/editor-rtl.min.css\";i:402;s:14:\"rss/editor.css\";i:403;s:18:\"rss/editor.min.css\";i:404;s:17:\"rss/style-rtl.css\";i:405;s:21:\"rss/style-rtl.min.css\";i:406;s:13:\"rss/style.css\";i:407;s:17:\"rss/style.min.css\";i:408;s:21:\"search/editor-rtl.css\";i:409;s:25:\"search/editor-rtl.min.css\";i:410;s:17:\"search/editor.css\";i:411;s:21:\"search/editor.min.css\";i:412;s:20:\"search/style-rtl.css\";i:413;s:24:\"search/style-rtl.min.css\";i:414;s:16:\"search/style.css\";i:415;s:20:\"search/style.min.css\";i:416;s:20:\"search/theme-rtl.css\";i:417;s:24:\"search/theme-rtl.min.css\";i:418;s:16:\"search/theme.css\";i:419;s:20:\"search/theme.min.css\";i:420;s:24:\"separator/editor-rtl.css\";i:421;s:28:\"separator/editor-rtl.min.css\";i:422;s:20:\"separator/editor.css\";i:423;s:24:\"separator/editor.min.css\";i:424;s:23:\"separator/style-rtl.css\";i:425;s:27:\"separator/style-rtl.min.css\";i:426;s:19:\"separator/style.css\";i:427;s:23:\"separator/style.min.css\";i:428;s:23:\"separator/theme-rtl.css\";i:429;s:27:\"separator/theme-rtl.min.css\";i:430;s:19:\"separator/theme.css\";i:431;s:23:\"separator/theme.min.css\";i:432;s:24:\"shortcode/editor-rtl.css\";i:433;s:28:\"shortcode/editor-rtl.min.css\";i:434;s:20:\"shortcode/editor.css\";i:435;s:24:\"shortcode/editor.min.css\";i:436;s:24:\"site-logo/editor-rtl.css\";i:437;s:28:\"site-logo/editor-rtl.min.css\";i:438;s:20:\"site-logo/editor.css\";i:439;s:24:\"site-logo/editor.min.css\";i:440;s:23:\"site-logo/style-rtl.css\";i:441;s:27:\"site-logo/style-rtl.min.css\";i:442;s:19:\"site-logo/style.css\";i:443;s:23:\"site-logo/style.min.css\";i:444;s:27:\"site-tagline/editor-rtl.css\";i:445;s:31:\"site-tagline/editor-rtl.min.css\";i:446;s:23:\"site-tagline/editor.css\";i:447;s:27:\"site-tagline/editor.min.css\";i:448;s:26:\"site-tagline/style-rtl.css\";i:449;s:30:\"site-tagline/style-rtl.min.css\";i:450;s:22:\"site-tagline/style.css\";i:451;s:26:\"site-tagline/style.min.css\";i:452;s:25:\"site-title/editor-rtl.css\";i:453;s:29:\"site-title/editor-rtl.min.css\";i:454;s:21:\"site-title/editor.css\";i:455;s:25:\"site-title/editor.min.css\";i:456;s:24:\"site-title/style-rtl.css\";i:457;s:28:\"site-title/style-rtl.min.css\";i:458;s:20:\"site-title/style.css\";i:459;s:24:\"site-title/style.min.css\";i:460;s:26:\"social-link/editor-rtl.css\";i:461;s:30:\"social-link/editor-rtl.min.css\";i:462;s:22:\"social-link/editor.css\";i:463;s:26:\"social-link/editor.min.css\";i:464;s:27:\"social-links/editor-rtl.css\";i:465;s:31:\"social-links/editor-rtl.min.css\";i:466;s:23:\"social-links/editor.css\";i:467;s:27:\"social-links/editor.min.css\";i:468;s:26:\"social-links/style-rtl.css\";i:469;s:30:\"social-links/style-rtl.min.css\";i:470;s:22:\"social-links/style.css\";i:471;s:26:\"social-links/style.min.css\";i:472;s:21:\"spacer/editor-rtl.css\";i:473;s:25:\"spacer/editor-rtl.min.css\";i:474;s:17:\"spacer/editor.css\";i:475;s:21:\"spacer/editor.min.css\";i:476;s:20:\"spacer/style-rtl.css\";i:477;s:24:\"spacer/style-rtl.min.css\";i:478;s:16:\"spacer/style.css\";i:479;s:20:\"spacer/style.min.css\";i:480;s:20:\"table/editor-rtl.css\";i:481;s:24:\"table/editor-rtl.min.css\";i:482;s:16:\"table/editor.css\";i:483;s:20:\"table/editor.min.css\";i:484;s:19:\"table/style-rtl.css\";i:485;s:23:\"table/style-rtl.min.css\";i:486;s:15:\"table/style.css\";i:487;s:19:\"table/style.min.css\";i:488;s:19:\"table/theme-rtl.css\";i:489;s:23:\"table/theme-rtl.min.css\";i:490;s:15:\"table/theme.css\";i:491;s:19:\"table/theme.min.css\";i:492;s:24:\"tag-cloud/editor-rtl.css\";i:493;s:28:\"tag-cloud/editor-rtl.min.css\";i:494;s:20:\"tag-cloud/editor.css\";i:495;s:24:\"tag-cloud/editor.min.css\";i:496;s:23:\"tag-cloud/style-rtl.css\";i:497;s:27:\"tag-cloud/style-rtl.min.css\";i:498;s:19:\"tag-cloud/style.css\";i:499;s:23:\"tag-cloud/style.min.css\";i:500;s:28:\"template-part/editor-rtl.css\";i:501;s:32:\"template-part/editor-rtl.min.css\";i:502;s:24:\"template-part/editor.css\";i:503;s:28:\"template-part/editor.min.css\";i:504;s:27:\"template-part/theme-rtl.css\";i:505;s:31:\"template-part/theme-rtl.min.css\";i:506;s:23:\"template-part/theme.css\";i:507;s:27:\"template-part/theme.min.css\";i:508;s:30:\"term-description/style-rtl.css\";i:509;s:34:\"term-description/style-rtl.min.css\";i:510;s:26:\"term-description/style.css\";i:511;s:30:\"term-description/style.min.css\";i:512;s:27:\"text-columns/editor-rtl.css\";i:513;s:31:\"text-columns/editor-rtl.min.css\";i:514;s:23:\"text-columns/editor.css\";i:515;s:27:\"text-columns/editor.min.css\";i:516;s:26:\"text-columns/style-rtl.css\";i:517;s:30:\"text-columns/style-rtl.min.css\";i:518;s:22:\"text-columns/style.css\";i:519;s:26:\"text-columns/style.min.css\";i:520;s:19:\"verse/style-rtl.css\";i:521;s:23:\"verse/style-rtl.min.css\";i:522;s:15:\"verse/style.css\";i:523;s:19:\"verse/style.min.css\";i:524;s:20:\"video/editor-rtl.css\";i:525;s:24:\"video/editor-rtl.min.css\";i:526;s:16:\"video/editor.css\";i:527;s:20:\"video/editor.min.css\";i:528;s:19:\"video/style-rtl.css\";i:529;s:23:\"video/style-rtl.min.css\";i:530;s:15:\"video/style.css\";i:531;s:19:\"video/style.min.css\";i:532;s:19:\"video/theme-rtl.css\";i:533;s:23:\"video/theme-rtl.min.css\";i:534;s:15:\"video/theme.css\";i:535;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `cupoptions` VALUES("126", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1753189548;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `cupoptions` VALUES("127", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"04bc21473354e6654273c9319dc29fde\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `cupoptions` VALUES("128", "recovery_keys", "a:0:{}", "off");
INSERT INTO `cupoptions` VALUES("155", "db_upgraded", "", "on");
INSERT INTO `cupoptions` VALUES("163", "can_compress_scripts", "0", "on");
INSERT INTO `cupoptions` VALUES("166", "finished_updating_comment_type", "1", "auto");
INSERT INTO `cupoptions` VALUES("167", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `cupoptions` VALUES("168", "recently_activated", "a:2:{s:35:\"litespeed-cache/litespeed-cache.php\";i:1757423307;s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";i:1757423132;}", "off");
INSERT INTO `cupoptions` VALUES("172", "theme_mods_checkup", "a:2:{s:18:\"custom_css_post_id\";i:16;s:18:\"nav_menu_locations\";a:0:{}}", "on");
INSERT INTO `cupoptions` VALUES("173", "current_theme", "", "auto");
INSERT INTO `cupoptions` VALUES("174", "theme_switched", "", "auto");
INSERT INTO `cupoptions` VALUES("298", "_transient_health-check-site-status-result", "{\"good\":19,\"recommended\":3,\"critical\":0}", "on");
INSERT INTO `cupoptions` VALUES("300", "new_admin_email", "webmaster@ekno.fr", "auto");
INSERT INTO `cupoptions` VALUES("301", "whl_page", "up-connect", "auto");
INSERT INTO `cupoptions` VALUES("302", "whl_redirect_admin", "404", "auto");
INSERT INTO `cupoptions` VALUES("373", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:44:\"stackable-ultimate-gutenberg-blocks/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:6:\"2.12.1\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1753351028;s:11:\"plugin_path\";s:46:\"stackable-ultimate-gutenberg-blocks/plugin.php\";}}s:7:\"abspath\";s:20:\"/home/xvgnwgb/check/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:46:\"stackable-ultimate-gutenberg-blocks/plugin.php\";s:8:\"sdk_path\";s:44:\"stackable-ultimate-gutenberg-blocks/freemius\";s:7:\"version\";s:6:\"2.12.1\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1753351028;}}", "auto");
INSERT INTO `cupoptions` VALUES("374", "fs_debug_mode", "", "auto");
INSERT INTO `cupoptions` VALUES("375", "fs_accounts", "a:9:{s:21:\"id_slug_type_path_map\";a:2:{i:1748;a:3:{s:4:\"slug\";s:35:\"stackable-ultimate-gutenberg-blocks\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:46:\"stackable-ultimate-gutenberg-blocks/plugin.php\";}i:17342;a:3:{s:4:\"slug\";s:20:\"timeline-block-block\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:31:\"timeline-block-block/plugin.php\";}}s:11:\"plugin_data\";a:2:{s:35:\"stackable-ultimate-gutenberg-blocks\";a:17:{s:19:\"last_load_timestamp\";i:1754379218;s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:46:\"stackable-ultimate-gutenberg-blocks/plugin.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1753351028;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:1;s:16:\"sdk_last_version\";N;s:11:\"sdk_version\";s:6:\"2.12.1\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";N;s:14:\"plugin_version\";s:6:\"3.17.1\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";N;s:4:\"host\";s:11:\"up.thera.fr\";s:9:\"server_ip\";s:11:\"10.100.20.5\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1753351028;s:7:\"version\";s:6:\"3.17.1\";}s:15:\"prev_is_premium\";b:0;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1753351036;s:7:\"version\";s:6:\"3.17.1\";}}s:20:\"timeline-block-block\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:31:\"timeline-block-block/plugin.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1754483773;s:16:\"sdk_last_version\";s:6:\"2.5.12\";s:11:\"sdk_version\";s:6:\"2.5.12\";s:16:\"sdk_upgrade_mode\";s:1:\"1\";s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";s:5:\"1.2.2\";s:14:\"plugin_version\";s:5:\"1.2.2\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:0;s:4:\"host\";s:11:\"up.thera.fr\";s:9:\"server_ip\";s:0:\"\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1754483773;s:7:\"version\";s:5:\"1.2.2\";}s:15:\"prev_is_premium\";b:0;s:18:\"sticky_optin_added\";b:1;}}s:13:\"file_slug_map\";a:2:{s:46:\"stackable-ultimate-gutenberg-blocks/plugin.php\";s:35:\"stackable-ultimate-gutenberg-blocks\";s:31:\"timeline-block-block/plugin.php\";s:20:\"timeline-block-block\";}s:7:\"plugins\";a:1:{s:35:\"stackable-ultimate-gutenberg-blocks\";O:9:\"FS_Plugin\":24:{s:2:\"id\";s:4:\"1748\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;s:10:\"public_key\";s:32:\"pk_771ae29c5255d20a4880980729a17\";s:10:\"secret_key\";N;s:16:\"parent_plugin_id\";N;s:5:\"title\";s:28:\"Stackable - Gutenberg Blocks\";s:4:\"slug\";s:35:\"stackable-ultimate-gutenberg-blocks\";s:12:\"premium_slug\";s:43:\"stackable-ultimate-gutenberg-blocks-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:46:\"stackable-ultimate-gutenberg-blocks/plugin.php\";s:7:\"version\";s:6:\"3.17.1\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;}}s:12:\"gc_timestamp\";a:0:{}s:10:\"theme_data\";a:0:{}s:9:\"unique_id\";s:32:\"7f64e29a639a1c6e7fac96962e4e8d52\";s:5:\"users\";a:0:{}s:5:\"sites\";a:0:{}}", "auto");
INSERT INTO `cupoptions` VALUES("376", "fs_api_cache", "a:0:{}", "off");
INSERT INTO `cupoptions` VALUES("384", "stackable_current_version_installed", "3.18.1", "off");
INSERT INTO `cupoptions` VALUES("385", "stackable_pro_notice_start_date", "1753351028", "off");
INSERT INTO `cupoptions` VALUES("386", "stackable_activation_date", "1753351028", "off");
INSERT INTO `cupoptions` VALUES("398", "bodhi_svgs_settings", "a:3:{s:22:\"sanitize_svg_front_end\";s:2:\"on\";s:8:\"restrict\";a:1:{i:0;s:13:\"administrator\";}s:24:\"sanitize_on_upload_roles\";a:0:{}}", "auto");
INSERT INTO `cupoptions` VALUES("399", "bodhi_svgs_plugin_version", "2.5.14", "auto");
INSERT INTO `cupoptions` VALUES("604", "nav_menu_options", "a:1:{s:8:\"auto_add\";a:0:{}}", "auto");
INSERT INTO `cupoptions` VALUES("642", "wfls_last_role_change", "1753718526", "off");
INSERT INTO `cupoptions` VALUES("645", "wordfence_installed", "", "auto");
INSERT INTO `cupoptions` VALUES("647", "wf_plugin_act_error", "", "auto");
INSERT INTO `cupoptions` VALUES("658", "aio_wp_security_configs", "a:115:{s:19:\"aiowps_enable_debug\";s:0:\"\";s:36:\"aiowps_enable_php_backtrace_in_email\";s:0:\"\";s:36:\"aiowps_remove_wp_generator_meta_info\";s:0:\"\";s:25:\"aiowps_prevent_hotlinking\";s:0:\"\";s:28:\"aiowps_enable_login_lockdown\";s:0:\"\";s:28:\"aiowps_allow_unlock_requests\";s:1:\"1\";s:25:\"aiowps_max_login_attempts\";s:1:\"3\";s:24:\"aiowps_retry_time_period\";s:1:\"5\";s:26:\"aiowps_lockout_time_length\";s:1:\"5\";s:30:\"aiowps_max_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_set_generic_login_msg\";s:0:\"\";s:26:\"aiowps_enable_email_notify\";s:0:\"\";s:20:\"aiowps_email_address\";s:17:\"webmaster@ekno.fr\";s:27:\"aiowps_enable_forced_logout\";s:0:\"\";s:25:\"aiowps_logout_time_period\";s:2:\"60\";s:39:\"aiowps_enable_invalid_username_lockdown\";s:0:\"\";s:43:\"aiowps_instantly_lockout_specific_usernames\";a:0:{}s:32:\"aiowps_unlock_request_secret_key\";s:20:\"c45frhaqzrfme7x8x2ss\";s:35:\"aiowps_lockdown_enable_whitelisting\";s:0:\"\";s:36:\"aiowps_lockdown_allowed_ip_addresses\";s:0:\"\";s:32:\"aiowps_http_authentication_admin\";s:0:\"\";s:35:\"aiowps_http_authentication_frontend\";s:0:\"\";s:35:\"aiowps_http_authentication_username\";s:4:\"root\";s:35:\"aiowps_http_authentication_password\";s:8:\"password\";s:42:\"aiowps_http_authentication_failure_message\";s:21:\"<h1>Unauthorized</h1>\";s:26:\"aiowps_enable_whitelisting\";s:0:\"\";s:27:\"aiowps_allowed_ip_addresses\";s:0:\"\";s:22:\"aiowps_default_captcha\";s:4:\"none\";s:27:\"aiowps_enable_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_custom_login_captcha\";s:0:\"\";s:40:\"aiowps_enable_password_protected_captcha\";s:0:\"\";s:31:\"aiowps_enable_woo_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_register_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_checkout_captcha\";s:0:\"\";s:38:\"aiowps_enable_woo_lostpassword_captcha\";s:0:\"\";s:36:\"aiowps_enable_contact_form_7_captcha\";s:0:\"\";s:25:\"aiowps_captcha_secret_key\";s:20:\"i99lzkdyu49tcndzmw0g\";s:42:\"aiowps_enable_manual_registration_approval\";s:0:\"\";s:39:\"aiowps_enable_registration_page_captcha\";s:0:\"\";s:35:\"aiowps_enable_registration_honeypot\";s:0:\"\";s:27:\"aiowps_enable_random_prefix\";s:0:\"\";s:27:\"aiowps_disable_file_editing\";s:0:\"\";s:37:\"aiowps_prevent_default_wp_file_access\";s:0:\"\";s:35:\"aiowps_auto_delete_default_wp_files\";s:0:\"\";s:22:\"aiowps_system_log_file\";s:9:\"error_log\";s:26:\"aiowps_enable_blacklisting\";s:0:\"\";s:26:\"aiowps_banned_ip_addresses\";s:0:\"\";s:28:\"aiowps_enable_basic_firewall\";s:0:\"\";s:27:\"aiowps_max_file_upload_size\";i:100;s:38:\"aiowps_disable_xmlrpc_pingback_methods\";s:1:\"1\";s:33:\"aiowps_disable_rss_and_atom_feeds\";s:1:\"1\";s:34:\"aiowps_block_debug_log_file_access\";s:0:\"\";s:26:\"aiowps_disable_index_views\";s:0:\"\";s:30:\"aiowps_disable_trace_and_track\";s:0:\"\";s:25:\"aiowps_enable_5g_firewall\";s:0:\"\";s:25:\"aiowps_enable_6g_firewall\";s:0:\"\";s:26:\"aiowps_enable_custom_rules\";s:0:\"\";s:32:\"aiowps_place_custom_rules_at_top\";s:0:\"\";s:19:\"aiowps_custom_rules\";s:0:\"\";s:32:\"aiowps_upgrade_unsafe_http_calls\";s:0:\"\";s:47:\"aiowps_upgrade_unsafe_http_calls_url_exceptions\";s:0:\"\";s:25:\"aiowps_enable_404_logging\";s:0:\"\";s:28:\"aiowps_enable_404_IP_lockout\";s:0:\"\";s:30:\"aiowps_404_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_404_lock_redirect_url\";s:16:\"http://127.0.0.1\";s:31:\"aiowps_enable_rename_login_page\";s:0:\"\";s:28:\"aiowps_enable_login_honeypot\";s:0:\"\";s:35:\"aiowps_disable_application_password\";s:0:\"\";s:43:\"aiowps_enable_brute_force_attack_prevention\";s:0:\"\";s:30:\"aiowps_brute_force_secret_word\";s:0:\"\";s:24:\"aiowps_cookie_brute_test\";s:0:\"\";s:44:\"aiowps_cookie_based_brute_force_redirect_url\";s:16:\"http://127.0.0.1\";s:59:\"aiowps_brute_force_attack_prevention_pw_protected_exception\";s:0:\"\";s:51:\"aiowps_brute_force_attack_prevention_ajax_exception\";s:0:\"\";s:19:\"aiowps_site_lockout\";s:0:\"\";s:23:\"aiowps_site_lockout_msg\";s:0:\"\";s:30:\"aiowps_enable_spambot_blocking\";s:0:\"\";s:29:\"aiowps_enable_comment_captcha\";s:0:\"\";s:33:\"aiowps_spam_ip_min_comments_block\";s:0:\"\";s:33:\"aiowps_enable_bp_register_captcha\";s:0:\"\";s:35:\"aiowps_enable_bbp_new_topic_captcha\";s:0:\"\";s:31:\"aiowps_enable_spambot_detecting\";s:0:\"\";s:32:\"aiowps_spambot_detect_usecookies\";s:0:\"\";s:27:\"aiowps_spam_comments_should\";s:0:\"\";s:33:\"aiowps_enable_trash_spam_comments\";s:0:\"\";s:37:\"aiowps_trash_spam_comments_after_days\";s:2:\"14\";s:32:\"aiowps_enable_automated_fcd_scan\";s:0:\"\";s:25:\"aiowps_fcd_scan_frequency\";s:1:\"4\";s:24:\"aiowps_fcd_scan_interval\";s:1:\"2\";s:28:\"aiowps_fcd_exclude_filetypes\";s:0:\"\";s:24:\"aiowps_fcd_exclude_files\";s:0:\"\";s:26:\"aiowps_send_fcd_scan_email\";s:0:\"\";s:29:\"aiowps_fcd_scan_email_address\";s:17:\"webmaster@ekno.fr\";s:27:\"aiowps_fcds_change_detected\";b:0;s:22:\"aiowps_copy_protection\";s:0:\"\";s:40:\"aiowps_prevent_site_display_inside_frame\";s:0:\"\";s:32:\"aiowps_prevent_users_enumeration\";s:0:\"\";s:42:\"aiowps_disallow_unauthorized_rest_requests\";s:0:\"\";s:35:\"aios_roles_disallowed_rest_requests\";a:0:{}s:28:\"aios_whitelisted_rest_routes\";a:0:{}s:25:\"aiowps_turnstile_site_key\";s:0:\"\";s:27:\"aiowps_turnstile_secret_key\";s:0:\"\";s:25:\"aiowps_recaptcha_site_key\";s:0:\"\";s:27:\"aiowps_recaptcha_secret_key\";s:0:\"\";s:24:\"aiowps_default_recaptcha\";s:0:\"\";s:36:\"aiowps_on_uninstall_delete_db_tables\";s:1:\"1\";s:34:\"aiowps_on_uninstall_delete_configs\";s:1:\"1\";s:12:\"installed-at\";i:1753718687;s:31:\"aiowps_enable_pingback_firewall\";s:1:\"0\";s:28:\"aiowps_forbid_proxy_comments\";s:1:\"0\";s:29:\"aiowps_deny_bad_query_strings\";s:1:\"0\";s:34:\"aiowps_advanced_char_string_filter\";s:1:\"0\";s:21:\"aios_firewall_dismiss\";b:1;s:17:\"dismissdashnotice\";i:1787905759;s:21:\"dismiss_review_notice\";d:4912044108;}", "auto");
INSERT INTO `cupoptions` VALUES("659", "aios_antibot_key_map_info", "a:3:{i:0;a:2:{i:0;a:2:{i:0;s:8:\"p2b170kt\";i:1;s:12:\"awxotpftu4ks\";}i:1;a:2:{i:0;s:8:\"4wqmv5ox\";i:1;s:12:\"gqvq07968510\";}}i:1;a:3:{i:0;a:2:{i:0;s:8:\"3fzquyu5\";i:1;s:12:\"qruhxdwt5byb\";}i:1;a:2:{i:0;s:8:\"gfagm76q\";i:1;s:12:\"lr3lirv8engf\";}i:2;a:2:{i:0;s:8:\"s4fveygi\";i:1;s:12:\"pd0e3jax480w\";}}i:2;i:1757721600;}", "off");
INSERT INTO `cupoptions` VALUES("660", "aiowpsec_db_version", "2.1.4", "auto");
INSERT INTO `cupoptions` VALUES("661", "aiowpsec_firewall_version", "1.0.8", "auto");
INSERT INTO `cupoptions` VALUES("663", "simba_tfa_priv_key_format", "1", "off");
INSERT INTO `cupoptions` VALUES("664", "updraft_lock_aios_15_minutes_cron_event", "0", "no");
INSERT INTO `cupoptions` VALUES("754", "stackable_notifications_dismissed", "a:1:{i:0;s:4:\"rate\";}", "off");
INSERT INTO `cupoptions` VALUES("1151", "cool-free-timeline-v", "3.0.5", "auto");
INSERT INTO `cupoptions` VALUES("1152", "cool-timelne-plugin-type", "FREE", "auto");
INSERT INTO `cupoptions` VALUES("1153", "cool-timelne-installDate", "2025-08-06 12:53:04", "auto");
INSERT INTO `cupoptions` VALUES("1154", "cool-timeline-already-rated", "no", "auto");
INSERT INTO `cupoptions` VALUES("1156", "ctl_initial_save_version", "3.0.5", "auto");
INSERT INTO `cupoptions` VALUES("1157", "ctl-install-date", "2025-08-06 08:23:21", "auto");
INSERT INTO `cupoptions` VALUES("1158", "ctl-upgraded", "yes", "auto");
INSERT INTO `cupoptions` VALUES("1159", "cool_timeline_settings", "a:15:{s:15:\"timeline_header\";s:0:\"\";s:22:\"story_content_settings\";s:0:\"\";s:19:\"story_date_settings\";s:0:\"\";s:20:\"first_story_position\";s:5:\"right\";s:16:\"content_bg_color\";s:7:\"#ffffff\";s:19:\"circle_border_color\";s:7:\"#38aab7\";s:10:\"line_color\";s:7:\"#025149\";s:10:\"first_post\";s:7:\"#29b246\";s:11:\"second_post\";s:7:\"#ce792f\";s:13:\"custom_styles\";s:0:\"\";s:13:\"ctl_date_typo\";a:6:{s:11:\"font-family\";s:9:\"Maven Pro\";s:9:\"font-size\";s:2:\"21\";s:11:\"line-height\";s:0:\"\";s:4:\"unit\";s:2:\"px\";s:4:\"type\";s:6:\"google\";s:11:\"font-weight\";s:3:\"700\";}s:15:\"post_title_typo\";a:6:{s:11:\"font-family\";s:9:\"Maven Pro\";s:9:\"font-size\";s:2:\"20\";s:11:\"line-height\";s:0:\"\";s:4:\"unit\";s:2:\"px\";s:4:\"type\";s:6:\"google\";s:11:\"font-weight\";s:3:\"700\";}s:17:\"post_content_typo\";a:5:{s:11:\"font-family\";s:9:\"Maven Pro\";s:9:\"font-size\";s:2:\"16\";s:11:\"line-height\";s:0:\"\";s:4:\"unit\";s:2:\"px\";s:4:\"type\";s:6:\"google\";}s:17:\"advanced-features\";s:0:\"\";s:16:\"timeline_display\";s:0:\"\";}", "auto");
INSERT INTO `cupoptions` VALUES("1214", "ach-redirect", "1", "auto");
INSERT INTO `cupoptions` VALUES("1215", "unique_id", "7f64e29a639a1c6e7fac96962e4e8d52", "auto");
INSERT INTO `cupoptions` VALUES("1671", "_site_transient_timeout_g_url_details_response_e4e7d10a2556b8490a05edc6881e49e6", "1756285071", "off");
INSERT INTO `cupoptions` VALUES("1680", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `cupoptions` VALUES("1694", "acf_first_activated_version", "6.5.0", "on");
INSERT INTO `cupoptions` VALUES("1695", "acf_site_health", "{\"version\":\"6.5.0\",\"plugin_type\":\"Free\",\"update_source\":\"wordpress.org\",\"wp_version\":\"6.8.2\",\"mysql_version\":\"8.0.42-33\",\"is_multisite\":false,\"active_theme\":{\"name\":\"\",\"version\":\"\",\"theme_uri\":\"\",\"stylesheet\":false},\"active_plugins\":{\"advanced-custom-fields\\/acf.php\":{\"name\":\"Advanced Custom Fields\",\"version\":\"6.5.0\",\"plugin_uri\":\"https:\\/\\/www.advancedcustomfields.com\"},\"akismet\\/akismet.php\":{\"name\":\"Akismet Anti-spam: Spam Protection\",\"version\":\"5.5\",\"plugin_uri\":\"https:\\/\\/akismet.com\\/\"},\"all-in-one-wp-security-and-firewall\\/wp-security.php\":{\"name\":\"All-In-One Security (AIOS)\",\"version\":\"5.4.2\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/all-in-one-wp-security-and-firewall\\/\"},\"complianz-gdpr\\/complianz-gpdr.php\":{\"name\":\"Complianz | GDPR\\/CCPA Cookie Consent\",\"version\":\"7.4.2\",\"plugin_uri\":\"https:\\/\\/www.wordpress.org\\/plugins\\/complianz-gdpr\"},\"contact-form-7\\/wp-contact-form-7.php\":{\"name\":\"Contact Form 7\",\"version\":\"6.1.1\",\"plugin_uri\":\"https:\\/\\/contactform7.com\\/\"},\"daisy-titles\\/daisy-titles.php\":{\"name\":\"Daisy Titles\",\"version\":\"1.0.8\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/daisy-titles\"},\"duplicate-page\\/duplicatepage.php\":{\"name\":\"Duplicate Page\",\"version\":\"4.5.5\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/duplicate-page\\/\"},\"stackable-ultimate-gutenberg-blocks\\/plugin.php\":{\"name\":\"Stackable - Gutenberg Blocks\",\"version\":\"3.18.1\",\"plugin_uri\":\"https:\\/\\/wpstackable.com\"},\"svg-support\\/svg-support.php\":{\"name\":\"SVG Support\",\"version\":\"2.5.14\",\"plugin_uri\":\"http:\\/\\/wordpress.org\\/plugins\\/svg-support\\/\"},\"timeline-block\\/timeline-block.php\":{\"name\":\"Timeline Block\",\"version\":\"1.7.3\",\"plugin_uri\":\"https:\\/\\/cooltimeline.com\"},\"timeline-block-block\\/plugin.php\":{\"name\":\"Timeline Block\",\"version\":\"1.2.2\",\"plugin_uri\":\"\"},\"wps-hide-login\\/wps-hide-login.php\":{\"name\":\"WPS Hide Login\",\"version\":\"1.9.17.2\",\"plugin_uri\":\"\"},\"wordpress-seo\\/wp-seo.php\":{\"name\":\"Yoast SEO\",\"version\":\"25.8\",\"plugin_uri\":\"https:\\/\\/yoa.st\\/1uj\"}},\"ui_field_groups\":\"1\",\"php_field_groups\":\"0\",\"json_field_groups\":\"0\",\"rest_field_groups\":\"0\",\"all_location_rules\":[\"post_type==start-up\"],\"number_of_fields_by_type\":{\"image\":1,\"wysiwyg\":1,\"link\":1},\"number_of_third_party_fields_by_type\":[],\"post_types_enabled\":true,\"ui_post_types\":\"4\",\"json_post_types\":\"0\",\"ui_taxonomies\":\"3\",\"json_taxonomies\":\"0\",\"rest_api_format\":\"light\",\"admin_ui_enabled\":true,\"field_type-modal_enabled\":true,\"field_settings_tabs_enabled\":false,\"shortcode_enabled\":false,\"registered_acf_forms\":\"0\",\"json_save_paths\":1,\"json_load_paths\":1,\"event_first_activated\":1756284514,\"event_first_created_post_type\":1756284640,\"event_first_created_field_group\":1756285152,\"last_updated\":1756889351}", "off");
INSERT INTO `cupoptions` VALUES("1697", "acf_version", "6.5.0", "auto");
INSERT INTO `cupoptions` VALUES("1921", "duplicate_page_options", "a:4:{s:21:\"duplicate_post_status\";s:5:\"draft\";s:23:\"duplicate_post_redirect\";s:7:\"to_list\";s:21:\"duplicate_post_suffix\";s:0:\"\";s:21:\"duplicate_post_editor\";s:7:\"classic\";}", "auto");
INSERT INTO `cupoptions` VALUES("1992", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.1.1\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1756455984;s:7:\"version\";s:5:\"6.1.1\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "auto");
INSERT INTO `cupoptions` VALUES("2067", "secret_key", "@.}J08k:sQ|B[T$oa<s4C{#F{F1^B_Kk5)jvC<F[-B>3GN|Q,rRPXvorZA`anoex", "off");
INSERT INTO `cupoptions` VALUES("2168", "_transient_timeout_dirsize_cache", "2072070169", "off");
INSERT INTO `cupoptions` VALUES("2169", "_transient_dirsize_cache", "a:770:{s:45:\"/home/xvgnwgb/check/wp-content/aiowps_backups\";i:5014;s:38:\"/home/xvgnwgb/check/wp-content/upgrade\";i:0;s:48:\"/home/xvgnwgb/check/wp-content/languages/plugins\";i:1673907;s:47:\"/home/xvgnwgb/check/wp-content/languages/themes\";i:372091;s:40:\"/home/xvgnwgb/check/wp-content/languages\";i:6245304;s:58:\"/home/xvgnwgb/check/wp-content/upgrade-temp-backup/plugins\";i:0;s:50:\"/home/xvgnwgb/check/wp-content/upgrade-temp-backup\";i:0;s:30:\"/home/xvgnwgb/check/wp-content\";i:6250346;s:36:\"/home/xvgnwgb/check/wp-admin/network\";i:126233;s:35:\"/home/xvgnwgb/check/wp-admin/images\";i:427294;s:34:\"/home/xvgnwgb/check/wp-admin/maint\";i:7611;s:39:\"/home/xvgnwgb/check/wp-admin/js/widgets\";i:139432;s:31:\"/home/xvgnwgb/check/wp-admin/js\";i:1996678;s:45:\"/home/xvgnwgb/check/wp-admin/css/colors/ocean\";i:79467;s:49:\"/home/xvgnwgb/check/wp-admin/css/colors/ectoplasm\";i:83892;s:47:\"/home/xvgnwgb/check/wp-admin/css/colors/sunrise\";i:86121;s:46:\"/home/xvgnwgb/check/wp-admin/css/colors/modern\";i:83520;s:45:\"/home/xvgnwgb/check/wp-admin/css/colors/light\";i:83275;s:46:\"/home/xvgnwgb/check/wp-admin/css/colors/coffee\";i:80361;s:48:\"/home/xvgnwgb/check/wp-admin/css/colors/midnight\";i:84671;s:44:\"/home/xvgnwgb/check/wp-admin/css/colors/blue\";i:82449;s:39:\"/home/xvgnwgb/check/wp-admin/css/colors\";i:689979;s:32:\"/home/xvgnwgb/check/wp-admin/css\";i:2623520;s:37:\"/home/xvgnwgb/check/wp-admin/includes\";i:3089012;s:33:\"/home/xvgnwgb/check/wp-admin/user\";i:3758;s:28:\"/home/xvgnwgb/check/wp-admin\";i:9217669;s:48:\"/home/xvgnwgb/check/wp-includes/Requests/library\";i:261;s:53:\"/home/xvgnwgb/check/wp-includes/Requests/src/Response\";i:3101;s:49:\"/home/xvgnwgb/check/wp-includes/Requests/src/Auth\";i:2541;s:64:\"/home/xvgnwgb/check/wp-includes/Requests/src/Exception/Transport\";i:1397;s:59:\"/home/xvgnwgb/check/wp-includes/Requests/src/Exception/Http\";i:16715;s:54:\"/home/xvgnwgb/check/wp-includes/Requests/src/Exception\";i:22464;s:52:\"/home/xvgnwgb/check/wp-includes/Requests/src/Utility\";i:7176;s:50:\"/home/xvgnwgb/check/wp-includes/Requests/src/Proxy\";i:4217;s:51:\"/home/xvgnwgb/check/wp-includes/Requests/src/Cookie\";i:4363;s:54:\"/home/xvgnwgb/check/wp-includes/Requests/src/Transport\";i:35470;s:44:\"/home/xvgnwgb/check/wp-includes/Requests/src\";i:214849;s:40:\"/home/xvgnwgb/check/wp-includes/Requests\";i:215110;s:47:\"/home/xvgnwgb/check/wp-includes/rest-api/search\";i:16916;s:47:\"/home/xvgnwgb/check/wp-includes/rest-api/fields\";i:22750;s:50:\"/home/xvgnwgb/check/wp-includes/rest-api/endpoints\";i:870211;s:40:\"/home/xvgnwgb/check/wp-includes/rest-api\";i:1001440;s:41:\"/home/xvgnwgb/check/wp-includes/customize\";i:178173;s:75:\"/home/xvgnwgb/check/wp-includes/sodium_compat/namespaced/Core/Curve25519/Ge\";i:602;s:72:\"/home/xvgnwgb/check/wp-includes/sodium_compat/namespaced/Core/Curve25519\";i:820;s:70:\"/home/xvgnwgb/check/wp-includes/sodium_compat/namespaced/Core/Poly1305\";i:112;s:70:\"/home/xvgnwgb/check/wp-includes/sodium_compat/namespaced/Core/ChaCha20\";i:224;s:61:\"/home/xvgnwgb/check/wp-includes/sodium_compat/namespaced/Core\";i:2444;s:56:\"/home/xvgnwgb/check/wp-includes/sodium_compat/namespaced\";i:2698;s:69:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core32/SecretStream\";i:3656;s:65:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core32/Poly1305\";i:15965;s:70:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core32/Curve25519/Ge\";i:8177;s:67:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core32/Curve25519\";i:122690;s:65:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core32/ChaCha20\";i:6407;s:56:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core32\";i:437041;s:55:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/PHP52\";i:4116;s:60:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core/AEGIS\";i:14759;s:63:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core/ChaCha20\";i:5264;s:61:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core/Base64\";i:15456;s:63:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core/Poly1305\";i:12912;s:67:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core/SecretStream\";i:3624;s:68:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core/Curve25519/Ge\";i:10572;s:65:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core/Curve25519\";i:124336;s:58:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core/AES\";i:12651;s:54:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src/Core\";i:499975;s:49:\"/home/xvgnwgb/check/wp-includes/sodium_compat/src\";i:1268866;s:49:\"/home/xvgnwgb/check/wp-includes/sodium_compat/lib\";i:99005;s:45:\"/home/xvgnwgb/check/wp-includes/sodium_compat\";i:1377044;s:46:\"/home/xvgnwgb/check/wp-includes/block-bindings\";i:3610;s:44:\"/home/xvgnwgb/check/wp-includes/images/media\";i:5263;s:46:\"/home/xvgnwgb/check/wp-includes/images/crystal\";i:15541;s:46:\"/home/xvgnwgb/check/wp-includes/images/smilies\";i:10082;s:38:\"/home/xvgnwgb/check/wp-includes/images\";i:102178;s:50:\"/home/xvgnwgb/check/wp-includes/sitemaps/providers\";i:17599;s:40:\"/home/xvgnwgb/check/wp-includes/sitemaps\";i:47547;s:41:\"/home/xvgnwgb/check/wp-includes/PHPMailer\";i:233633;s:35:\"/home/xvgnwgb/check/wp-includes/IXR\";i:33910;s:49:\"/home/xvgnwgb/check/wp-includes/interactivity-api\";i:57534;s:39:\"/home/xvgnwgb/check/wp-includes/widgets\";i:158198;s:50:\"/home/xvgnwgb/check/wp-includes/Text/Diff/Renderer\";i:5528;s:48:\"/home/xvgnwgb/check/wp-includes/Text/Diff/Engine\";i:31802;s:41:\"/home/xvgnwgb/check/wp-includes/Text/Diff\";i:44136;s:36:\"/home/xvgnwgb/check/wp-includes/Text\";i:57248;s:42:\"/home/xvgnwgb/check/wp-includes/php-compat\";i:1253;s:44:\"/home/xvgnwgb/check/wp-includes/certificates\";i:226307;s:52:\"/home/xvgnwgb/check/wp-includes/css/dist/preferences\";i:6314;s:55:\"/home/xvgnwgb/check/wp-includes/css/dist/format-library\";i:5024;s:49:\"/home/xvgnwgb/check/wp-includes/css/dist/patterns\";i:7442;s:51:\"/home/xvgnwgb/check/wp-includes/css/dist/components\";i:366079;s:53:\"/home/xvgnwgb/check/wp-includes/css/dist/edit-widgets\";i:90952;s:50:\"/home/xvgnwgb/check/wp-includes/css/dist/edit-site\";i:590018;s:49:\"/home/xvgnwgb/check/wp-includes/css/dist/commands\";i:13442;s:50:\"/home/xvgnwgb/check/wp-includes/css/dist/edit-post\";i:61540;s:53:\"/home/xvgnwgb/check/wp-includes/css/dist/block-editor\";i:620037;s:56:\"/home/xvgnwgb/check/wp-includes/css/dist/reusable-blocks\";i:2290;s:61:\"/home/xvgnwgb/check/wp-includes/css/dist/list-reusable-blocks\";i:17852;s:54:\"/home/xvgnwgb/check/wp-includes/css/dist/block-library\";i:804012;s:56:\"/home/xvgnwgb/check/wp-includes/css/dist/block-directory\";i:15464;s:47:\"/home/xvgnwgb/check/wp-includes/css/dist/editor\";i:243084;s:44:\"/home/xvgnwgb/check/wp-includes/css/dist/nux\";i:11874;s:58:\"/home/xvgnwgb/check/wp-includes/css/dist/customize-widgets\";i:25296;s:48:\"/home/xvgnwgb/check/wp-includes/css/dist/widgets\";i:23740;s:40:\"/home/xvgnwgb/check/wp-includes/css/dist\";i:2904460;s:35:\"/home/xvgnwgb/check/wp-includes/css\";i:3551277;s:35:\"/home/xvgnwgb/check/wp-includes/ID3\";i:1160011;s:66:\"/home/xvgnwgb/check/wp-includes/blocks/comments-pagination-numbers\";i:1833;s:48:\"/home/xvgnwgb/check/wp-includes/blocks/shortcode\";i:2918;s:43:\"/home/xvgnwgb/check/wp-includes/blocks/file\";i:11820;s:46:\"/home/xvgnwgb/check/wp-includes/blocks/gallery\";i:78452;s:53:\"/home/xvgnwgb/check/wp-includes/blocks/comments-title\";i:1745;s:54:\"/home/xvgnwgb/check/wp-includes/blocks/comment-content\";i:1838;s:44:\"/home/xvgnwgb/check/wp-includes/blocks/block\";i:587;s:44:\"/home/xvgnwgb/check/wp-includes/blocks/query\";i:12952;s:44:\"/home/xvgnwgb/check/wp-includes/blocks/video\";i:8844;s:43:\"/home/xvgnwgb/check/wp-includes/blocks/more\";i:3770;s:55:\"/home/xvgnwgb/check/wp-includes/blocks/query-no-results\";i:901;s:48:\"/home/xvgnwgb/check/wp-includes/blocks/list-item\";i:1471;s:43:\"/home/xvgnwgb/check/wp-includes/blocks/list\";i:2338;s:46:\"/home/xvgnwgb/check/wp-includes/blocks/heading\";i:5866;s:52:\"/home/xvgnwgb/check/wp-includes/blocks/post-template\";i:7967;s:50:\"/home/xvgnwgb/check/wp-includes/blocks/query-total\";i:1520;s:44:\"/home/xvgnwgb/check/wp-includes/blocks/embed\";i:11420;s:51:\"/home/xvgnwgb/check/wp-includes/blocks/post-excerpt\";i:3285;s:55:\"/home/xvgnwgb/check/wp-includes/blocks/term-description\";i:2070;s:51:\"/home/xvgnwgb/check/wp-includes/blocks/site-tagline\";i:2149;s:48:\"/home/xvgnwgb/check/wp-includes/blocks/separator\";i:5126;s:49:\"/home/xvgnwgb/check/wp-includes/blocks/post-terms\";i:1981;s:45:\"/home/xvgnwgb/check/wp-includes/blocks/search\";i:19632;s:58:\"/home/xvgnwgb/check/wp-includes/blocks/comment-author-name\";i:1677;s:54:\"/home/xvgnwgb/check/wp-includes/blocks/navigation-link\";i:10406;s:51:\"/home/xvgnwgb/check/wp-includes/blocks/social-links\";i:60255;s:51:\"/home/xvgnwgb/check/wp-includes/blocks/widget-group\";i:400;s:64:\"/home/xvgnwgb/check/wp-includes/blocks/query-pagination-previous\";i:1051;s:52:\"/home/xvgnwgb/check/wp-includes/blocks/template-part\";i:6686;s:45:\"/home/xvgnwgb/check/wp-includes/blocks/column\";i:1636;s:54:\"/home/xvgnwgb/check/wp-includes/blocks/latest-comments\";i:6816;s:46:\"/home/xvgnwgb/check/wp-includes/blocks/columns\";i:9193;s:46:\"/home/xvgnwgb/check/wp-includes/blocks/buttons\";i:11544;s:60:\"/home/xvgnwgb/check/wp-includes/blocks/post-author-biography\";i:1507;s:47:\"/home/xvgnwgb/check/wp-includes/blocks/comments\";i:29695;s:49:\"/home/xvgnwgb/check/wp-includes/blocks/media-text\";i:16904;s:45:\"/home/xvgnwgb/check/wp-includes/blocks/button\";i:14327;s:48:\"/home/xvgnwgb/check/wp-includes/blocks/pullquote\";i:8859;s:59:\"/home/xvgnwgb/check/wp-includes/blocks/post-navigation-link\";i:4010;s:51:\"/home/xvgnwgb/check/wp-includes/blocks/text-columns\";i:3054;s:48:\"/home/xvgnwgb/check/wp-includes/blocks/post-date\";i:1665;s:46:\"/home/xvgnwgb/check/wp-includes/blocks/pattern\";i:411;s:47:\"/home/xvgnwgb/check/wp-includes/blocks/freeform\";i:41624;s:55:\"/home/xvgnwgb/check/wp-includes/blocks/post-author-name\";i:1673;s:51:\"/home/xvgnwgb/check/wp-includes/blocks/post-content\";i:1778;s:44:\"/home/xvgnwgb/check/wp-includes/blocks/table\";i:27384;s:49:\"/home/xvgnwgb/check/wp-includes/blocks/categories\";i:4020;s:48:\"/home/xvgnwgb/check/wp-includes/blocks/paragraph\";i:7421;s:49:\"/home/xvgnwgb/check/wp-includes/blocks/post-title\";i:2849;s:46:\"/home/xvgnwgb/check/wp-includes/blocks/missing\";i:617;s:67:\"/home/xvgnwgb/check/wp-includes/blocks/comments-pagination-previous\";i:1023;s:48:\"/home/xvgnwgb/check/wp-includes/blocks/footnotes\";i:2642;s:50:\"/home/xvgnwgb/check/wp-includes/blocks/query-title\";i:1721;s:44:\"/home/xvgnwgb/check/wp-includes/blocks/verse\";i:2144;s:63:\"/home/xvgnwgb/check/wp-includes/blocks/query-pagination-numbers\";i:1942;s:51:\"/home/xvgnwgb/check/wp-includes/blocks/latest-posts\";i:11447;s:50:\"/home/xvgnwgb/check/wp-includes/blocks/social-link\";i:3510;s:44:\"/home/xvgnwgb/check/wp-includes/blocks/quote\";i:7166;s:50:\"/home/xvgnwgb/check/wp-includes/blocks/post-author\";i:3959;s:48:\"/home/xvgnwgb/check/wp-includes/blocks/site-logo\";i:15709;s:44:\"/home/xvgnwgb/check/wp-includes/blocks/cover\";i:87729;s:56:\"/home/xvgnwgb/check/wp-includes/blocks/comment-edit-link\";i:1654;s:57:\"/home/xvgnwgb/check/wp-includes/blocks/comment-reply-link\";i:1447;s:57:\"/home/xvgnwgb/check/wp-includes/blocks/post-comments-form\";i:10059;s:48:\"/home/xvgnwgb/check/wp-includes/blocks/tag-cloud\";i:4274;s:49:\"/home/xvgnwgb/check/wp-includes/blocks/site-title\";i:3051;s:45:\"/home/xvgnwgb/check/wp-includes/blocks/avatar\";i:2296;s:49:\"/home/xvgnwgb/check/wp-includes/blocks/navigation\";i:131175;s:44:\"/home/xvgnwgb/check/wp-includes/blocks/audio\";i:3675;s:46:\"/home/xvgnwgb/check/wp-includes/blocks/details\";i:2260;s:60:\"/home/xvgnwgb/check/wp-includes/blocks/query-pagination-next\";i:1039;s:48:\"/home/xvgnwgb/check/wp-includes/blocks/page-list\";i:8293;s:52:\"/home/xvgnwgb/check/wp-includes/blocks/legacy-widget\";i:556;s:47:\"/home/xvgnwgb/check/wp-includes/blocks/nextpage\";i:3039;s:43:\"/home/xvgnwgb/check/wp-includes/blocks/html\";i:3770;s:51:\"/home/xvgnwgb/check/wp-includes/blocks/comment-date\";i:1562;s:45:\"/home/xvgnwgb/check/wp-includes/blocks/spacer\";i:4737;s:47:\"/home/xvgnwgb/check/wp-includes/blocks/archives\";i:2233;s:55:\"/home/xvgnwgb/check/wp-includes/blocks/comment-template\";i:3037;s:44:\"/home/xvgnwgb/check/wp-includes/blocks/group\";i:8051;s:55:\"/home/xvgnwgb/check/wp-includes/blocks/query-pagination\";i:5775;s:63:\"/home/xvgnwgb/check/wp-includes/blocks/comments-pagination-next\";i:1011;s:47:\"/home/xvgnwgb/check/wp-includes/blocks/loginout\";i:1474;s:53:\"/home/xvgnwgb/check/wp-includes/blocks/page-list-item\";i:1109;s:48:\"/home/xvgnwgb/check/wp-includes/blocks/home-link\";i:1130;s:51:\"/home/xvgnwgb/check/wp-includes/blocks/preformatted\";i:1907;s:48:\"/home/xvgnwgb/check/wp-includes/blocks/read-more\";i:2428;s:58:\"/home/xvgnwgb/check/wp-includes/blocks/comments-pagination\";i:8917;s:44:\"/home/xvgnwgb/check/wp-includes/blocks/image\";i:66363;s:58:\"/home/xvgnwgb/check/wp-includes/blocks/post-featured-image\";i:29843;s:42:\"/home/xvgnwgb/check/wp-includes/blocks/rss\";i:4900;s:43:\"/home/xvgnwgb/check/wp-includes/blocks/code\";i:2828;s:47:\"/home/xvgnwgb/check/wp-includes/blocks/calendar\";i:3804;s:57:\"/home/xvgnwgb/check/wp-includes/blocks/navigation-submenu\";i:6204;s:38:\"/home/xvgnwgb/check/wp-includes/blocks\";i:1535843;s:37:\"/home/xvgnwgb/check/wp-includes/fonts\";i:327011;s:46:\"/home/xvgnwgb/check/wp-includes/block-patterns\";i:8951;s:38:\"/home/xvgnwgb/check/wp-includes/assets\";i:28376;s:36:\"/home/xvgnwgb/check/wp-includes/l10n\";i:31237;s:44:\"/home/xvgnwgb/check/wp-includes/style-engine\";i:48119;s:65:\"/home/xvgnwgb/check/wp-includes/SimplePie/library/SimplePie/Cache\";i:15217;s:63:\"/home/xvgnwgb/check/wp-includes/SimplePie/library/SimplePie/Net\";i:2407;s:71:\"/home/xvgnwgb/check/wp-includes/SimplePie/library/SimplePie/Decode/HTML\";i:23828;s:66:\"/home/xvgnwgb/check/wp-includes/SimplePie/library/SimplePie/Decode\";i:23828;s:75:\"/home/xvgnwgb/check/wp-includes/SimplePie/library/SimplePie/XML/Declaration\";i:2493;s:63:\"/home/xvgnwgb/check/wp-includes/SimplePie/library/SimplePie/XML\";i:2493;s:65:\"/home/xvgnwgb/check/wp-includes/SimplePie/library/SimplePie/Parse\";i:2419;s:64:\"/home/xvgnwgb/check/wp-includes/SimplePie/library/SimplePie/HTTP\";i:2427;s:72:\"/home/xvgnwgb/check/wp-includes/SimplePie/library/SimplePie/Content/Type\";i:2482;s:67:\"/home/xvgnwgb/check/wp-includes/SimplePie/library/SimplePie/Content\";i:2482;s:59:\"/home/xvgnwgb/check/wp-includes/SimplePie/library/SimplePie\";i:101578;s:49:\"/home/xvgnwgb/check/wp-includes/SimplePie/library\";i:118803;s:50:\"/home/xvgnwgb/check/wp-includes/SimplePie/src/HTTP\";i:14907;s:58:\"/home/xvgnwgb/check/wp-includes/SimplePie/src/Content/Type\";i:9290;s:53:\"/home/xvgnwgb/check/wp-includes/SimplePie/src/Content\";i:9290;s:61:\"/home/xvgnwgb/check/wp-includes/SimplePie/src/XML/Declaration\";i:9451;s:49:\"/home/xvgnwgb/check/wp-includes/SimplePie/src/XML\";i:9451;s:51:\"/home/xvgnwgb/check/wp-includes/SimplePie/src/Parse\";i:26853;s:49:\"/home/xvgnwgb/check/wp-includes/SimplePie/src/Net\";i:8737;s:57:\"/home/xvgnwgb/check/wp-includes/SimplePie/src/Decode/HTML\";i:17241;s:52:\"/home/xvgnwgb/check/wp-includes/SimplePie/src/Decode\";i:17241;s:51:\"/home/xvgnwgb/check/wp-includes/SimplePie/src/Cache\";i:68936;s:45:\"/home/xvgnwgb/check/wp-includes/SimplePie/src\";i:716234;s:41:\"/home/xvgnwgb/check/wp-includes/SimplePie\";i:839047;s:36:\"/home/xvgnwgb/check/wp-includes/pomo\";i:57146;s:46:\"/home/xvgnwgb/check/wp-includes/block-supports\";i:132630;s:44:\"/home/xvgnwgb/check/wp-includes/theme-compat\";i:15656;s:40:\"/home/xvgnwgb/check/wp-includes/html-api\";i:536362;s:43:\"/home/xvgnwgb/check/wp-includes/js/plupload\";i:490754;s:40:\"/home/xvgnwgb/check/wp-includes/js/jcrop\";i:24976;s:44:\"/home/xvgnwgb/check/wp-includes/js/jquery/ui\";i:787634;s:41:\"/home/xvgnwgb/check/wp-includes/js/jquery\";i:1304968;s:46:\"/home/xvgnwgb/check/wp-includes/js/dist/vendor\";i:2701413;s:51:\"/home/xvgnwgb/check/wp-includes/js/dist/development\";i:179848;s:68:\"/home/xvgnwgb/check/wp-includes/js/dist/script-modules/interactivity\";i:312802;s:75:\"/home/xvgnwgb/check/wp-includes/js/dist/script-modules/interactivity-router\";i:21116;s:59:\"/home/xvgnwgb/check/wp-includes/js/dist/script-modules/a11y\";i:5613;s:75:\"/home/xvgnwgb/check/wp-includes/js/dist/script-modules/block-library/search\";i:5460;s:79:\"/home/xvgnwgb/check/wp-includes/js/dist/script-modules/block-library/navigation\";i:11881;s:74:\"/home/xvgnwgb/check/wp-includes/js/dist/script-modules/block-library/query\";i:6276;s:74:\"/home/xvgnwgb/check/wp-includes/js/dist/script-modules/block-library/image\";i:22849;s:73:\"/home/xvgnwgb/check/wp-includes/js/dist/script-modules/block-library/file\";i:3826;s:73:\"/home/xvgnwgb/check/wp-includes/js/dist/script-modules/block-library/form\";i:2559;s:68:\"/home/xvgnwgb/check/wp-includes/js/dist/script-modules/block-library\";i:52851;s:54:\"/home/xvgnwgb/check/wp-includes/js/dist/script-modules\";i:392382;s:39:\"/home/xvgnwgb/check/wp-includes/js/dist\";i:22295514;s:45:\"/home/xvgnwgb/check/wp-includes/js/codemirror\";i:1287141;s:39:\"/home/xvgnwgb/check/wp-includes/js/crop\";i:20004;s:60:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/textcolor\";i:16237;s:56:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/media\";i:57914;s:64:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/wptextpattern\";i:11923;s:60:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/wordpress\";i:50553;s:53:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/hr\";i:1347;s:57:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/wpview\";i:8985;s:65:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/directionality\";i:2749;s:58:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/charmap\";i:31811;s:62:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/wpeditimage\";i:37709;s:61:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/fullscreen\";i:7779;s:59:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/tabfocus\";i:5336;s:60:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/wpgallery\";i:4806;s:60:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/wpdialogs\";i:3761;s:62:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/colorpicker\";i:4910;s:58:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/wpemoji\";i:5099;s:56:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/paste\";i:113193;s:56:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/lists\";i:97383;s:63:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/wpautoresize\";i:8332;s:57:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/wplink\";i:26786;s:56:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/image\";i:55874;s:55:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/link\";i:32949;s:63:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/compat3x/css\";i:8179;s:59:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins/compat3x\";i:21758;s:50:\"/home/xvgnwgb/check/wp-includes/js/tinymce/plugins\";i:607194;s:48:\"/home/xvgnwgb/check/wp-includes/js/tinymce/utils\";i:18826;s:62:\"/home/xvgnwgb/check/wp-includes/js/tinymce/skins/lightgray/img\";i:2856;s:64:\"/home/xvgnwgb/check/wp-includes/js/tinymce/skins/lightgray/fonts\";i:155760;s:58:\"/home/xvgnwgb/check/wp-includes/js/tinymce/skins/lightgray\";i:210254;s:65:\"/home/xvgnwgb/check/wp-includes/js/tinymce/skins/wordpress/images\";i:16653;s:58:\"/home/xvgnwgb/check/wp-includes/js/tinymce/skins/wordpress\";i:25413;s:48:\"/home/xvgnwgb/check/wp-includes/js/tinymce/skins\";i:235667;s:56:\"/home/xvgnwgb/check/wp-includes/js/tinymce/themes/modern\";i:446221;s:56:\"/home/xvgnwgb/check/wp-includes/js/tinymce/themes/inlite\";i:452642;s:49:\"/home/xvgnwgb/check/wp-includes/js/tinymce/themes\";i:898863;s:48:\"/home/xvgnwgb/check/wp-includes/js/tinymce/langs\";i:15529;s:42:\"/home/xvgnwgb/check/wp-includes/js/tinymce\";i:2856553;s:48:\"/home/xvgnwgb/check/wp-includes/js/imgareaselect\";i:49553;s:43:\"/home/xvgnwgb/check/wp-includes/js/thickbox\";i:31323;s:57:\"/home/xvgnwgb/check/wp-includes/js/mediaelement/renderers\";i:18880;s:47:\"/home/xvgnwgb/check/wp-includes/js/mediaelement\";i:721307;s:44:\"/home/xvgnwgb/check/wp-includes/js/swfupload\";i:8715;s:34:\"/home/xvgnwgb/check/wp-includes/js\";i:31513410;s:31:\"/home/xvgnwgb/check/wp-includes\";i:50939930;s:19:\"/home/xvgnwgb/check\";i:66598489;s:50:\"/home/xvgnwgb/check/wp-content/themes/checkup/font\";i:777780;s:48:\"/home/xvgnwgb/check/wp-content/themes/checkup/js\";i:88305;s:45:\"/home/xvgnwgb/check/wp-content/themes/checkup\";i:909876;s:70:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/styles/sections\";i:10657;s:68:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/styles/blocks\";i:1977;s:72:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/styles/typography\";i:38357;s:68:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/styles/colors\";i:25175;s:61:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/styles\";i:140995;s:65:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/assets/css\";i:157;s:68:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/assets/images\";i:1945719;s:76:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/assets/fonts/vollkorn\";i:357316;s:82:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/assets/fonts/ysabeau-office\";i:299520;s:75:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/assets/fonts/beiruti\";i:176048;s:77:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/assets/fonts/fira-code\";i:106112;s:76:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/assets/fonts/literata\";i:1698956;s:77:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/assets/fonts/fira-sans\";i:2778636;s:75:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/assets/fonts/manrope\";i:53600;s:75:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/assets/fonts/platypi\";i:142896;s:79:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/assets/fonts/roboto-slab\";i:115804;s:67:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/assets/fonts\";i:5728888;s:61:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/assets\";i:7674764;s:63:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/patterns\";i:346754;s:60:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/parts\";i:440;s:64:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive/templates\";i:5339;s:54:\"/home/xvgnwgb/check/wp-content/themes/twentytwentyfive\";i:8415501;s:37:\"/home/xvgnwgb/check/wp-content/themes\";i:9325405;s:57:\"/home/xvgnwgb/check/wp-content/plugins/duplicate-page/inc\";i:6276;s:56:\"/home/xvgnwgb/check/wp-content/plugins/duplicate-page/js\";i:1860;s:63:\"/home/xvgnwgb/check/wp-content/plugins/duplicate-page/languages\";i:49912;s:57:\"/home/xvgnwgb/check/wp-content/plugins/duplicate-page/css\";i:2327;s:53:\"/home/xvgnwgb/check/wp-content/plugins/duplicate-page\";i:85175;s:86:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/includes/cool-timeline-block/src\";i:5768;s:89:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/includes/cool-timeline-block/images\";i:126179;s:94:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/includes/cool-timeline-block/dist/images\";i:126179;s:87:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/includes/cool-timeline-block/dist\";i:4572733;s:96:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/includes/cool-timeline-block/assets/images\";i:74948;s:89:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/includes/cool-timeline-block/assets\";i:99659;s:82:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/includes/cool-timeline-block\";i:4804339;s:82:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/includes/gutenberg-block/src\";i:345;s:84:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/includes/gutenberg-block/build\";i:206723;s:78:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/includes/gutenberg-block\";i:209299;s:62:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/includes\";i:5013638;s:75:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/admin/feedback/images\";i:6031;s:72:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/admin/feedback/css\";i:2849;s:71:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/admin/feedback/js\";i:4649;s:68:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/admin/feedback\";i:22550;s:59:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block/admin\";i:22550;s:53:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block\";i:5054066;s:77:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/src/Site_Health\";i:22485;s:72:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/src/Blocks\";i:2742;s:70:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/src/Meta\";i:11224;s:65:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/src\";i:36451;s:66:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/lang\";i:17708878;s:77:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/vendor/composer\";i:21238;s:68:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/vendor\";i:21986;s:77:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/fields\";i:386155;s:80:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/locations\";i:49569;s:76:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/forms\";i:78689;s:79:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/rest-api\";i:32240;s:81:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/post-types\";i:74303;s:82:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/admin/tools\";i:24484;s:98:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/admin/views/acf-field-group\";i:40522;s:88:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/admin/views/tools\";i:762;s:95:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/admin/views/acf-taxonomy\";i:49420;s:90:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/admin/views/upgrade\";i:9821;s:89:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/admin/views/global\";i:15839;s:96:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/admin/views/acf-post-type\";i:51512;s:82:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/admin/views\";i:178066;s:87:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/admin/post-types\";i:73536;s:76:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/admin\";i:348952;s:74:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/api\";i:143398;s:78:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/walkers\";i:3546;s:75:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/ajax\";i:25592;s:77:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes/legacy\";i:1824;s:70:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/includes\";i:1497575;s:77:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/build/js\";i:226348;s:78:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/build/css\";i:361255;s:74:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/build\";i:587646;s:83:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/inc/timepicker\";i:130999;s:91:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/inc/color-picker-alpha\";i:24330;s:90:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/inc/datepicker/images\";i:11440;s:83:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/inc/datepicker\";i:61417;s:82:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/inc/select2/3\";i:268808;s:82:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/inc/select2/4\";i:582485;s:80:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/inc/select2\";i:851336;s:72:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/inc\";i:1068125;s:92:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/images/field-type-icons\";i:28512;s:95:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/images/field-type-previews\";i:676097;s:88:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/images/field-states\";i:671;s:81:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/images/icons\";i:48333;s:75:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets/images\";i:1170616;s:68:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields/assets\";i:2826387;s:61:\"/home/xvgnwgb/check/wp-content/plugins/advanced-custom-fields\";i:22156654;s:60:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/assets\";i:31340;s:63:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/languages\";i:128;s:79:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/includes/config-validator\";i:33313;s:66:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/includes/css\";i:3099;s:100:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/includes/js/jquery-ui/themes/smoothness/images\";i:32598;s:93:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/includes/js/jquery-ui/themes/smoothness\";i:118302;s:82:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/includes/js/jquery-ui/themes\";i:118302;s:75:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/includes/js/jquery-ui\";i:118302;s:65:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/includes/js\";i:132493;s:75:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/includes/block-editor\";i:6274;s:69:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/includes/swv/js\";i:12593;s:76:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/includes/swv/php/rules\";i:17834;s:70:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/includes/swv/php\";i:21490;s:66:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/includes/swv\";i:39838;s:62:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/includes\";i:453569;s:72:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/modules/sendinblue\";i:27975;s:71:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/modules/turnstile\";i:12852;s:71:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/modules/recaptcha\";i:15596;s:68:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/modules/stripe\";i:23319;s:69:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/modules/akismet\";i:8452;s:78:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/modules/constant-contact\";i:4610;s:61:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/modules\";i:191986;s:71:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/admin/includes/js\";i:13103;s:72:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/admin/includes/css\";i:11393;s:68:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/admin/includes\";i:80086;s:59:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7/admin\";i:111721;s:53:\"/home/xvgnwgb/check/wp-content/plugins/contact-form-7\";i:820522;s:78:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/lib\";i:0;s:90:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/composer\";i:42854;s:108:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/mlocati/ip-lib/src/Address\";i:45977;s:108:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/mlocati/ip-lib/src/Service\";i:13782;s:106:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/mlocati/ip-lib/src/Range\";i:39282;s:100:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/mlocati/ip-lib/src\";i:112345;s:96:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/mlocati/ip-lib\";i:139125;s:89:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/mlocati\";i:139125;s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/team-updraft/common-libs/CI\";i:1206;s:124:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/team-updraft/common-libs/src/updraft-tasks\";i:44491;s:126:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/team-updraft/common-libs/src/updraft-notices\";i:8102;s:128:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/team-updraft/common-libs/src/updraft-semaphore\";i:9101;s:122:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/team-updraft/common-libs/src/updraft-rpc\";i:42018;s:110:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/team-updraft/common-libs/src\";i:103712;s:106:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/team-updraft/common-libs\";i:106095;s:94:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor/team-updraft\";i:106095;s:81:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/vendor\";i:288845;s:82:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/backups\";i:0;s:103:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/dashboard\";i:36461;s:116:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/user-security/partials\";i:1938;s:107:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/user-security\";i:42780;s:114:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/brute-force/partials\";i:14347;s:105:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/brute-force\";i:57503;s:101:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/scanner\";i:16651;s:122:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/filesystem-security/partials\";i:6890;s:113:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/filesystem-security\";i:18835;s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/database-security\";i:6353;s:109:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/spam-prevention\";i:17013;s:102:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/settings\";i:31132;s:108:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/tools/partials\";i:267;s:99:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/tools\";i:11363;s:101:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/general\";i:920;s:111:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/firewall/partials\";i:43939;s:102:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin/firewall\";i:65794;s:93:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/wp-admin\";i:304805;s:89:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/info\";i:1917;s:92:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/notices\";i:18754;s:90:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/admin\";i:944;s:93:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates/partials\";i:661;s:84:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/templates\";i:327081;s:94:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/images/plugin-logos\";i:150702;s:89:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/images/notices\";i:297400;s:81:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/images\";i:471554;s:89:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/other-includes\";i:208864;s:79:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/logs\";i:0;s:103:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/includes/simba-tfa/templates\";i:17907;s:116:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/includes/simba-tfa/includes/jquery-qrcode\";i:88537;s:102:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/includes/simba-tfa/includes\";i:406298;s:115:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/includes/simba-tfa/providers/totp/Base32\";i:4548;s:124:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/includes/simba-tfa/providers/totp/hotp-php-master\";i:12790;s:108:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/includes/simba-tfa/providers/totp\";i:54296;s:103:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/includes/simba-tfa/providers\";i:54296;s:93:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/includes/simba-tfa\";i:539027;s:91:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/includes/chartjs\";i:231378;s:91:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/includes/blockui\";i:20586;s:83:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/includes\";i:790991;s:88:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/admin/general\";i:84550;s:80:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/admin\";i:326277;s:103:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/firewall/libs/traits\";i:865;s:96:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/firewall/libs\";i:20919;s:104:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/firewall/rule/actions\";i:4464;s:105:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/firewall/rule/rules/6g\";i:7295;s:107:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/firewall/rule/rules/bots\";i:4100;s:113:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/firewall/rule/rules/bruteforce\";i:4996;s:110:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/firewall/rule/rules/general\";i:7470;s:112:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/firewall/rule/rules/blacklist\";i:2733;s:102:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/firewall/rule/rules\";i:26594;s:96:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/firewall/rule\";i:34094;s:98:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/firewall/family\";i:3223;s:91:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/firewall\";i:72024;s:95:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/grade-system\";i:29456;s:91:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/commands\";i:145559;s:82:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/classes\";i:797429;s:78:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/css\";i:29056;s:77:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/js\";i:72137;s:84:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall/languages\";i:2187864;s:74:\"/home/xvgnwgb/check/wp-content/plugins/all-in-one-wp-security-and-firewall\";i:5679509;s:51:\"/home/xvgnwgb/check/wp-content/plugins/daisy-titles\";i:38637;s:63:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/languages\";i:49765;s:69:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/vendor/composer\";i:22403;s:60:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/vendor\";i:22581;s:61:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/classes\";i:30144;s:63:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/assets/js\";i:1472;s:60:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login/assets\";i:1472;s:53:\"/home/xvgnwgb/check/wp-content/plugins/wps-hide-login\";i:128063;s:93:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/design-library\";i:44592;s:93:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/welcome/images\";i:64476;s:86:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/welcome\";i:96212;s:87:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/lightbox\";i:997;s:130:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/components/__experimental-multi-post-picker-control\";i:1719;s:89:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/components\";i:1807;s:90:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/posts\";i:18936;s:91:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/expand\";i:1136;s:90:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/image\";i:583;s:96:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/pricing-box\";i:952;s:89:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/tabs\";i:1189;s:88:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/map\";i:1359;s:96:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/tab-content\";i:514;s:93:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/subtitle\";i:596;s:94:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/image-box\";i:792;s:92:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/heading\";i:599;s:97:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/feature-grid\";i:843;s:93:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/icon-box\";i:701;s:94:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/countdown\";i:1012;s:89:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/icon\";i:597;s:95:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/tab-labels\";i:529;s:95:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/blockquote\";i:646;s:99:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/design-library\";i:668;s:89:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/card\";i:845;s:91:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/button\";i:663;s:99:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/icon-list-item\";i:669;s:92:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/columns\";i:1601;s:91:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/column\";i:800;s:92:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/feature\";i:821;s:94:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/icon-list\";i:758;s:89:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/text\";i:595;s:96:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/testimonial\";i:844;s:102:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/table-of-contents\";i:1012;s:94:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/accordion\";i:5490;s:93:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/count-up\";i:1055;s:99:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/call-to-action\";i:894;s:93:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/carousel\";i:2712;s:100:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/progress-circle\";i:1750;s:94:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/separator\";i:599;s:92:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/divider\";i:453;s:96:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/video-popup\";i:4469;s:96:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/team-member\";i:883;s:97:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/notification\";i:1355;s:89:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/hero\";i:813;s:97:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/button-group\";i:1446;s:93:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/timeline\";i:1623;s:90:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/price\";i:712;s:91:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/spacer\";i:406;s:95:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/icon-label\";i:2163;s:97:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/progress-bar\";i:1708;s:104:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/horizontal-scroller\";i:2675;s:96:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/icon-button\";i:683;s:95:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block/number-box\";i:614;s:84:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block\";i:72851;s:105:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block-components/alignment\";i:4803;s:95:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/block-components\";i:4891;s:116:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/plugins/theme-block-style-inheritance\";i:23437;s:118:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/plugins/global-settings/preset-controls\";i:8517;s:115:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/plugins/global-settings/block-styles\";i:3052;s:127:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/plugins/global-settings/color-schemes/deprecated\";i:638;s:116:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/plugins/global-settings/color-schemes\";i:22874;s:120:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/plugins/global-settings/buttons-and-icons\";i:5641;s:122:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/plugins/global-settings/spacing-and-borders\";i:5750;s:102:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/plugins/global-settings\";i:45922;s:86:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/plugins\";i:69447;s:85:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/styles\";i:4777;s:100:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/compatibility/blocksy\";i:3708;s:97:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/compatibility/neve\";i:1116;s:92:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/compatibility\";i:8436;s:104:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/block-defaults\";i:14300;s:108:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/separator\";i:325;s:110:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/pricing-box\";i:300;s:109:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/blog-posts\";i:73320;s:105:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/header\";i:333;s:106:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/columns\";i:404;s:106:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/feature\";i:294;s:105:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/spacer\";i:272;s:108:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/accordion\";i:385;s:107:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/count-up\";i:371;s:109:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/number-box\";i:339;s:111:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/notification\";i:374;s:106:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/heading\";i:325;s:106:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/divider\";i:272;s:111:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/feature-grid\";i:340;s:108:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/container\";i:368;s:105:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/expand\";i:372;s:108:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/icon-list\";i:370;s:113:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/call-to-action\";i:402;s:110:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/testimonial\";i:306;s:105:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/button\";i:291;s:103:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/text\";i:325;s:105:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/column\";i:422;s:109:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/blockquote\";i:269;s:110:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/video-popup\";i:427;s:110:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/team-member\";i:349;s:103:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/card\";i:367;s:108:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/image-box\";i:348;s:103:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block/icon\";i:326;s:98:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/block\";i:82684;s:107:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2/design-library\";i:4067;s:92:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated/v2\";i:113142;s:89:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src/deprecated\";i:137747;s:78:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/src\";i:616586;s:86:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/dist/images\";i:226485;s:84:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/dist/data\";i:210529;s:90:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/dist/deprecated\";i:1107022;s:79:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/dist\";i:4546186;s:84:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks/languages\";i:330167;s:74:\"/home/xvgnwgb/check/wp-content/plugins/stackable-ultimate-gutenberg-blocks\";i:5554208;s:52:\"/home/xvgnwgb/check/wp-content/plugins/akismet/views\";i:45789;s:57:\"/home/xvgnwgb/check/wp-content/plugins/akismet/_inc/fonts\";i:2193;s:55:\"/home/xvgnwgb/check/wp-content/plugins/akismet/_inc/rtl\";i:21147;s:55:\"/home/xvgnwgb/check/wp-content/plugins/akismet/_inc/img\";i:18257;s:51:\"/home/xvgnwgb/check/wp-content/plugins/akismet/_inc\";i:88548;s:46:\"/home/xvgnwgb/check/wp-content/plugins/akismet\";i:374515;s:59:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/includes\";i:2175;s:55:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/scss\";i:8341;s:54:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/css\";i:6093;s:67:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/vendor/DOMPurify\";i:22392;s:89:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/vendor/enshrined/svg-sanitize/src/data\";i:12532;s:95:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/vendor/enshrined/svg-sanitize/src/Exceptions\";i:794;s:101:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/vendor/enshrined/svg-sanitize/src/ElementReference\";i:9511;s:84:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/vendor/enshrined/svg-sanitize/src\";i:49237;s:80:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/vendor/enshrined/svg-sanitize\";i:49237;s:67:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/vendor/enshrined\";i:49237;s:66:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/vendor/composer\";i:44695;s:57:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/vendor\";i:117095;s:57:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/js/min\";i:15262;s:53:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/js\";i:51264;s:60:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/admin/img\";i:3373;s:56:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/admin\";i:50777;s:60:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/functions\";i:34138;s:63:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/integrations\";i:2508;s:60:\"/home/xvgnwgb/check/wp-content/plugins/svg-support/languages\";i:38093;s:50:\"/home/xvgnwgb/check/wp-content/plugins/svg-support\";i:471531;s:78:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/assets/images/demo\";i:411834;s:73:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/assets/images\";i:412211;s:69:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/assets/js\";i:23804;s:70:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/assets/css\";i:7958;s:66:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/assets\";i:443973;s:69:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/languages\";i:9966;s:81:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/bplugins_sdk/inc/Base\";i:29919;s:76:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/bplugins_sdk/inc\";i:30438;s:82:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/bplugins_sdk/languages\";i:1250;s:77:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/bplugins_sdk/dist\";i:217259;s:72:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/bplugins_sdk\";i:254197;s:64:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/i18n\";i:8534;s:68:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/includes\";i:1407;s:72:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/build/images\";i:412751;s:65:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block/build\";i:4419128;s:59:\"/home/xvgnwgb/check/wp-content/plugins/timeline-block-block\";i:5150970;s:64:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/models/firewall\";i:16494;s:62:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/models/common\";i:845;s:63:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/models/scanner\";i:44084;s:61:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/models/block\";i:73831;s:60:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/models/page\";i:7216;s:55:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/models\";i:142824;s:59:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/css/images\";i:36376;s:60:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/css/license\";i:178589;s:52:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/css\";i:746889;s:57:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/waf/pomo\";i:58095;s:52:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/waf\";i:123920;s:52:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/tmp\";i:15;s:58:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/languages\";i:465391;s:62:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/reports\";i:45080;s:65:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/onboarding\";i:18150;s:61:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/common\";i:30941;s:63:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/blocking\";i:426132;s:59:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/user\";i:1093;s:60:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/tools\";i:15321;s:64:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/dashboard\";i:60964;s:62:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/scanner\";i:200353;s:62:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/options\";i:55546;s:66:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/offboarding\";i:8252;s:58:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/waf\";i:126126;s:60:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/tours\";i:4949;s:66:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/diagnostics\";i:18856;s:70:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/unsupported-php\";i:1038;s:59:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/gdpr\";i:4406;s:69:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views/unsupported-wp\";i:1178;s:54:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/views\";i:1018739;s:64:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/vendor/composer\";i:36677;s:84:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/vendor/wordfence/mmdb-reader/src/Io\";i:2249;s:91:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/vendor/wordfence/mmdb-reader/src/Exception\";i:1541;s:81:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/vendor/wordfence/mmdb-reader/src\";i:27521;s:77:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/vendor/wordfence/mmdb-reader\";i:27521;s:88:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/vendor/wordfence/wf-waf/src/lib/storage\";i:75142;s:87:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/vendor/wordfence/wf-waf/src/lib/parser\";i:126381;s:80:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/vendor/wordfence/wf-waf/src/lib\";i:458422;s:82:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/vendor/wordfence/wf-waf/src/views\";i:47958;s:76:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/vendor/wordfence/wf-waf/src\";i:729979;s:72:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/vendor/wordfence/wf-waf\";i:729979;s:65:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/vendor/wordfence\";i:757500;s:55:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/vendor\";i:794791;s:61:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/lib/rest-api\";i:27229;s:62:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/lib/dashboard\";i:40491;s:71:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/lib/Diff/Renderer/Html\";i:13804;s:66:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/lib/Diff/Renderer\";i:16854;s:57:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/lib/Diff\";i:34726;s:62:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/lib/audit-log\";i:112014;s:52:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/lib\";i:12217387;s:90:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/lib\";i:87773;s:116:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/namespaced/Core/Curve25519/Ge\";i:897;s:113:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/namespaced/Core/Curve25519\";i:1233;s:111:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/namespaced/Core/ChaCha20\";i:342;s:111:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/namespaced/Core/Poly1305\";i:171;s:102:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/namespaced/Core\";i:3801;s:97:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/namespaced\";i:4232;s:96:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/PHP52\";i:4175;s:102:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core/Base64\";i:15574;s:104:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core/ChaCha20\";i:5382;s:108:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core/SecretStream\";i:3683;s:104:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core/Poly1305\";i:12971;s:109:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core/Curve25519/Ge\";i:8176;s:106:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core/Curve25519\";i:121840;s:95:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core\";i:447439;s:106:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core32/ChaCha20\";i:6525;s:106:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core32/Poly1305\";i:16024;s:111:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core32/Curve25519/Ge\";i:8472;s:108:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core32/Curve25519\";i:122885;s:110:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core32/SecretStream\";i:3715;s:97:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core32\";i:438357;s:90:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src\";i:1203620;s:86:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat\";i:1302527;s:90:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/random_compat/lib\";i:43920;s:91:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/random_compat/dist\";i:703;s:86:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie/random_compat\";i:45721;s:72:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/paragonie\";i:1348248;s:71:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor/composer\";i:41647;s:62:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto/vendor\";i:1390155;s:55:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/crypto\";i:1390155;s:54:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/fonts\";i:289944;s:51:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/js\";i:780698;s:90:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/classes/controller\";i:194969;s:94:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/classes/model/settings\";i:4737;s:90:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/classes/model/view\";i:1813;s:92:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/classes/model/crypto\";i:14301;s:90:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/classes/model/text\";i:1675;s:85:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/classes/model\";i:57435;s:87:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/classes/utility\";i:11223;s:79:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/classes\";i:263982;s:74:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/js\";i:317951;s:75:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/css\";i:365204;s:88:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/views/onboarding\";i:1749;s:82:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/views/user\";i:528;s:83:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/views/email\";i:1349;s:84:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/views/common\";i:8004;s:86:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/views/settings\";i:17961;s:82:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/views/page\";i:17127;s:85:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/views/options\";i:73364;s:84:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/views/manage\";i:21490;s:77:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/views\";i:141927;s:75:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security/img\";i:48448;s:71:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules/login-security\";i:1140681;s:56:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/modules\";i:1140681;s:61:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/images/icons\";i:82660;s:61:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/images/logos\";i:9280;s:55:\"/home/xvgnwgb/check/wp-content/plugins/wordfence/images\";i:402440;s:48:\"/home/xvgnwgb/check/wp-content/plugins/wordfence\";i:19601482;s:38:\"/home/xvgnwgb/check/wp-content/plugins\";i:65115360;s:46:\"/home/xvgnwgb/check/wp-content/uploads/2025/08\";i:415981;s:46:\"/home/xvgnwgb/check/wp-content/uploads/2025/09\";i:0;s:46:\"/home/xvgnwgb/check/wp-content/uploads/2025/07\";i:529254;s:43:\"/home/xvgnwgb/check/wp-content/uploads/2025\";i:945235;s:52:\"/home/xvgnwgb/check/wp-content/uploads/wpcf7_uploads\";i:152;s:58:\"/home/xvgnwgb/check/wp-content/uploads/aios/firewall-rules\";i:908;s:43:\"/home/xvgnwgb/check/wp-content/uploads/aios\";i:908;s:38:\"/home/xvgnwgb/check/wp-content/uploads\";i:946295;}", "off");
INSERT INTO `cupoptions` VALUES("2174", "wp_calendar_block_has_published_posts", "", "auto");
INSERT INTO `cupoptions` VALUES("2390", "category_children", "a:0:{}", "auto");
INSERT INTO `cupoptions` VALUES("2430", "cmplz_activation_time", "1756815120", "off");
INSERT INTO `cupoptions` VALUES("2434", "cmplz_wsc_onboarding_status", "a:3:{s:5:\"terms\";b:0;s:10:\"newsletter\";b:1;s:7:\"plugins\";b:0;}", "off");
INSERT INTO `cupoptions` VALUES("2435", "cmplz_active_integrations", "2", "auto");
INSERT INTO `cupoptions` VALUES("2436", "cmplz_integrations_changed", "", "auto");
INSERT INTO `cupoptions` VALUES("2437", "cmplz_cookietable_version", "7.4.2", "auto");
INSERT INTO `cupoptions` VALUES("2438", "cmplz_cbdb_version", "7.4.2", "auto");
INSERT INTO `cupoptions` VALUES("2439", "cmplz_dnsmpd_db_version", "7.4.2", "off");
INSERT INTO `cupoptions` VALUES("2440", "cmplz_preloaded_privacy_info", "a:3:{i:0;a:3:{s:11:\"plugin_name\";s:9:\"WordPress\";s:11:\"policy_text\";s:5353:\"<h2 class=\"wp-block-heading\">Qui sommes-nous ?</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>L’adresse de notre site est : https://up.thera.fr.</p><h2 class=\"wp-block-heading\">Commentaires</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Quand vous laissez un commentaire sur notre site, les données inscrites dans le formulaire de commentaire, ainsi que votre adresse IP et l’agent utilisateur de votre navigateur sont collectés pour nous aider à la détection des commentaires indésirables.</p><p>Une chaîne anonymisée créée à partir de votre adresse e-mail (également appelée hash) peut être envoyée au service Gravatar pour vérifier si vous utilisez ce dernier. Les clauses de confidentialité du service Gravatar sont disponibles ici : https://automattic.com/privacy/. Après validation de votre commentaire, votre photo de profil sera visible publiquement à coté de votre commentaire.</p><h2 class=\"wp-block-heading\">Médias</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous téléversez des images sur le site, nous vous conseillons d’éviter de téléverser des images contenant des données EXIF de coordonnées GPS. Les personnes visitant votre site peuvent télécharger et extraire des données de localisation depuis ces images.</p><h2 class=\"wp-block-heading\">Cookies</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous déposez un commentaire sur notre site, il vous sera proposé d’enregistrer votre nom, adresse e-mail et site dans des cookies. C’est uniquement pour votre confort afin de ne pas avoir à saisir ces informations si vous déposez un autre commentaire plus tard. Ces cookies expirent au bout d’un an.</p><p>Si vous vous rendez sur la page de connexion, un cookie temporaire sera créé afin de déterminer si votre navigateur accepte les cookies. Il ne contient pas de données personnelles et sera supprimé automatiquement à la fermeture de votre navigateur.</p><p>Lorsque vous vous connecterez, nous mettrons en place un certain nombre de cookies pour enregistrer vos informations de connexion et vos préférences d’écran. La durée de vie d’un cookie de connexion est de deux jours, celle d’un cookie d’option d’écran est d’un an. Si vous cochez « Se souvenir de moi », votre cookie de connexion sera conservé pendant deux semaines. Si vous vous déconnectez de votre compte, le cookie de connexion sera effacé.</p><p>En modifiant ou en publiant une publication, un cookie supplémentaire sera enregistré dans votre navigateur. Ce cookie ne comprend aucune donnée personnelle. Il indique simplement l’ID de la publication que vous venez de modifier. Il expire au bout d’un jour.</p><h2 class=\"wp-block-heading\">Contenu embarqué depuis d’autres sites</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les articles de ce site peuvent inclure des contenus intégrés (par exemple des vidéos, images, articles…). Le contenu intégré depuis d’autres sites se comporte de la même manière que si le visiteur se rendait sur cet autre site.</p><p>Ces sites web pourraient collecter des données sur vous, utiliser des cookies, embarquer des outils de suivis tiers, suivre vos interactions avec ces contenus embarqués si vous disposez d’un compte connecté sur leur site web.</p><h2 class=\"wp-block-heading\">Utilisation et transmission de vos données personnelles</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous demandez une réinitialisation de votre mot de passe, votre adresse IP sera incluse dans l’e-mail de réinitialisation.</p><h2 class=\"wp-block-heading\">Durées de stockage de vos données</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous laissez un commentaire, le commentaire et ses métadonnées sont conservés indéfiniment. Cela permet de reconnaître et approuver automatiquement les commentaires suivants au lieu de les laisser dans la file de modération.</p><p>Pour les comptes qui s’inscrivent sur notre site (le cas échéant), nous stockons également les données personnelles indiquées dans leur profil. Tous les comptes peuvent voir, modifier ou supprimer leurs informations personnelles à tout moment (à l’exception de leur identifiant). Les gestionnaires du site peuvent aussi voir et modifier ces informations.</p><h2 class=\"wp-block-heading\">Les droits que vous avez sur vos données</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous avez un compte ou si vous avez laissé des commentaires sur le site, vous pouvez demander à recevoir un fichier contenant toutes les données personnelles que nous possédons à votre sujet, incluant celles que vous nous avez fournies. Vous pouvez également demander la suppression des données personnelles vous concernant. Cela ne prend pas en compte les données stockées à des fins administratives, légales ou pour des raisons de sécurité.</p><h2 class=\"wp-block-heading\">Où vos données sont envoyées</h2><p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les commentaires des visiteurs peuvent être vérifiés à l’aide d’un service automatisé de détection des commentaires indésirables.</p>\";s:5:\"added\";i:1756815120;}i:1;a:3:{s:11:\"plugin_name\";s:43:\"Complianz | The Privacy Suite for WordPress\";s:11:\"policy_text\";s:559:\"<p>Ce site web utilise la Privacy Suite for WordPress de Complianz pour collecter et enregistrer le consentement basé sur le navigateur et l’appareil. Pour cette fonctionnalité, votre adresse IP est anonymisée et stockée dans notre base de données.&nbsp;Ce service ne traite aucune information permettant d’identifier une personne et ne partage aucune donnée avec le prestataire de services.&nbsp;Pour plus d’informations, consultez la <a href=\"https://complianz.io/legal/privacy-statement/\">Déclaration de confidentialité</a> de Complianz.</p>\n\";s:5:\"added\";i:1756816698;}i:2;a:3:{s:11:\"plugin_name\";s:7:\"Akismet\";s:11:\"policy_text\";s:529:\"Nous récupérons des informations sur les personnes qui commentent sur les sites utilisant la fonctionnalité contre les indésirables d’Akismet. Les informations collectées dépendent de la façon dont Akismet a été paramétré sur le site, et incluent généralement l’adresse IP de la personne ayant laissé un commentaire, l’agent utilisateur, référent, URL du site (ainsi que d’autres informations provenant directement du commentaire comme le nom, identifiant, adresse e-mail, et le commentaire en lui même).\";s:5:\"added\";i:1756816698;}}", "off");
INSERT INTO `cupoptions` VALUES("2441", "cmplz_first_version", "7.4.2", "off");
INSERT INTO `cupoptions` VALUES("2442", "cmplz_generate_new_cookiepolicy_snapshot", "", "off");
INSERT INTO `cupoptions` VALUES("2443", "cmplz-current-version", "7.4.2", "auto");
INSERT INTO `cupoptions` VALUES("2445", "cmplz_transients", "a:28:{s:36:\"cmplz_shortcode_privacy-statement-eu\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334809;}s:35:\"cmplz_shortcode_cookie-statement-us\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334809;}s:36:\"cmplz_shortcode_privacy-statement-us\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334809;}s:35:\"cmplz_shortcode_cookie-statement-uk\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334809;}s:36:\"cmplz_shortcode_privacy-statement-uk\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334809;}s:35:\"cmplz_shortcode_cookie-statement-ca\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334809;}s:36:\"cmplz_shortcode_privacy-statement-ca\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334809;}s:35:\"cmplz_shortcode_cookie-statement-au\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334809;}s:36:\"cmplz_shortcode_privacy-statement-au\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334809;}s:35:\"cmplz_shortcode_cookie-statement-za\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334809;}s:36:\"cmplz_shortcode_privacy-statement-za\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334809;}s:35:\"cmplz_shortcode_cookie-statement-br\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334809;}s:36:\"cmplz_shortcode_privacy-statement-br\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334809;}s:29:\"cmplz_shortcode_impressum-all\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334809;}s:37:\"cmplz_shortcode_privacy-statement-all\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334777;}s:46:\"cmplz_shortcode_privacy-statement-children-all\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334777;}s:28:\"cmplz_shortcode_impressum-eu\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334777;}s:30:\"cmplz_shortcode_disclaimer-all\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334777;}s:29:\"cmplz_shortcode_disclaimer-eu\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334777;}s:23:\"cmplz_shortcode_1091-eu\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334777;}s:24:\"cmplz_shortcode_1091-all\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334777;}s:19:\"cmplz_shortcode_-eu\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334777;}s:20:\"cmplz_shortcode_-all\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757334777;}s:45:\"cmplz_shortcode_privacy-statement-children-eu\";a:2:{s:5:\"value\";s:4:\"none\";s:7:\"expires\";i:1757339695;}s:35:\"cmplz_shortcode_cookie-statement-eu\";a:2:{s:5:\"value\";s:4:\"1091\";s:7:\"expires\";i:1758012309;}s:23:\"cmplz_default_banner_id\";a:2:{s:5:\"value\";s:1:\"1\";s:7:\"expires\";i:1757424478;}s:19:\"cmplz_min_banner_id\";a:2:{s:5:\"value\";s:1:\"1\";s:7:\"expires\";i:1757424478;}s:18:\"page_links_1_fr_FR\";a:2:{s:5:\"value\";a:1:{s:2:\"eu\";a:1:{s:16:\"cookie-statement\";a:2:{s:5:\"title\";s:21:\"Politique de cookies \";s:3:\"url\";s:44:\"https://up.thera.fr/politique-de-cookies-ue/\";}}}s:7:\"expires\";i:1757423706;}}", "auto");
INSERT INTO `cupoptions` VALUES("2450", "cmplz_options", "a:88:{s:11:\"use_cdb_api\";s:3:\"yes\";s:15:\"cmplz_wsc_email\";s:22:\"village@ca-centrest.fr\";s:27:\"notifications_email_address\";s:22:\"village@ca-centrest.fr\";s:24:\"send_notifications_email\";i:1;s:7:\"regions\";s:2:\"eu\";s:22:\"other_region_behaviour\";s:4:\"none\";s:18:\"eu_consent_regions\";s:2:\"no\";s:18:\"uk_consent_regions\";s:2:\"no\";s:17:\"ca_targets_quebec\";s:0:\"\";s:9:\"us_states\";a:0:{}s:21:\"wp_admin_access_users\";s:2:\"no\";s:16:\"cookie-statement\";s:9:\"generated\";s:17:\"privacy-statement\";s:4:\"none\";s:9:\"impressum\";s:4:\"none\";s:10:\"disclaimer\";s:4:\"none\";s:17:\"organisation_name\";s:11:\"Le Check\'up\";s:15:\"address_company\";s:59:\"1, avenue de Champfleury – 69410 CHAMPAGNE AU MONT D’OR\";s:15:\"country_company\";s:2:\"FR\";s:13:\"email_company\";s:22:\"village@ca-centrest.fr\";s:17:\"telephone_company\";s:14:\"04 72 52 8000.\";s:26:\"ca_name_accountable_person\";s:0:\"\";s:29:\"ca_address_accountable_person\";s:0:\"\";s:18:\"records_of_consent\";s:2:\"no\";s:11:\"datarequest\";s:2:\"no\";s:11:\"respect_dnt\";s:2:\"no\";s:31:\"sensitive_information_processed\";s:0:\"\";s:11:\"cookie_scan\";s:0:\"\";s:18:\"compile_statistics\";s:3:\"yes\";s:28:\"compile_statistics_more_info\";a:0:{}s:40:\"compile_statistics_more_info_tag_manager\";a:0:{}s:17:\"matomo_anonymized\";s:0:\"\";s:20:\"script_center_button\";s:3:\"yes\";s:26:\"configuration_by_complianz\";s:3:\"yes\";s:12:\"consent-mode\";s:2:\"no\";s:23:\"gtag-basic-consent-mode\";s:2:\"no\";s:25:\"cmplz-gtag-urlpassthrough\";s:2:\"no\";s:29:\"cmplz-gtag-ads_data_redaction\";s:2:\"no\";s:17:\"cmplz-tm-template\";s:2:\"no\";s:7:\"ua_code\";s:0:\"\";s:22:\"additional_gtags_stats\";s:0:\"\";s:8:\"gtm_code\";s:0:\"\";s:13:\"gtm_code_head\";s:2:\"no\";s:7:\"aw_code\";s:0:\"\";s:26:\"additional_gtags_marketing\";s:0:\"\";s:10:\"matomo_url\";s:0:\"\";s:14:\"matomo_site_id\";i:0;s:14:\"matomo_tag_url\";s:0:\"\";s:19:\"matomo_container_id\";s:0:\"\";s:14:\"clicky_site_id\";i:0;s:9:\"yandex_id\";i:0;s:10:\"clarity_id\";s:0:\"\";s:16:\"yandex_ecommerce\";s:2:\"no\";s:19:\"consent_per_service\";s:2:\"no\";s:24:\"uses_thirdparty_services\";s:2:\"no\";s:27:\"thirdparty_services_on_site\";a:0:{}s:23:\"block_recaptcha_service\";s:2:\"no\";s:22:\"self_host_google_fonts\";s:2:\"no\";s:21:\"block_hubspot_service\";s:2:\"no\";s:22:\"hotjar_privacyfriendly\";s:0:\"\";s:17:\"uses_social_media\";s:2:\"no\";s:19:\"socialmedia_on_site\";a:0:{}s:33:\"uses_firstparty_marketing_cookies\";s:2:\"no\";s:15:\"uses_ad_cookies\";s:2:\"no\";s:28:\"uses_ad_cookies_personalized\";s:2:\"no\";s:23:\"uses_wordpress_comments\";s:2:\"no\";s:31:\"block_wordpress_comment_cookies\";s:3:\"yes\";s:17:\"plugins_overviews\";s:0:\"\";s:19:\"cookiedatabase_sync\";s:0:\"\";s:16:\"create-documents\";s:0:\"\";s:15:\"region_redirect\";s:2:\"no\";s:17:\"add_pages_to_menu\";s:0:\"\";s:35:\"add_pages_to_menu_region_redirected\";s:0:\"\";s:22:\"cookie_banner_required\";s:1:\"1\";s:18:\"last-step-feedback\";s:0:\"\";s:20:\"enable_cookie_banner\";s:3:\"yes\";s:21:\"enable_cookie_blocker\";s:2:\"no\";s:9:\"safe_mode\";i:1;s:11:\"use_country\";i:0;s:21:\"disable_notifications\";i:0;s:12:\"restart_tour\";s:0:\"\";s:13:\"cookie_expiry\";i:365;s:25:\"enable_cookieblocker_ajax\";i:0;s:19:\"set_cookies_on_root\";i:0;s:13:\"cookie_domain\";s:0:\"\";s:18:\"websitescan_status\";s:0:\"\";s:19:\"websitescan_actions\";s:0:\"\";s:13:\"use_cdb_links\";s:3:\"yes\";s:28:\"disable_automatic_cookiescan\";i:0;}", "auto");
INSERT INTO `cupoptions` VALUES("2451", "_wp_suggested_policy_text_has_changed", "not-changed", "off");
INSERT INTO `cupoptions` VALUES("2457", "_transient_media_months", "a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"year\";s:4:\"2025\";s:5:\"month\";s:1:\"9\";}i:1;O:8:\"stdClass\":2:{s:4:\"year\";s:4:\"2025\";s:5:\"month\";s:1:\"8\";}i:2;O:8:\"stdClass\":2:{s:4:\"year\";s:4:\"2025\";s:5:\"month\";s:1:\"7\";}}", "on");
INSERT INTO `cupoptions` VALUES("2460", "cmplz_wsc_signup_status", "disabled", "off");
INSERT INTO `cupoptions` VALUES("2461", "cmplz_cookie_data_verified_date", "1757331243", "auto");
INSERT INTO `cupoptions` VALUES("2464", "cmplz_first_sync_started", "1", "off");
INSERT INTO `cupoptions` VALUES("2465", "cmplz_last_cookie_scan", "1757338431", "auto");
INSERT INTO `cupoptions` VALUES("2470", "cmplz_detected_social_media", "a:0:{}", "auto");
INSERT INTO `cupoptions` VALUES("2471", "cmplz_detected_thirdparty_services", "a:0:{}", "auto");
INSERT INTO `cupoptions` VALUES("2472", "cmplz_detected_stats", "a:0:{}", "auto");
INSERT INTO `cupoptions` VALUES("2473", "cmplz_purposes_stored", "1", "off");
INSERT INTO `cupoptions` VALUES("2474", "cmplz_purposes_en", "a:5:{i:0;a:2:{s:5:\"value\";s:2:\"61\";s:5:\"label\";s:10:\"Functional\";}i:1;a:2:{s:5:\"value\";s:2:\"64\";s:5:\"label\";s:9:\"Marketing\";}i:2;a:2:{s:5:\"value\";s:4:\"1257\";s:5:\"label\";s:11:\"Preferences\";}i:3;a:2:{s:5:\"value\";s:2:\"63\";s:5:\"label\";s:10:\"Statistics\";}i:4;a:2:{s:5:\"value\";s:2:\"62\";s:5:\"label\";s:22:\"Statistics (anonymous)\";}}", "off");
INSERT INTO `cupoptions` VALUES("2475", "cmplz_wsc_logs", "a:6:{i:0;a:3:{s:7:\"context\";s:18:\"wsc_scan_completed\";s:13:\"error_message\";s:31:\"COMPLIANZ: wsc scan not enabled\";s:9:\"timestamp\";s:19:\"2025-09-02 14:12:07\";}i:1;a:3:{s:7:\"context\";s:16:\"wsc_scan_process\";s:13:\"error_message\";s:34:\"COMPLIANZ: wsc scan is not enabled\";s:9:\"timestamp\";s:19:\"2025-09-02 14:12:07\";}i:2;a:3:{s:7:\"context\";s:18:\"wsc_scan_completed\";s:13:\"error_message\";s:31:\"COMPLIANZ: wsc scan not enabled\";s:9:\"timestamp\";s:19:\"2025-09-02 14:12:07\";}i:3;a:3:{s:7:\"context\";s:18:\"wsc_scan_completed\";s:13:\"error_message\";s:31:\"COMPLIANZ: wsc scan not enabled\";s:9:\"timestamp\";s:19:\"2025-09-08 13:33:49\";}i:4;a:3:{s:7:\"context\";s:16:\"wsc_scan_process\";s:13:\"error_message\";s:34:\"COMPLIANZ: wsc scan is not enabled\";s:9:\"timestamp\";s:19:\"2025-09-08 13:33:49\";}i:5;a:3:{s:7:\"context\";s:18:\"wsc_scan_completed\";s:13:\"error_message\";s:31:\"COMPLIANZ: wsc scan not enabled\";s:9:\"timestamp\";s:19:\"2025-09-08 13:33:49\";}}", "off");
INSERT INTO `cupoptions` VALUES("2476", "cmplz_serviceTypes_stored", "1", "off");
INSERT INTO `cupoptions` VALUES("2477", "cmplz_serviceTypes_en", "a:54:{i:0;a:2:{s:5:\"value\";s:4:\"6088\";s:5:\"label\";s:13:\"accessibility\";}i:1;a:2:{s:5:\"value\";s:3:\"422\";s:5:\"label\";s:11:\"advertising\";}i:2;a:2:{s:5:\"value\";s:3:\"402\";s:5:\"label\";s:19:\"affiliate marketing\";}i:3;a:2:{s:5:\"value\";s:3:\"429\";s:5:\"label\";s:15:\"audio streaming\";}i:4;a:2:{s:5:\"value\";s:3:\"418\";s:5:\"label\";s:16:\"buttons creation\";}i:5;a:2:{s:5:\"value\";s:3:\"396\";s:5:\"label\";s:13:\"call tracking\";}i:6;a:2:{s:5:\"value\";s:3:\"180\";s:5:\"label\";s:12:\"chat support\";}i:7;a:2:{s:5:\"value\";s:3:\"425\";s:5:\"label\";s:19:\"comments management\";}i:8;a:2:{s:5:\"value\";s:4:\"2443\";s:5:\"label\";s:13:\"Contact Forms\";}i:9;a:2:{s:5:\"value\";s:3:\"400\";s:5:\"label\";s:16:\"content creation\";}i:10;a:2:{s:5:\"value\";s:3:\"409\";s:5:\"label\";s:43:\"content distribution network (CDN) services\";}i:11;a:2:{s:5:\"value\";s:3:\"408\";s:5:\"label\";s:18:\"content management\";}i:12;a:2:{s:5:\"value\";s:2:\"67\";s:5:\"label\";s:25:\"cookie consent management\";}i:13;a:2:{s:5:\"value\";s:4:\"1336\";s:5:\"label\";s:22:\"creating online forums\";}i:14;a:2:{s:5:\"value\";s:3:\"412\";s:5:\"label\";s:14:\"creating polls\";}i:15;a:2:{s:5:\"value\";s:3:\"399\";s:5:\"label\";s:25:\"cross-channel advertising\";}i:16;a:2:{s:5:\"value\";s:3:\"413\";s:5:\"label\";s:28:\"customer identity management\";}i:17;a:2:{s:5:\"value\";s:4:\"1157\";s:5:\"label\";s:29:\"Customer Relations Management\";}i:18;a:2:{s:5:\"value\";s:3:\"405\";s:5:\"label\";s:27:\"customer support management\";}i:19;a:2:{s:5:\"value\";s:3:\"426\";s:5:\"label\";s:27:\"display of recent purchases\";}i:20;a:2:{s:5:\"value\";s:3:\"384\";s:5:\"label\";s:58:\"display of recent social posts and/or social share buttons\";}i:21;a:2:{s:5:\"value\";s:3:\"415\";s:5:\"label\";s:19:\"display of webfonts\";}i:22;a:2:{s:5:\"value\";s:3:\"410\";s:5:\"label\";s:31:\"heat maps and screen recordings\";}i:23;a:2:{s:5:\"value\";s:4:\"3410\";s:5:\"label\";s:38:\"learning management and course builder\";}i:24;a:2:{s:5:\"value\";s:3:\"401\";s:5:\"label\";s:17:\"locale management\";}i:25;a:2:{s:5:\"value\";s:3:\"387\";s:5:\"label\";s:26:\"mailing list subscriptions\";}i:26;a:2:{s:5:\"value\";s:3:\"385\";s:5:\"label\";s:12:\"maps display\";}i:27;a:2:{s:5:\"value\";s:3:\"395\";s:5:\"label\";s:48:\"marketing automation (automated email marketing)\";}i:28;a:2:{s:5:\"value\";s:4:\"1335\";s:5:\"label\";s:19:\"online appointments\";}i:29;a:2:{s:5:\"value\";s:3:\"407\";s:5:\"label\";s:12:\"page caching\";}i:30;a:2:{s:5:\"value\";s:3:\"163\";s:5:\"label\";s:30:\"page loading speed improvement\";}i:31;a:2:{s:5:\"value\";s:3:\"161\";s:5:\"label\";s:18:\"payment processing\";}i:32;a:2:{s:5:\"value\";s:3:\"419\";s:5:\"label\";s:14:\"popup creation\";}i:33;a:2:{s:5:\"value\";s:3:\"397\";s:5:\"label\";s:30:\"providing social share buttons\";}i:34;a:2:{s:5:\"value\";s:4:\"2016\";s:5:\"label\";s:18:\"push notifications\";}i:35;a:2:{s:5:\"value\";s:3:\"411\";s:5:\"label\";s:11:\"remarketing\";}i:36;a:2:{s:5:\"value\";s:3:\"423\";s:5:\"label\";s:26:\"Search Engine Optimization\";}i:37;a:2:{s:5:\"value\";s:3:\"404\";s:5:\"label\";s:16:\"search functions\";}i:38;a:2:{s:5:\"value\";s:3:\"416\";s:5:\"label\";s:29:\"security and fraud prevention\";}i:39;a:2:{s:5:\"value\";s:3:\"398\";s:5:\"label\";s:22:\"showing advertisements\";}i:40;a:2:{s:5:\"value\";s:3:\"386\";s:5:\"label\";s:15:\"spam prevention\";}i:41;a:2:{s:5:\"value\";s:3:\"388\";s:5:\"label\";s:27:\"Statistics and optimization\";}i:42;a:2:{s:5:\"value\";s:3:\"178\";s:5:\"label\";s:13:\"video display\";}i:43;a:2:{s:5:\"value\";s:3:\"406\";s:5:\"label\";s:16:\"visitor tracking\";}i:44;a:2:{s:5:\"value\";s:4:\"1131\";s:5:\"label\";s:16:\"weather forecast\";}i:45;a:2:{s:5:\"value\";s:3:\"427\";s:5:\"label\";s:8:\"webforms\";}i:46;a:2:{s:5:\"value\";s:3:\"420\";s:5:\"label\";s:18:\"webshop management\";}i:47;a:2:{s:5:\"value\";s:3:\"421\";s:5:\"label\";s:23:\"website admin functions\";}i:48;a:2:{s:5:\"value\";s:3:\"403\";s:5:\"label\";s:14:\"website design\";}i:49;a:2:{s:5:\"value\";s:3:\"424\";s:5:\"label\";s:19:\"website development\";}i:50;a:2:{s:5:\"value\";s:3:\"414\";s:5:\"label\";s:15:\"website hosting\";}i:51;a:2:{s:5:\"value\";s:3:\"417\";s:5:\"label\";s:13:\"website menus\";}i:52;a:2:{s:5:\"value\";s:3:\"164\";s:5:\"label\";s:32:\"website performance optimization\";}i:53;a:2:{s:5:\"value\";s:3:\"162\";s:5:\"label\";s:18:\"website statistics\";}}", "off");
INSERT INTO `cupoptions` VALUES("2478", "cmplz_wsc_status", "pending", "off");
INSERT INTO `cupoptions` VALUES("2479", "cmplz_wsc_signup_date", "1757331058", "off");
INSERT INTO `cupoptions` VALUES("2480", "cmplz_documents_update_date", "1757331184", "auto");
INSERT INTO `cupoptions` VALUES("2481", "cmplz_publish_date", "1757331184", "auto");
INSERT INTO `cupoptions` VALUES("2482", "complianz_active_policy_id", "35", "auto");
INSERT INTO `cupoptions` VALUES("2502", "cmplz_last_cookie_sync", "1757338447", "auto");
INSERT INTO `cupoptions` VALUES("2503", "cmplz_sync_cookies_complete", "1", "off");
INSERT INTO `cupoptions` VALUES("2504", "cmplz_purposes_fr", "a:5:{i:0;a:2:{s:5:\"value\";s:3:\"987\";s:5:\"label\";s:11:\"Fonctionnel\";}i:1;a:2:{s:5:\"value\";s:3:\"988\";s:5:\"label\";s:9:\"Marketing\";}i:2;a:2:{s:5:\"value\";s:4:\"1262\";s:5:\"label\";s:13:\"Préférences\";}i:3;a:2:{s:5:\"value\";s:3:\"989\";s:5:\"label\";s:12:\"Statistiques\";}i:4;a:2:{s:5:\"value\";s:3:\"990\";s:5:\"label\";s:23:\"Statistiques (anonymes)\";}}", "off");
INSERT INTO `cupoptions` VALUES("2505", "cmplz_serviceTypes_fr", "a:53:{i:0;a:2:{s:5:\"value\";s:4:\"3106\";s:5:\"label\";s:22:\"formulaires de contact\";}i:1;a:2:{s:5:\"value\";s:4:\"1712\";s:5:\"label\";s:27:\"gérer les relations client\";}i:2;a:2:{s:5:\"value\";s:4:\"5202\";s:5:\"label\";s:53:\"gestion de l’apprentissage et constructeur de cours\";}i:3;a:2:{s:5:\"value\";s:4:\"1012\";s:5:\"label\";s:23:\"l’affichage de cartes\";}i:4;a:2:{s:5:\"value\";s:4:\"1007\";s:5:\"label\";s:97:\"l’affichage de publications sociales récentes et/ou des boutons de partage de réseaux sociaux\";}i:5;a:2:{s:5:\"value\";s:4:\"1019\";s:5:\"label\";s:28:\"l’affichage de publicités\";}i:6;a:2:{s:5:\"value\";s:4:\"1026\";s:5:\"label\";s:24:\"l’affichage de vidéos\";}i:7;a:2:{s:5:\"value\";s:4:\"1006\";s:5:\"label\";s:33:\"l’affichage des achats récents\";}i:8;a:2:{s:5:\"value\";s:4:\"1008\";s:5:\"label\";s:29:\"l’affichage des polices web\";}i:9;a:2:{s:5:\"value\";s:3:\"996\";s:5:\"label\";s:42:\"l’assistance par discussion instantanée\";}i:10;a:2:{s:5:\"value\";s:4:\"1027\";s:5:\"label\";s:68:\"l’automatisation du marketing (marketing par courriel automatisé)\";}i:11;a:2:{s:5:\"value\";s:4:\"1109\";s:5:\"label\";s:28:\"l’hébergement du site web\";}i:12;a:2:{s:5:\"value\";s:4:\"1111\";s:5:\"label\";s:46:\"l’optimisation de la performance du site web\";}i:13;a:2:{s:5:\"value\";s:4:\"1105\";s:5:\"label\";s:62:\"l’optimisation et les statistiques pour la boutique en ligne\";}i:14;a:2:{s:5:\"value\";s:4:\"1024\";s:5:\"label\";s:58:\"l&#039;amélioration de la vitesse de chargement des pages\";}i:15;a:2:{s:5:\"value\";s:3:\"994\";s:5:\"label\";s:23:\"la création de boutons\";}i:16;a:2:{s:5:\"value\";s:3:\"998\";s:5:\"label\";s:23:\"la création de contenu\";}i:17;a:2:{s:5:\"value\";s:4:\"1014\";s:5:\"label\";s:45:\"la création de fenêtre contextuelle (popup)\";}i:18;a:2:{s:5:\"value\";s:4:\"1713\";s:5:\"label\";s:31:\"la création de forums en ligne\";}i:19;a:2:{s:5:\"value\";s:4:\"1002\";s:5:\"label\";s:24:\"la création de sondages\";}i:20;a:2:{s:5:\"value\";s:4:\"1104\";s:5:\"label\";s:31:\"la gestion de boutique en ligne\";}i:21;a:2:{s:5:\"value\";s:4:\"1000\";s:5:\"label\";s:21:\"la gestion de contenu\";}i:22;a:2:{s:5:\"value\";s:4:\"1005\";s:5:\"label\";s:40:\"la gestion de l’assistance aux clients\";}i:23;a:2:{s:5:\"value\";s:4:\"1004\";s:5:\"label\";s:39:\"la gestion de l’identité des clients\";}i:24;a:2:{s:5:\"value\";s:3:\"997\";s:5:\"label\";s:27:\"la gestion des commentaires\";}i:25;a:2:{s:5:\"value\";s:4:\"1010\";s:5:\"label\";s:37:\"la gestion des paramètres régionaux\";}i:26;a:2:{s:5:\"value\";s:4:\"1001\";s:5:\"label\";s:38:\"la gestion du consentement aux cookies\";}i:27;a:2:{s:5:\"value\";s:4:\"1015\";s:5:\"label\";s:64:\"la mise à disposition de boutons de partage de réseaux sociaux\";}i:28;a:2:{s:5:\"value\";s:4:\"1023\";s:5:\"label\";s:26:\"la mise en cache des pages\";}i:29;a:2:{s:5:\"value\";s:3:\"991\";s:5:\"label\";s:13:\"la publicité\";}i:30;a:2:{s:5:\"value\";s:4:\"1003\";s:5:\"label\";s:25:\"la publicité cross-canal\";}i:31;a:2:{s:5:\"value\";s:4:\"1100\";s:5:\"label\";s:25:\"la sécurité du site web\";}i:32;a:2:{s:5:\"value\";s:4:\"1013\";s:5:\"label\";s:28:\"le blocage des indésirables\";}i:33;a:2:{s:5:\"value\";s:4:\"1107\";s:5:\"label\";s:21:\"le design du site web\";}i:34;a:2:{s:5:\"value\";s:4:\"1108\";s:5:\"label\";s:29:\"le développement du site web\";}i:35;a:2:{s:5:\"value\";s:3:\"992\";s:5:\"label\";s:31:\"le marketing d&#039;affiliation\";}i:36;a:2:{s:5:\"value\";s:4:\"1016\";s:5:\"label\";s:14:\"le remarketing\";}i:37;a:2:{s:5:\"value\";s:3:\"999\";s:5:\"label\";s:51:\"le service de réseau de diffusion de contenu (CDN)\";}i:38;a:2:{s:5:\"value\";s:3:\"993\";s:5:\"label\";s:18:\"le streaming audio\";}i:39;a:2:{s:5:\"value\";s:3:\"995\";s:5:\"label\";s:19:\"le suivi des appels\";}i:40;a:2:{s:5:\"value\";s:4:\"1102\";s:5:\"label\";s:22:\"le suivi des visiteurs\";}i:41;a:2:{s:5:\"value\";s:4:\"1025\";s:5:\"label\";s:25:\"le traitement de paiement\";}i:42;a:2:{s:5:\"value\";s:4:\"1011\";s:5:\"label\";s:39:\"les abonnements aux listes de diffusion\";}i:43;a:2:{s:5:\"value\";s:4:\"1009\";s:5:\"label\";s:70:\"les cartes de fréquentation (heat maps) et enregistrements d’écran\";}i:44;a:2:{s:5:\"value\";s:4:\"1106\";s:5:\"label\";s:47:\"les fonctions d&#039;administration du site web\";}i:45;a:2:{s:5:\"value\";s:4:\"1018\";s:5:\"label\";s:26:\"les fonctions de recherche\";}i:46;a:2:{s:5:\"value\";s:4:\"1103\";s:5:\"label\";s:19:\"les formulaires web\";}i:47;a:2:{s:5:\"value\";s:4:\"1110\";s:5:\"label\";s:21:\"les menus du site web\";}i:48;a:2:{s:5:\"value\";s:4:\"1716\";s:5:\"label\";s:23:\"les prévisions météo\";}i:49;a:2:{s:5:\"value\";s:4:\"1715\";s:5:\"label\";s:24:\"les rendez-vous en ligne\";}i:50;a:2:{s:5:\"value\";s:4:\"1101\";s:5:\"label\";s:28:\"les statistiques du site web\";}i:51;a:2:{s:5:\"value\";s:4:\"3107\";s:5:\"label\";s:27:\"notifications instantanées\";}i:52;a:2:{s:5:\"value\";s:4:\"1017\";s:5:\"label\";s:32:\"optimiser le moteur de recherche\";}}", "off");
INSERT INTO `cupoptions` VALUES("2508", "cmplz_sync_services_complete", "1", "off");
INSERT INTO `cupoptions` VALUES("2511", "cmplz_sync_cookies_after_services_complete", "1", "off");
INSERT INTO `cupoptions` VALUES("2514", "cmplz_wizard_completed_once", "1", "auto");
INSERT INTO `cupoptions` VALUES("2542", "cmplz_excluded_posts_array", "a:0:{}", "auto");
INSERT INTO `cupoptions` VALUES("2553", "cmplz_wsc_consent_consentdata", "{\"timestamp\":\"2025-09-08T11:30:55+00:00\",\"subject\":{\"id\":\"cmplz-aHR0cHM6Ly91cC50aGVyYS5mcg==#dmlsbGFnZUBjYS1jZW50cmVzdC5mcg==\",\"email\":\"village@ca-centrest.fr\"},\"preferences\":{\"wsc_consent\":true},\"legal_notices\":[{\"identifier\":\"terms\"}],\"proofs\":[{\"content\":\"{\\\"email\\\":\\\"village@ca-centrest.fr\\\",\\\"timestamp\\\":1757331055.1,\\\"url\\\":\\\"https:\\\\\\/\\\\\\/up.thera.fr\\\\\\/wp-admin\\\\\\/admin.php?page=complianz&websitescan#settings\\\"}\",\"form\":\"complianz-onboarding__wsc_consent\"}]}", "off");
INSERT INTO `cupoptions` VALUES("2556", "cmplz_newsletter_consent_consentdata", "{\"timestamp\":\"2025-09-08T11:31:07+00:00\",\"subject\":{\"id\":\"cmplz-aHR0cHM6Ly91cC50aGVyYS5mcg==#dmlsbGFnZUBjYS1jZW50cmVzdC5mcg==\",\"email\":\"village@ca-centrest.fr\"},\"preferences\":{\"newsletter_consent\":true},\"legal_notices\":[{\"identifier\":\"newsletter\"}],\"proofs\":[{\"content\":\"{\\\"email\\\":\\\"village@ca-centrest.fr\\\",\\\"timestamp\\\":1757331067.276,\\\"url\\\":\\\"https:\\\\\\/\\\\\\/up.thera.fr\\\\\\/wp-admin\\\\\\/admin.php?page=complianz&websitescan#settings\\\"}\",\"form\":\"complianz-onboarding__newsletter_consent\"}]}", "off");
INSERT INTO `cupoptions` VALUES("2565", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"25.9\";}", "auto");
INSERT INTO `cupoptions` VALUES("2566", "wpseo", "a:115:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:26:\"permalink_settings_changed\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"25.9\";s:16:\"previous_version\";s:4:\"25.8\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:1;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1756816705;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:36:\"/%year%/%monthnum%/%day%/%postname%/\";s:8:\"home_url\";s:19:\"https://up.thera.fr\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:0:{}s:29:\"enable_enhanced_slack_sharing\";b:1;s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:4:{i:0;s:15:\"optimizeSeoData\";i:1;s:18:\"siteRepresentation\";i:2;s:14:\"socialProfiles\";i:3;s:19:\"personalPreferences\";}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:0;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1756816705;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:28:\"last_known_public_taxonomies\";a:3:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";}s:23:\"last_known_no_unindexed\";a:4:{s:40:\"wpseo_total_unindexed_post_type_archives\";i:1757344615;s:31:\"wpseo_unindexed_post_link_count\";i:1757344615;s:31:\"wpseo_unindexed_term_link_count\";i:1757344615;s:35:\"wpseo_total_unindexed_general_items\";i:1757344615;}s:14:\"new_post_types\";a:0:{}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:0;s:44:\"site_kit_configuration_permanently_dismissed\";b:0;s:18:\"site_kit_connected\";b:0;s:37:\"site_kit_tracking_setup_widget_loaded\";s:2:\"no\";s:41:\"site_kit_tracking_first_interaction_stage\";s:0:\"\";s:40:\"site_kit_tracking_last_interaction_stage\";s:0:\"\";s:52:\"site_kit_tracking_setup_widget_temporarily_dismissed\";s:2:\"no\";s:52:\"site_kit_tracking_setup_widget_permanently_dismissed\";s:2:\"no\";s:31:\"google_site_kit_feature_enabled\";b:0;s:25:\"ai_free_sparks_started_on\";N;s:15:\"enable_llms_txt\";b:0;}", "auto");
INSERT INTO `cupoptions` VALUES("2567", "wpseo_titles", "a:129:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:50:\"%%name%%, auteur/autrice sur %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:65:\"Vous avez cherché %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:38:\"Page non trouvée %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:64:\"L’article %%POSTLINK%% est apparu en premier sur %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:30:\"Erreur 404 : Page introuvable\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:13:\"Archives pour\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:7:\"Accueil\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:18:\"Vous avez cherché\";s:15:\"breadcrumbs-sep\";s:2:\"»\";s:12:\"website_name\";s:8:\"Check-up\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:80:\"https://up.thera.fr/wp-content/uploads/2025/09/LCU-logo_baseline-RVB-POSITIF.jpg\";s:12:\"company_name\";s:8:\"Check-up\";s:22:\"company_alternate_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";i:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:24:\"publishing_principles_id\";i:0;s:25:\"ownership_funding_info_id\";i:0;s:29:\"actionable_feedback_policy_id\";i:0;s:21:\"corrections_policy_id\";i:0;s:16:\"ethics_policy_id\";i:0;s:19:\"diversity_policy_id\";i:0;s:28:\"diversity_staffing_report_id\";i:0;s:15:\"org-description\";s:0:\"\";s:9:\"org-email\";s:0:\"\";s:9:\"org-phone\";s:0:\"\";s:14:\"org-legal-name\";s:0:\"\";s:17:\"org-founding-date\";s:0:\"\";s:20:\"org-number-employees\";s:0:\"\";s:10:\"org-vat-id\";s:0:\"\";s:10:\"org-tax-id\";s:0:\"\";s:7:\"org-iso\";s:0:\"\";s:8:\"org-duns\";s:0:\"\";s:11:\"org-leicode\";s:0:\"\";s:9:\"org-naics\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:18:\"title-tax-category\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:27:\"Archives des %%term_title%%\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:26:\"taxonomy-category-ptparent\";i:0;s:18:\"title-tax-post_tag\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:27:\"Archives des %%term_title%%\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:26:\"taxonomy-post_tag-ptparent\";i:0;s:21:\"title-tax-post_format\";s:57:\"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:27:\"Archives des %%term_title%%\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:29:\"taxonomy-post_format-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:1102;s:17:\"company_logo_meta\";a:10:{s:5:\"width\";i:414;s:6:\"height\";i:182;s:8:\"filesize\";i:48244;s:3:\"url\";s:80:\"https://up.thera.fr/wp-content/uploads/2025/09/LCU-logo_baseline-RVB-POSITIF.jpg\";s:4:\"path\";s:80:\"/home/xvgnwgb/check/wp-content/uploads/2025/09/LCU-logo_baseline-RVB-POSITIF.jpg\";s:4:\"size\";s:4:\"full\";s:2:\"id\";i:1102;s:3:\"alt\";s:0:\"\";s:6:\"pixels\";i:75348;s:4:\"type\";s:10:\"image/jpeg\";}s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "auto");
INSERT INTO `cupoptions` VALUES("2568", "wpseo_social", "a:20:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:17:\"other_social_urls\";a:0:{}s:12:\"mastodon_url\";s:0:\"\";}", "auto");
INSERT INTO `cupoptions` VALUES("2569", "wpseo_llmstxt", "a:7:{s:23:\"llms_txt_selection_mode\";s:4:\"auto\";s:13:\"about_us_page\";i:0;s:12:\"contact_page\";i:0;s:10:\"terms_page\";i:0;s:19:\"privacy_policy_page\";i:0;s:9:\"shop_page\";i:0;s:20:\"other_included_pages\";a:0:{}}", "auto");
INSERT INTO `cupoptions` VALUES("2716", "_site_transient_timeout_php_check_f97435f29f75964c6616760b2555a445", "1757487880", "off");
INSERT INTO `cupoptions` VALUES("2717", "_site_transient_php_check_f97435f29f75964c6616760b2555a445", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `cupoptions` VALUES("2762", "_site_transient_timeout_browser_fda9ade7eec3915ebecaaa6df8712f08", "1757498665", "off");
INSERT INTO `cupoptions` VALUES("2763", "_site_transient_browser_fda9ade7eec3915ebecaaa6df8712f08", "a:10:{s:4:\"name\";s:6:\"Safari\";s:7:\"version\";s:6:\"17.4.1\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.apple.com/safari/\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/safari.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/safari.png?1\";s:15:\"current_version\";s:2:\"11\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `cupoptions` VALUES("3488", "_transient_timeout_feed_mod_0d2db5fea5a8633b56992c916819b198", "1757455982", "off");
INSERT INTO `cupoptions` VALUES("3489", "_transient_feed_mod_0d2db5fea5a8633b56992c916819b198", "1757412782", "off");
INSERT INTO `cupoptions` VALUES("3722", "cmplz_wsc_onboarding_dismissed", "1", "off");
INSERT INTO `cupoptions` VALUES("3723", "cmplz_wsc_onboarding_start", "1757510741", "off");
INSERT INTO `cupoptions` VALUES("3724", "_transient_timeout_cmplz_pages_list", "1759923229", "off");
INSERT INTO `cupoptions` VALUES("3725", "_transient_cmplz_pages_list", "a:5:{i:0;s:4:\"home\";i:1;s:6:\"remote\";i:2;i:1111;i:3;i:880;i:4;i:858;}", "off");
INSERT INTO `cupoptions` VALUES("3726", "_transient_timeout_cmplz_processed_pages_list", "1759923231", "off");
INSERT INTO `cupoptions` VALUES("3727", "_transient_cmplz_processed_pages_list", "a:6:{i:0;s:4:\"home\";i:1;s:6:\"remote\";i:2;i:1111;i:3;i:880;i:4;s:4:\"1111\";i:5;i:858;}", "off");
INSERT INTO `cupoptions` VALUES("3756", "cmplz_consent_wsc_consent", "O:8:\"stdClass\":3:{s:2:\"id\";s:36:\"9f7f5e4a-93a5-4cb4-9b2a-199c6d72ffae\";s:10:\"subject_id\";s:67:\"cmplz-aHR0cHM6Ly91cC50aGVyYS5mcg==#dmlsbGFnZUBjYS1jZW50cmVzdC5mcg==\";s:9:\"timestamp\";s:25:\"2025-09-08T11:30:55+00:00\";}", "auto");
INSERT INTO `cupoptions` VALUES("3757", "cmplz_consent_newsletter_consent", "O:8:\"stdClass\":3:{s:2:\"id\";s:36:\"89d16a0a-9c2d-4fa1-8818-90602e602c63\";s:10:\"subject_id\";s:67:\"cmplz-aHR0cHM6Ly91cC50aGVyYS5mcg==#dmlsbGFnZUBjYS1jZW50cmVzdC5mcg==\";s:9:\"timestamp\";s:25:\"2025-09-08T11:31:07+00:00\";}", "auto");
INSERT INTO `cupoptions` VALUES("3876", "_transient_timeout_cmplz_dn_notifications_fr", "1757430926", "off");
INSERT INTO `cupoptions` VALUES("3877", "_transient_cmplz_dn_notifications_fr", "a:0:{}", "off");
INSERT INTO `cupoptions` VALUES("3878", "_transient_timeout_wpseo_total_unindexed_post_type_archives", "1757431015", "off");
INSERT INTO `cupoptions` VALUES("3879", "_transient_wpseo_total_unindexed_post_type_archives", "0", "off");
INSERT INTO `cupoptions` VALUES("3880", "_transient_timeout_wpseo_total_unindexed_general_items", "1757431015", "off");
INSERT INTO `cupoptions` VALUES("3881", "_transient_wpseo_total_unindexed_general_items", "0", "off");
INSERT INTO `cupoptions` VALUES("3882", "_transient_timeout_wpseo_unindexed_post_link_count", "1757431015", "off");
INSERT INTO `cupoptions` VALUES("3883", "_transient_wpseo_unindexed_post_link_count", "0", "off");
INSERT INTO `cupoptions` VALUES("3884", "_transient_timeout_wpseo_unindexed_term_link_count", "1757431015", "off");
INSERT INTO `cupoptions` VALUES("3885", "_transient_wpseo_unindexed_term_link_count", "0", "off");
INSERT INTO `cupoptions` VALUES("4002", "_transient_timeout_wpseo-statistics-totals", "1757499181", "off");
INSERT INTO `cupoptions` VALUES("4003", "_transient_wpseo-statistics-totals", "a:1:{i:1;a:2:{s:6:\"scores\";a:0:{}s:8:\"division\";b:0;}}", "off");
INSERT INTO `cupoptions` VALUES("4004", "_site_transient_timeout_community-events-b2c3ecb51b9e8991362da3d3fbb55ce6", "1757455982", "off");
INSERT INTO `cupoptions` VALUES("4005", "_site_transient_community-events-b2c3ecb51b9e8991362da3d3fbb55ce6", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"46.218.227.0\";}s:6:\"events\";a:1:{i:0;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:25:\"WordCamp Netherlands 2025\";s:3:\"url\";s:38:\"https://netherlands.wordcamp.org/2025/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2025-11-27 09:00:00\";s:8:\"end_date\";s:19:\"2025-11-28 00:00:00\";s:20:\"start_unix_timestamp\";i:1764230400;s:18:\"end_unix_timestamp\";i:1764284400;s:8:\"location\";a:4:{s:8:\"location\";s:11:\"Netherlands\";s:7:\"country\";s:2:\"NL\";s:8:\"latitude\";d:52.0990656;s:9:\"longitude\";d:4.2975317;}}}}", "off");
INSERT INTO `cupoptions` VALUES("4006", "_transient_timeout_feed_0d2db5fea5a8633b56992c916819b198", "1757455982", "off");
INSERT INTO `cupoptions` VALUES("4007", "_transient_feed_0d2db5fea5a8633b56992c916819b198", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Blog – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Jul 2025 09:26:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.9-alpha-60723\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Blog – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"Arrêt des mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"https://fr.wordpress.org/2025/07/11/arret-des-mises-a-jour-de-securite-pour-les-versions-4-1-a-4-6-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Jul 2025 09:26:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Securité\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3375\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:346:\"À compter de mi-juillet 2025, l&#8217;équipe de sécurité de WordPress ne fournira plus de mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress. Ces versions ont été initialement publiées il y a plus de neuf ans et plus de 99 % des installations WordPress utilisent une version plus récente. La probabilité que [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1368:\"\n<p>À compter de mi-juillet 2025, l&rsquo;équipe de sécurité de WordPress ne fournira plus de mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress.</p>\n\n\n\n<p>Ces versions ont été initialement publiées il y a plus de neuf ans et plus de 99 % des installations WordPress utilisent une version plus récente. La probabilité que cela affecte votre site est très faible.</p>\n\n\n\n<p>Pour vérifier que votre version de WordPress est à jour, connectez-vous au tableau de bord de votre site. Si votre version n&rsquo;est pas à jour, vous devriez voir un message proposant sa mise à jour. La version que vous utilisez est indiquée dans le widget « D&rsquo;un coup d&rsquo;œil » présent sur le tableau de bord.</p>\n\n\n\n<p>Pour rappel, <strong>la seule version de WordPress activement maintenue est la version majeure la plus récente</strong>. Les correctifs de sécurité ne sont portés vers les anciennes branches que par « courtoisie », les anciennes versions ne faisant pas l&rsquo;objet de corrections autres que de sécurité.</p>\n\n\n\n<p>Le blog « <bdo lang=\"en\" dir=\"ltr\">Make WordPress Security</bdo> » fournit plus de détails sur la <a href=\"https://make.wordpress.org/security/2025/06/18/security-updates-will-cease-for-wordpress-versions-4-1-through-4-6/\">procédure de fin de support de ces versions (en anglais)</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3375\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Rendez-vous à Bâle pour le WordCamp Europe 2025 !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://fr.wordpress.org/2025/04/28/rendez-vous-a-bale-pour-le-wordcamp-europe-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Apr 2025 08:39:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3362\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"Le WordCamp Europe 2025 se tiendra du 5 au 7 juin dans la magnifique ville de Bâle, en Suisse. Il réunira les passionné·e·s de WordPress et du logiciel libre, des développeuses et développeurs et des professionnels de notre écosystème provenant de tout le continent et même du monde entier ! Venez découvrir de nouvelles perspectives, engagez [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6355:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image.jpg\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1024x538.jpg\" alt=\"\" class=\"wp-image-3363\" srcset=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1024x538.jpg 1024w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-300x158.jpg 300w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-768x403.jpg 768w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1536x806.jpg 1536w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image.jpg 1800w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Le WordCamp Europe 2025 se tiendra du 5 au 7 juin dans la magnifique ville de Bâle, en Suisse. Il réunira les passionné·e·s de WordPress et du logiciel libre, des développeuses et développeurs et des professionnels de notre écosystème provenant de tout le continent et même du monde entier !</p>\n\n\n\n<p>Venez découvrir de nouvelles perspectives, engagez des conversations avec les membres de la communauté WordPress, les entreprises et acteurs économiques innovants de notre écosystème au cours de trois jours de conférences, de réseautage et de contribution à WordPress.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Les places sont limitées : réservez la vôtre dès aujourd&rsquo;hui !</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://europe.wordcamp.org/2025/tickets/\">Réservez votre place (en anglais)</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Conférences et tables rondes</h2>\n\n\n\n<p>Cet évènement qui se tiendra les 6 et 7 juin 2025 proposera une <a href=\"https://europe.wordcamp.org/2025/schedule/\">série de conférences (en anglais)</a> qui porteront notamment sur des états des lieux de la stratégie des entreprise de l&rsquo;écosystème WordPress, le développement des nouvelles fonctionnalités du CMS, la défense du logiciel libre, l&rsquo;accessibilité, et bien plus encore.</p>\n\n\n\n<p>Pour celles et ceux qui souhaitent perfectionner leurs compétences, les présentations aborderont en profondeur des sujets tels que le SEO pour WordPress, l&rsquo;optimisation des performances, ou encore la conception et la production de sites assistée par l&rsquo;IA.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Séance de questions-réponses avec la direction du projet WordPress</h2>\n\n\n\n<p>Vous pourrez retrouver Mary Hubbard, directrice exécutive du projet WordPress, et Matt Mullenweg, co-fondateur de WordPress le 7 juin pour discuter de WordPress et de sa communauté.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Découvrez Bâle</h2>\n\n\n\n<p>Bâle est la troisième plus grande ville de Suisse. Elle est <a href=\"https://europe.wordcamp.org/2025/location/\">remplie de monuments historiques et culturels à découvrir (en anglais)</a>. Vous pouvez vous déplacer à Bâle et en faire l&rsquo;expérience par vous-même grâce à votre «&nbsp;<bdo lang=\"en\" dir=\"ltr\">BaselCard</bdo>&nbsp;», qui vous permet de monter dans tous les transports en commun de la ville. L&rsquo;équipe d&rsquo;organisation du WordCamp vous recommande fortement d’en profiter pour vous promener le long du Rhin&nbsp;!</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f6cf.png\" alt=\"🛏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/accommodation/\"> Trouver des logements à Bâle (en anglais)<br></a><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f68c.png\" alt=\"🚌\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/getting-around-in-basel/\"> En savoir plus sur la « <bdo lang=\"en\" dir=\"ltr\">BaselCard</bdo> » (en anglais)</a><br><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f4c5.png\" alt=\"📅\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Organisez votre WordCamp Europe !</strong> Découvrez le <a href=\"https://europe.wordcamp.org/2025/schedule/\">programme complet (en anglais)</a> et organisez votre séjour à Bâle !<br><img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Assurez-vous de réserver votre <a href=\"https://europe.wordcamp.org/2025/tickets/\">ticket pour le WordCamp Europe 2025</a></strong> si vous ne l&rsquo;avez pas déjà fait !</p>\n\n\n\n<p>Suivez l&rsquo;actualité du WordCamp Europe sur <a href=\"https://bsky.app/profile/wordpress.org\">Bluesky</a>, <a href=\"https://instagram.com/wordpress/\">Instagram</a>, <a href=\"https://www.facebook.com/WordPress\">Facebook</a>, <a href=\"https://www.linkedin.com/company/wordpress/\">LinkedIn</a>, <a href=\"https://www.threads.net/@wordpress\">Threads</a>, <a href=\"https://mastodon.world/@wordpress\">Mastodon</a>  et <a href=\"https://twitter.com/WordPress\">X/Twitter</a> pour avoir des nouvelles en temps réel&nbsp;!</p>\n\n\n\n<p>N&rsquo;hésitez pas à relayer le message sur vos réseaux sociaux favoris : que vous soyez là le jour-J à Bâle ou que vous nous suiviez en ligne, partagez vos expériences avec les mots-dièse #WCEU et #WordPress sur tous les réseaux sociaux !</p>\n\n\n\n<p>Rendez-vous à Bâle pour le WordCamp Europe 2025&nbsp;! <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f1e8-1f1ed.png\" alt=\"🇨🇭\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3362\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 6.8 « Cecil »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://fr.wordpress.org/2025/04/15/wordpress-6-8-cecil/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Apr 2025 17:02:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3335\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:390:\"Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde de la musique. WordPress 6.8 «&#160;Cecil&#160;» rend hommage au légendaire pianiste et pionnier du jazz Cecil Taylor. De formation classique mais résolument anticonformiste, Cecil Taylor a ré-imaginé le piano comme un instrument de percussion, superposant les sons, explorant la [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:80522:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil.png\"><img decoding=\"async\" width=\"1024\" height=\"535\" src=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1024x535.png\" alt=\"\" class=\"wp-image-3338\" srcset=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1024x535.png 1024w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-300x157.png 300w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-768x401.png 768w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1536x803.png 1536w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde de la musique. WordPress 6.8 «&nbsp;Cecil&nbsp;» rend hommage au légendaire pianiste et pionnier du jazz Cecil Taylor.</p>\n\n\n\n<p>De formation classique mais résolument anticonformiste, Cecil Taylor a ré-imaginé le piano comme un instrument de percussion, superposant les sons, explorant la polyphonie et associant différents rythmes pour créer un son à la fois chaotique et précis. Sa musique a été révolutionnaire, formant de l&rsquo;ordre dans le désordre et de l&rsquo;harmonie dans la dissonance.</p>\n\n\n\n<p>Cet esprit anime WordPress 6.8. Adoptez ses nouvelles fonctionnalités audacieuses avec la même curiosité et la même expérimentation qui ont défini la création musicale de Cecil.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.8&nbsp;!</h2>\n\n\n\n<p>WordPress 6.8 peaufine et optimise les outils que vous utilisez au quotidien, ce qui rend votre site plus rapide, plus sécurisé et plus facile à gérer. Le guide de styles propose désormais une mise en page structurée et fonctionne avec les thèmes classiques, vous offrant ainsi un meilleur contrôle sur les styles globaux. Le chargement spéculatif accélère la navigation en préchargeant les liens avant même que les internautes n&rsquo;y accèdent, tandis que le hachage <code>bcrypt</code> renforce automatiquement la sécurité des mots de passe. En coulisses, les optimisations de la base de données améliorent les performances, et un nouveau système d&rsquo;alerte de sécurité permet de prévenir les vulnérabilités avant qu&rsquo;elles ne deviennent problématiques.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\">Télécharger WordPress 6.8 «&nbsp;Cecil&nbsp;» en français (ZIP – 20 Mo)</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Une version peaufinée à la perfection</h2>\n\n\n\n<p>WordPress 6.8 améliore et affine les outils que vous utilisez tous les jours, rendant votre site plus rapide, plus sûr et plus facile à gérer.</p>\n\n\n\n<p>Le guide de styles a maintenant une mise en page structurée et fonctionne désormais avec les thèmes classiques, ce qui vous apporte plus de contrôle sur les styles globaux de votre site.</p>\n\n\n\n<p>Le chargement spéculatif accélère la navigation en préchargeant les liens avant que les internautes ne naviguent vers ceux-ci, tandis que le hachage via bcrypt renforce automatiquement la sécurité des mots de passe.</p>\n\n\n\n<p>Parallèlement, des optimisations de la base de données améliorent les performances, et un nouveau système d’avertissement de sécurité aide à prévenir les vulnérabilités avant qu’elles ne deviennent un problème.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Le guide de style fait peau neuve et s’enrichit de quelques nouvelles fonctionnalités</h3>\n\n\n\n<p>Le guide de styles présente une nouvelle mise en page structurée et des libellés plus clairs, pour faciliter encore plus la modification des couleurs, de la typographie et de presque tous les styles de votre site, en un seul endroit.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-01.png\"><img decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-01-300x300.png\" alt=\"\" class=\"wp-image-3339\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-01-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-01-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-01-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-01.png 900w\" sizes=\"(max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Amélioration de l’éditeur</h3>\n\n\n\n<p>Visualisez plus facilement vos options dans les vues de données et excluez les publications épinglées de la boucle de requête. De plus, l’éditeur propose de nombreuses améliorations qui simplifient la création de contenu.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-02.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-02-300x300.png\" alt=\"\" class=\"wp-image-3340\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-02-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-02-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-02-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-02.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Chargement quasi instantané des pages, grâce au chargement spéculatif</h3>\n\n\n\n<p>Dans WordPress 6.8, les pages se chargent plus rapidement que jamais. Lorsque vous ou tout internaute survolez ou cliquez sur un lien, WordPress peut précharger la page suivante pour une expérience plus fluide et quasi instantanée. Le système équilibre vitesse et efficacité, et vous pouvez contrôler son fonctionnement avec une extension ou votre propre code. Cette fonctionnalité fonctionne uniquement dans les navigateurs modernes&nbsp;; les anciens l’ignoreront simplement sans aucun impact.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-03.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-03-300x300.png\" alt=\"\" class=\"wp-image-3341\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-03-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-03-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-03-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-03.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Sécurité renforcée des mots de passe avec bcrypt</h3>\n\n\n\n<p>Les mots de passe sont désormais plus difficiles à déchiffrer grâce au hachage bcrypt, qui nécessite beaucoup plus de puissance de calcul pour être cassé. Cela renforce la sécurité globale, tout comme d‘autres améliorations de chiffrement dans WordPress. Vous n’avez rien à faire&nbsp;: tout se met à jour automatiquement.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-04.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-04-300x300.png\" alt=\"\" class=\"wp-image-3342\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-04-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-04-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-04-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-04.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 100 correctifs et améliorations en matière d’accessibilité touchent un large champ de l’expérience WordPress. Cette version inclut des correctifs pour chaque thème natif, des améliorations de la gestion des menus de navigation, de l’outil de personnalisation, et un étiquetage simplifié. L’éditeur de blocs bénéficie de plus de 70 améliorations concernant les blocs, les vues de données, et l’expérience globale des utilisateurs et utilisatrices.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Allégement de la base de données</h3>\n\n\n\n<p>Le travail se poursuit sur l‘optimisation de la génération des clés de cache dans la classe&nbsp;<code>WP_Query</code>. L‘objectif est, comme toujours, d‘améliorer les performances de votre site, dans ce cas en réduisant davantage la charge de votre base de données. Cela est particulièrement utile si vous avez beaucoup de trafic.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress&nbsp;6.8 propose de nombreuses corrections et améliorations de performances pour accélérer l’ensemble de votre site, de l’administration aux temps de chargement ressentis par les personnes qui visitent votre site. Au-delà du chargement spéculatif désormais intégré nativement, WordPress&nbsp;6.8 accorde une attention particulière à l’éditeur de blocs, à l’enregistrement des types de blocs et à la mise en cache des requêtes. N’attendez jamais plus de 50&nbsp;millisecondes entre chaque interaction. Dans WordPress&nbsp;6.8, l’API de gestion de l’interactivité constitue un premier pas vers cet objectif.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.8</h2>\n\n\n\n<p>Pour une vision complète de toutes les nouvelles fonctionnalités et améliorations de WordPress 6.8, vous pouvez <a href=\"https://wordpress.org/download/releases/6-8/\">consulter le site de démonstration des fonctionnalités (en anglais)</a>.</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em><bdo lang=\"en\" dir=\"ltr\">Learn WordPress</bdo></em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Learn</bdo></em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;évènements interactifs&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Notes de version de WordPress 6.8</h4>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-8/\">Lisez les notes de version de WordPress 6.8</a> pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Guide technique de WordPress 6.8 en français</h4>\n\n\n\n<p><a href=\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\">Explorez le guide des changements techniques de WordPress 6.8</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous permettent de construire votre site avec WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.8</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale :&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version :&nbsp;<a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a></li>\n\n\n\n<li>Direction technique :&nbsp;<a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>,&nbsp;<a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, and&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a></li>\n\n\n\n<li>Gestion de projet :&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Direction artistique :&nbsp;<a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a></li>\n\n\n\n<li>Responsable des performances :&nbsp;<a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a></li>\n\n\n\n<li>Direction des tests :&nbsp;<a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.8 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>900 personnes provenant de près de 70 pays différents</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 250 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.8 <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<div class=\"wp-block-group alignwide is-style-default is-content-justification-left is-nowrap is-layout-flex wp-container-core-group-is-layout-fc9f69e7 wp-block-group-is-layout-flex\">\n<p class=\"has-dark-blueberry-color has-lemon-3-background-color has-text-color has-background has-link-color has-extra-small-font-size wp-elements-70a077000b3aff2481eb0decd1e70b5e\"><a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/thehercules/\">Aashish Sharma</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/hiabhaykulkarni/\">Abhay Kulkarni</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/adakaleh/\">AdaKaleh</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adhun/\">Adhun Anand</a> · <a href=\"https://profiles.wordpress.org/adityab98/\">Aditya Bansode</a> · <a href=\"https://profiles.wordpress.org/stromhalm/\">Adrian Jagusch</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/hemant-ahir/\">Ahir Hemant</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ahsankhan316/\">Ahsan Khan</a> · <a href=\"https://profiles.wordpress.org/aishwarryapande/\">Aishwarrya Pande</a> · <a href=\"https://profiles.wordpress.org/ajayghaghretiya1/\">Ajay Ghaghretiya</a> · <a href=\"https://profiles.wordpress.org/ajmaurya/\">Ajay Maurya</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akanshusingh/\">Akanshu Singh</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/aks30498/\">aks30498</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/akshaydhere/\">Akshay Dhere</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexflorisca/\">Alex Florisca</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/albigdd/\">Alexander Bigga</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexus450/\">Alexei Samarschi</a> · <a href=\"https://profiles.wordpress.org/alexschmitz/\">alexschmitz</a> · <a href=\"https://profiles.wordpress.org/alireyad/\">Ali Akbar Reyad</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/alpipego/\">alpipego</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/akrocks/\">Amaan Khan</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/amimulihsanmahdi/\">Amimul Ihsan</a> · <a href=\"https://profiles.wordpress.org/amin7/\">Amin</a> · <a href=\"https://profiles.wordpress.org/amitbhosale/\">Amit Bhosale</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/ammarmassoud/\">Ammar Mohamed Fath Allah Abd-Elaaty Massoud</a> · <a href=\"https://profiles.wordpress.org/amolebonde/\">amolebonde</a> · <a href=\"https://profiles.wordpress.org/anandraj346/\">Anand Raj</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/bowedk/\">Andreas Pedersen</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewssanya/\">Andrew Ssanya</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/rilwis/\">Anh Tran</a> · <a href=\"https://profiles.wordpress.org/wpgurudev/\">Ankit Gade</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/ankitpatel1578/\">Ankit Patel</a> · <a href=\"https://profiles.wordpress.org/anmolverma404/\">Anmol Verma</a> · <a href=\"https://profiles.wordpress.org/annchichi/\">annchichi</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">annezazu</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/anujrathore24/\">Anuj Singh</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/arielmaidana/\">Ariel Maidana</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/arnoutblueshell/\">arnoutblueshell</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/auareyou/\">Au</a> · <a href=\"https://profiles.wordpress.org/autotutorial/\">autotutorial</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">BackuPs</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/bsutcliffe/\">Ben Sutcliffe</a> · <a href=\"https://profiles.wordpress.org/benazeer/\">Benazeer</a> · <a href=\"https://profiles.wordpress.org/benniledl/\">Benedikt Ledl</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berislavgrgicak/\">Bero</a> · <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a> · <a href=\"https://profiles.wordpress.org/albatross10/\">Bhavik Kalpesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">Bijit Deb</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/rainynewt/\">Bishal Shrestha</a> · <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a> · <a href=\"https://profiles.wordpress.org/bluantinoo/\">bluantinoo</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradleyt/\">Bradley Taylor</a> · <a href=\"https://profiles.wordpress.org/bhubbard/\">Brandon Hubbard</a> · <a href=\"https://profiles.wordpress.org/bpayton/\">Brandon Payton</a> · <a href=\"https://profiles.wordpress.org/brettsmason/\">brettsmason</a> · <a href=\"https://profiles.wordpress.org/brevilo/\">brevilo</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/bronsonquick/\">Bronson Quick</a> · <a href=\"https://profiles.wordpress.org/bschneidewind/\">Bryan Schneidewind</a> · <a href=\"https://profiles.wordpress.org/burakkaptan/\">burak</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/calvinalkan/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cgastrell/\">cgastrell</a> · <a href=\"https://profiles.wordpress.org/charleslf/\">charleslf</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chintanmachhi207/\">chintanmachhi207</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/claimableperch/\">claimableperch</a> · <a href=\"https://profiles.wordpress.org/claudiulodro/\">Claudiu Lodromanean</a> · <a href=\"https://profiles.wordpress.org/codebymikey/\">codebymikey</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/colinleroy/\">colinleroy</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/cbusquets1989/\">Cris Busquets</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/ctienshi/\">ctienshi</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/css31/\">Cyrille Sanson</a> · <a href=\"https://profiles.wordpress.org/daedalon/\">Daedalon</a> · <a href=\"https://profiles.wordpress.org/acketon/\">Dakota Chichester</a> · <a href=\"https://profiles.wordpress.org/dalleyne/\">Damien Alleyne</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dpknauss/\">Dan Knauss</a> · <a href=\"https://profiles.wordpress.org/danht/\">danht</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danielpost/\">Daniel Post</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danielpataki/\">danielpataki</a> · <a href=\"https://profiles.wordpress.org/danielvann/\">danielvann</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/dhewercorus/\">Darren Hewer</a> · <a href=\"https://profiles.wordpress.org/davelo/\">Dave Loodts</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/darnado/\">David Arnado</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dafargier/\">David FARGIER</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/david-innes/\">David Innes</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/daymobrew/\">daymobrew</a> · <a href=\"https://profiles.wordpress.org/deadduck169/\">deadduck169</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deeppatel8950/\">Deep Patel</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/realloc/\">Dennis Ploetner</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/densinakum/\">Densi Nakum</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhavalkapadane/\">Dhaval Kapadane</a> · <a href=\"https://profiles.wordpress.org/dheeraj2995/\">Dheeraj Bhosale</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvik18/\">Dhruvik Malaviya</a> · <a href=\"https://profiles.wordpress.org/dilipom13/\">dilip</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/diliphingarajiya/\">Dilip Hingarajiya</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dingguodong/\">DingGuodong</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divyeshk71/\">Divyesh_kakrecha</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/mediaformat/\">Django</a> · <a href=\"https://profiles.wordpress.org/dnnsjsk/\">dnnsjsk</a> · <a href=\"https://profiles.wordpress.org/doekenorg/\">Doeke Norg</a> · <a href=\"https://profiles.wordpress.org/dogee/\">dogee</a> · <a href=\"https://profiles.wordpress.org/domenicdenicola/\">domenicdenicola</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donalirl/\">donalirl</a> · <a href=\"https://profiles.wordpress.org/dooperweb/\">dooperweb</a> · <a href=\"https://profiles.wordpress.org/dougwollison/\">Doug Wollison</a> · <a href=\"https://profiles.wordpress.org/dretzlaff/\">dretzlaff</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/dwainm/\">Dwain Maralack</a> · <a href=\"https://profiles.wordpress.org/earthman100/\">Earthman Media</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/eddystile/\">Eddy</a> · <a href=\"https://profiles.wordpress.org/cais/\">Edward Caissie</a> · <a href=\"https://profiles.wordpress.org/eceleste/\">efc</a> · <a href=\"https://profiles.wordpress.org/talksina/\">Elena Brescacin</a> · <a href=\"https://profiles.wordpress.org/elizaan36/\">elizaan36</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emlebrun/\">Emilie LEBRUN</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanuel Atsé</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/codekraft/\">Erik</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/etobiesen/\">Even Tobiesen</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/finntown/\">finntown</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/franciscabusas22/\">Francis Cabusas</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/frankbiganski/\">Frank B.</a> · <a href=\"https://profiles.wordpress.org/frank-klein/\">Frank Klein</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/frkly/\">frkly</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/fxbenard/\">fxbenard</a> · <a href=\"https://profiles.wordpress.org/gaellebesson/\">gaellebesson</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/galibh/\">Galib Hayder</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/ghinamt/\">ghinamt</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuriani/\">giuriani</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/glynnquelch/\">Glynn Quelch</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/grgarside/\">grgarside</a> · <a href=\"https://profiles.wordpress.org/guido07111975/\">Guido</a> · <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a> · <a href=\"https://profiles.wordpress.org/gulamdastgir04/\">Gulamdastgir Momin</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/gencmedya/\">Halil Kaya</a> · <a href=\"https://profiles.wordpress.org/yahaly/\">Halyna Yampolska</a> · <a href=\"https://profiles.wordpress.org/hameem1102/\">Hameem Mahdad Kader</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">Hannes Leismann</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harrym/\">harrym</a> · <a href=\"https://profiles.wordpress.org/harshalkadu/\">Harshal Kadu</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hekuranredev/\">hekuranredev</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/hdkothari81/\">Hemant Kothari</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a> · <a href=\"https://profiles.wordpress.org/rvouill/\">Herve THOMAS</a> · <a href=\"https://profiles.wordpress.org/hideishi/\">hideishi</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshhuptechweb/\">Hitesh Dhokai</a> · <a href=\"https://profiles.wordpress.org/hovhanneshovakimyan/\">Hovhannes Hovakimyan</a> · <a href=\"https://profiles.wordpress.org/hueitan/\">hueitan</a> · <a href=\"https://profiles.wordpress.org/humanify/\">humanify</a> · <a href=\"https://profiles.wordpress.org/hussain896/\">hussain896</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ilovecats7/\">ilovecats7</a> · <a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/indithemes/\">indithemes</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/isuke01/\">Isu</a> · <a href=\"https://profiles.wordpress.org/ivankristianto/\">Ivan Kristianto</a> · <a href=\"https://profiles.wordpress.org/moxie/\">Jack</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">Jagir Bahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jhmonroe/\">James Monroe</a> · <a href=\"https://profiles.wordpress.org/jopdop30/\">James Payne</a> · <a href=\"https://profiles.wordpress.org/imaginarymedia/\">James Robinson</a> · <a href=\"https://profiles.wordpress.org/q0rban/\">James Sansbury</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/jammycakes/\">jammycakes</a> · <a href=\"https://profiles.wordpress.org/lysyjan87/\">Jan Lysý</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/janusdev/\">janusdev</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/jasonsa19/\">Jason Sauerwald</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/shovan_jaya/\">Jayaram</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/jdnd/\">jdnd</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/maverick3x6/\">Jeff Golenski</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jepperask/\">jepperask</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeremy80/\">jeremy80</a> · <a href=\"https://profiles.wordpress.org/jeremyroman/\">jeremyroman</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jessedyck/\">jessedyck</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jnweaver/\">jnweaver</a> · <a href=\"https://profiles.wordpress.org/jartes/\">Joan Artes</a> · <a href=\"https://profiles.wordpress.org/jodamo5/\">jodamo5</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joecsmalley/\">joecsmalley</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/timse201/\">Johannes Jülg</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/arrcorona/\">Jomar Jay</a> · <a href=\"https://profiles.wordpress.org/jomonthomaslobo1/\">Jomon Thomas Lobo</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/jongycastillo/\">Jong</a> · <a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkilä</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnyauk/\">jonnyauk</a> · <a href=\"https://profiles.wordpress.org/joomskys/\">joomskys</a> · <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/blogitsolutions/\">Josef Seidl</a> · <a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a> · <a href=\"https://profiles.wordpress.org/joshuawold/\">Joshua Wold</a> · <a href=\"https://profiles.wordpress.org/jottevanger/\">jottevanger</a> · <a href=\"https://profiles.wordpress.org/jokanane/\">Jouni Kananen</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanbuis/\">juanbuis</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juanwp22/\">juanwp22</a> · <a href=\"https://profiles.wordpress.org/jules-colle/\">Jules Colle</a> · <a href=\"https://profiles.wordpress.org/julianmar/\">julianmar</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/juzar/\">Juzar</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kaitohm/\">Kaito Hanamori</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kapasias/\">KAP ASIAs</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/karlgroves/\">karlgroves</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/karthickmurugan/\">Karthick Murugan</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/karthikeya01/\">Karthikeya Bethu</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/kausaralm/\">Kausar Alam</a> · <a href=\"https://profiles.wordpress.org/keithdevon/\">keithdevon</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/tinypixel/\">Kelly Mears</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/ketanniruke/\">Ketan Niruke</a> · <a href=\"https://profiles.wordpress.org/patelketan/\">Ketan Patel</a> · <a href=\"https://profiles.wordpress.org/kevinlearynet/\">Kevinleary.net</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kjroelke/\">KJ Roelke</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kohheepeace/\">kohheepeace</a> · <a href=\"https://profiles.wordpress.org/kmgalanakis/\">Konstantinos Galanakis</a> · <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupaly2k/\">Krupal Lakhia</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/laxman-prajapati/\">Laxman Prajapati</a> · <a href=\"https://profiles.wordpress.org/lcarevic/\">lcarevic</a> · <a href=\"https://profiles.wordpress.org/leecollings/\">Lee</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leedxw/\">leedxw</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lenasterg/\">lenasterg</a> · <a href=\"https://profiles.wordpress.org/leszeks/\">leszeks</a> · <a href=\"https://profiles.wordpress.org/leup/\">leup</a> · <a href=\"https://profiles.wordpress.org/levskipg/\">levskipg</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/louislaugesen/\">Louis</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/lovewpmu/\">lovewpmu</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/dreadlox/\">Lox</a> · <a href=\"https://profiles.wordpress.org/ltrihan/\">ltrihan</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/gadelhas/\">Mário Santos</a> · <a href=\"https://profiles.wordpress.org/maciejmackowiak/\">maciejmackowiak</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/magdarogier/\">Magda Rogier</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mp518/\">Mahesh Prajapati</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/maikelraow/\">maikelraow</a> · <a href=\"https://profiles.wordpress.org/travel_girl/\">Maja Benke</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/tomdxw/\">mallorydxw-old</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manojmaharrshi/\">Manoj Maharrshi</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/marchalyoan/\">marchalyoan</a> · <a href=\"https://profiles.wordpress.org/afmarchetti/\">Marchetti Design</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/marian1/\">marian1</a> · <a href=\"https://profiles.wordpress.org/nuryko/\">Marianna</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/marineevain/\">Marine EVAIN</a> · <a href=\"https://profiles.wordpress.org/nofearinc/\">Mario Peshev</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/mapk/\">Mark Uraine</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/immasud/\">Masud Rana</a> · <a href=\"https://profiles.wordpress.org/paapst/\">Mathieu Paapst</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/iammattthomas/\">Matt (Thomas) Miklic</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattwest/\">Matt West</a> · <a href=\"https://profiles.wordpress.org/kinggmobb/\">Matthew</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/mattryanwalker/\">mattryanwalker</a> · <a href=\"https://profiles.wordpress.org/azouamauriac/\">Mauriac AZOUA</a> · <a href=\"https://profiles.wordpress.org/maximemeganck/\">Maxime Meganck</a> · <a href=\"https://profiles.wordpress.org/maximebj/\">maximebj</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/faithcoder/\">Md Abdullah Al Arif</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/itsmhrahman/\">Md Hafijur Rahman</a> · <a href=\"https://profiles.wordpress.org/kawsar007/\">MD Kawsar Chowdhury</a> · <a href=\"https://profiles.wordpress.org/mehdi01/\">Md Mahdi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdibrahimk48/\">Md. Ibrahim Khalil</a> · <a href=\"https://profiles.wordpress.org/najmulsaju/\">Md. Najmul Islam</a> · <a href=\"https://profiles.wordpress.org/mehedi_csit/\">Md.Mehedi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/leeseoftbc/\">MelissaH</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/mdawaffe/\">Michael Adams (mdawaffe)</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/websiteredev/\">Michael Willman</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a> · <a href=\"https://profiles.wordpress.org/micromadness/\">micromadness</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mmtr86/\">Miguel Torres</a> · <a href=\"https://profiles.wordpress.org/mijotj/\">Mijo T J</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/milindmore22/\">Milind More</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/369work/\">miroku</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/modi2918/\">Modi Sahil</a> · <a href=\"https://profiles.wordpress.org/antwortzeit/\">modulbuero</a> · <a href=\"https://profiles.wordpress.org/aboelfotoh/\">Mohamed Aboelfotoh Mohamed</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/mojorob/\">mojorob</a> · <a href=\"https://profiles.wordpress.org/jucaduca/\">Morais Junior</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor Ssebunya</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mr660/\">mr660</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtdkei/\">mt</a> · <a href=\"https://profiles.wordpress.org/muddassirnasim/\">Muddassir Rahman Nasim</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mukulsingh27/\">Mukul Singh</a> · <a href=\"https://profiles.wordpress.org/my1xt/\">My1</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">n8finch</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir</a> · <a href=\"https://profiles.wordpress.org/nandow/\">nandow</a> · <a href=\"https://profiles.wordpress.org/nanisamireddy/\">NANI SAMIREDDY</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nataliat2004/\">Natalia T</a> · <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a> · <a href=\"https://profiles.wordpress.org/navneet/\">navneet</a> · <a href=\"https://profiles.wordpress.org/navi161/\">Navneet Kaur</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/mcqueen22/\">NerQuiles</a> · <a href=\"https://profiles.wordpress.org/krstarica/\">net</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/nickgalvez/\">nickgalvez</a> · <a href=\"https://profiles.wordpress.org/undefinedfr/\">Nicolas RIVIERE</a> · <a href=\"https://profiles.wordpress.org/nicolasleroy/\">nicolasleroy</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/smushytaco/\">Nikan Radan</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nikunj8866/\">Nikunj Hatkar</a> · <a href=\"https://profiles.wordpress.org/snilesh/\">Nilesh Shiragave</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/mrtortai/\">Noam Eppel</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/oceantober/\">oceantober</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/jbkkd/\">Omer Korner</a> · <a href=\"https://profiles.wordpress.org/arzola/\">Oscar Arzola</a> · <a href=\"https://profiles.wordpress.org/groenroos/\">Oskari Groenroos</a> · <a href=\"https://profiles.wordpress.org/othernoel/\">othernoel</a> · <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pampfelimetten/\">pampfelimetten</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/dparthj/\">Parth Dodiya</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/casiepa/\">Pascal Casier</a> · <a href=\"https://profiles.wordpress.org/pateljaymin/\">Patel Jaymin</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/eartboard/\">Paul</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/bbpaule/\">Paul English</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paullb/\">paullb</a> · <a href=\"https://profiles.wordpress.org/psrpinto/\">Paulo Pinto</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/creadordev/\">Pawan Kumar</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/peter8nss/\">peter8nss</a> · <a href=\"https://profiles.wordpress.org/peterdavehello/\">peterdavehello</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/philliproth/\">philliproth</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pixlpirate/\">pixlpirate</a> · <a href=\"https://profiles.wordpress.org/podpirate/\">podpirate</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja Killekar (Muchandikar)</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a> · <a href=\"https://profiles.wordpress.org/prashant/\">prashant</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/contactprashantpp/\">Prashant Patil</a> · <a href=\"https://profiles.wordpress.org/prathamesh24/\">Prathamesh Shirke</a> · <a href=\"https://profiles.wordpress.org/prathameshbhagat1511/\">prathameshbhagat1511</a> · <a href=\"https://profiles.wordpress.org/pkbhatt/\">Pratik Bhatt</a> · <a href=\"https://profiles.wordpress.org/pratikgandhi/\">Pratik Gandhi</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/priyank9033/\">Priyank</a> · <a href=\"https://profiles.wordpress.org/pushpenderindia/\">Pushpender Singh</a> · <a href=\"https://profiles.wordpress.org/itsjonq/\">Q</a> · <a href=\"https://profiles.wordpress.org/qhaensler/\">qhaensler</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rahulsprajapati/\">Rahul Prajapati</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajat1192/\">Rajat Patel</a> · <a href=\"https://profiles.wordpress.org/raj198/\">Rajendra Patel</a> · <a href=\"https://profiles.wordpress.org/rajendrapatilraj/\">Rajendra Patil</a> · <a href=\"https://profiles.wordpress.org/rkradadiya/\">Rajesh Radadiya</a> · <a href=\"https://profiles.wordpress.org/rajeshrathodwp/\">Rajesh Rathod</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/redkite/\">redkite</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/rembem/\">Remco</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho</a> · <a href=\"https://profiles.wordpress.org/ooraiser69/\">Renz Jay Sanchez</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/riddhidave/\">Riddhi Dave</a> · <a href=\"https://profiles.wordpress.org/rinkalpagdar/\">Rinkal Pagdar</a> · <a href=\"https://profiles.wordpress.org/rishavdutta/\">Rishav Dutta</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rkyburz/\">rkyburz</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/harmr/\">Robert Seyfriedsberger</a> · <a href=\"https://profiles.wordpress.org/robertstaddon/\">robertstaddon</a> · <a href=\"https://profiles.wordpress.org/robinmartijn/\">Robin Martijn</a> · <a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/rogierlankhorst/\">Rogier Lankhorst</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/rohjay/\">rohjay</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/rotemg/\">Rotem Gelbart</a> · <a href=\"https://profiles.wordpress.org/lev0/\">Roy Orbitson</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roybellingan/\">roybellingan</a> · <a href=\"https://profiles.wordpress.org/rseigel/\">rseigel</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rudrakshigupta/\">Rudrakshi Gupta</a> · <a href=\"https://profiles.wordpress.org/rupesh5438/\">Rupesh Patil</a> · <a href=\"https://profiles.wordpress.org/rupw/\">rupw</a> · <a href=\"https://profiles.wordpress.org/ruturajraval2305/\">Ruturaj Raval</a> · <a href=\"https://profiles.wordpress.org/rvoigt/\">rvoigt</a> · <a href=\"https://profiles.wordpress.org/bookdude13/\">Ryan Fredlund</a> · <a href=\"https://profiles.wordpress.org/ryanhellyer/\">Ryan Hellyer</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/sabrineg/\">sabrineg</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/sagarlakhani/\">Sagar Lakhani</a> · <a href=\"https://profiles.wordpress.org/sagarprajapati/\">Sagar Prajapati</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sailpete/\">sailpete</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sallyruchman/\">sally</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/ranafge/\">Samsul Islam Rana</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/codexdemon/\">Sanyogg Shelar</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/saurabhdhariwal/\">saurabh.dhariwal</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/infosatech/\">Sayan Datta</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/sbathompson/\">sbathompson</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Scott Arciszewski</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/seanlanglands/\">seanlanglands</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sergiogutierrez/\">sergiogutierrez</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shadialaghbari/\">Shadi G شادي جـ</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/shanemuir/\">Shane Muirhead</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/shraddhagore/\">Shraddha Gore</a> · <a href=\"https://profiles.wordpress.org/shreyashd21/\">shreyashd21</a> · <a href=\"https://profiles.wordpress.org/shub07/\">Shubham Kumar Bansal</a> · <a href=\"https://profiles.wordpress.org/iamshubhamsp/\">Shubham Patil</a> · <a href=\"https://profiles.wordpress.org/shulard/\">shulard</a> · <a href=\"https://profiles.wordpress.org/shyamkariya/\">Shyam Kariya</a> · <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/sirlouen/\">SirLouen</a> · <a href=\"https://profiles.wordpress.org/sjefen6/\">sjefen6</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/mslavco/\">Slavco Mihajloski</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/soyebsalar/\">soyeb salar</a> · <a href=\"https://profiles.wordpress.org/spencerfinnell/\">Spencer Finnell</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/spmultidots/\">spmultidots</a> · <a href=\"https://profiles.wordpress.org/spncr/\">spncr</a> · <a href=\"https://profiles.wordpress.org/srikat/\">Sridhar Katakam</a> · <a href=\"https://profiles.wordpress.org/stefahn/\">Stefan Seidner-Britting</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a> · <a href=\"https://profiles.wordpress.org/stimul/\">stimul</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/stuartmcalpine/\">Stuart McAlpine</a> · <a href=\"https://profiles.wordpress.org/subodhrajpopat/\">Subodh Rajpopat</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sketchboy/\">SUHAS SUTAR</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/csesumonpro/\">Sumon Sarker</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/surajswalstar/\">Suraj Sutar</a> · <a href=\"https://profiles.wordpress.org/swalkinshaw/\">swalkinshaw</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/tschwarz-1/\">t.schwarz</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/gonom9/\">Taegon Kim</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/takayukister/\">Takayuki Miyoshi</a> · <a href=\"https://profiles.wordpress.org/takuword/\">takuword</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/th23/\">th23</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/thomaswm/\">thomaswm</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/tiagogoncalves/\">tiago</a> · <a href=\"https://profiles.wordpress.org/tigriweb/\">TigriWeb</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Krüss</a> · <a href=\"https://profiles.wordpress.org/tb1909/\">Tim Brathärig</a> · <a href=\"https://profiles.wordpress.org/dontfeedthecode/\">Tim Sheehan</a> · <a href=\"https://profiles.wordpress.org/timwhitlock/\">Tim W</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tkama/\">Timur Kamaev</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tjarrett/\">TJarrett</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias Bäthge</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tgsrvrs/\">Tom Gugel</a> · <a href=\"https://profiles.wordpress.org/tommusrhodus/\">Tom Rhodes</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/trushaamin/\">Trusha</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/tusharaddweb/\">Tushar Patel</a> · <a href=\"https://profiles.wordpress.org/tyb/\">Ty</a> · <a href=\"https://profiles.wordpress.org/tysonlmao/\">tysonlmao</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/unsalkorkmaz/\">Unsal Korkmaz</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utrenkner/\">utrenkner</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/vaibhavsweb/\">Vaibhav Singh Web</a> · <a href=\"https://profiles.wordpress.org/vaibhav2527/\">Vaibhav Tukaram Nawale</a> · <a href=\"https://profiles.wordpress.org/twvania/\">Vania</a> · <a href=\"https://profiles.wordpress.org/okvee/\">vee</a> · <a href=\"https://profiles.wordpress.org/vevas/\">Vegard S.</a> · <a href=\"https://profiles.wordpress.org/vgnavada/\">vgnavada</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/fylgjur/\">Victoria – a11n</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/virgildia/\">Virgildia</a> · <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a> · <a href=\"https://profiles.wordpress.org/virginienacci/\">virginienacci</a> · <a href=\"https://profiles.wordpress.org/vishy-moghan/\">Vishy Moghan</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/vykesmac/\">vykesmac</a> · <a href=\"https://profiles.wordpress.org/wadowad/\">wadowad</a> · <a href=\"https://profiles.wordpress.org/pctevree/\">Web-Pepper</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/west7/\">Wes Theron</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/worldweb/\">World Web Technology</a> · <a href=\"https://profiles.wordpress.org/wpgerd/\">wpgerd</a> · <a href=\"https://profiles.wordpress.org/wwdes/\">wwdes</a> · <a href=\"https://profiles.wordpress.org/xate/\">xate</a> · <a href=\"https://profiles.wordpress.org/xavilc/\">xavilc</a> · <a href=\"https://profiles.wordpress.org/xpurichan/\">xpurichan</a> · <a href=\"https://profiles.wordpress.org/yahil/\">Yahil Madakiya</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/yashrocz/\">Yash Kukreja</a> · <a href=\"https://profiles.wordpress.org/yellowafterlife/\">yellowafterlife</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/omaeyusuke/\">yuu</a> · <a href=\"https://profiles.wordpress.org/zaoyao/\">zaoyao</a> · <a href=\"https://profiles.wordpress.org/zargarov/\">Zargarov</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/haozi/\">耗子</a></p>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.8 en français</h3>\n\n\n\n<p>WordPress est un projet international et la version 6.8 est déjà complètement disponible dans plus de 40 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.8 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/fxbenard\">FX Benard</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>,&nbsp;<a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>,&nbsp;<a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>,&nbsp;<a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mumuu000\">mumuu000</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>,&nbsp;<a href=\"https://profiles.wordpress.org/rodrigoq\">rodrigoq</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>,&nbsp;<a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>,&nbsp;<a href=\"https://profiles.wordpress.org/translationsbyautomattic\">Translations by Automattic</a>, et&nbsp;<a href=\"https://profiles.wordpress.org/wptranslationsorg\">WP-Translations</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article rédigé par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\'https://profiles.wordpress.org/jdy68/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jdy68</a> et <a href=\'https://profiles.wordpress.org/nlegagneur/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nlegagneur</a> pour leur relecture.</p>\n\n\n\n<p><br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3335\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2025/03/28/guide-des-changements-techniques-de-wordpress-6-8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Mar 2025 07:53:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3310\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"Découvrez les changements techniques qui arrivent le 15 avril 2025 avec la version 6.8 de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:35090:\"\n<figure class=\"wp-block-image alignfull size-full\"><a href=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png\"><img loading=\"lazy\" decoding=\"async\" width=\"2156\" height=\"1084\" src=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png\" alt=\"\" class=\"wp-image-3312\" srcset=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png 2156w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-300x151.png 300w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-1024x515.png 1024w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-768x386.png 768w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-1536x772.png 1536w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-2048x1030.png 2048w\" sizes=\"auto, (max-width: 2156px) 100vw, 2156px\" /></a></figure>\n\n\n\n<div class=\"wp-block-group has-small-font-size is-content-justification-right is-nowrap is-layout-flex wp-container-core-group-is-layout-b315634e wp-block-group-is-layout-flex\">\n<p>Temps de lecture estimé&nbsp;:&nbsp;</p>\n\n\n<div class=\"wp-block-post-time-to-read\">7 minutes</div></div>\n\n\n\n<p>WordPress 6.8 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">300 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">104 améliorations et nouvelles fonctionnalités</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 170 corrections de bogues</a>. Cette version comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">23 tickets focalisés sur les performances</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">34 sur l’accessibilité</a>&nbsp;et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">16 sur la modernisation du code et la conformité aux standards de code</a>. Les modifications de la version 6.8 concernent&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">43 composants du cœur du CMS</a>.</p>\n\n\n\n<p>Cette version comprend aussi&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">387 améliorations</a>,&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">525 corrections de bogues</a>&nbsp;et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">70 améliorations d’accessibilité</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-charcoal-0-color has-text-color has-background has-link-color wp-elements-37003aee4fdc33a177f14a048ba187af\" style=\"background:linear-gradient(135deg,rgb(242,255,240) 0%,rgb(255,252,223) 50%,rgb(255,211,218) 100%)\">Ce guide décrit les principaux changements techniques qui arrivent sur WordPress&nbsp;6.8, dont la sortie est prévue le 15 avril 2025.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p class=\"has-pomegrade-1-color has-text-color has-link-color wp-elements-25a8d26d528a99d7724a8a001a372b5a\"><a href=\"https://make.wordpress.org/core/6-8/\">En savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.8</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>Une vaste gamme d&rsquo;améliorations concerne les performances, l&rsquo;expérience de développement et l’interface d&rsquo;édition générale. Cette version introduit de nouveaux outils comme le filtre <code>should_load_block_assets_on_demand</code> pour optimiser le chargement des ressources, un système d&rsquo;avertissement utilisable lorsque vous employez <code>useSelect</code>, et un système d&rsquo;enregistrement des blocs plus efficace. Elle contient aussi une mise à jour des outils de design disponibles pour chaque bloc, affine les composants de l&rsquo;interface et propose une série de changements divers qui améliorent la cohérence et l&rsquo;extensibilité de l&rsquo;éditeur. Ces changements contribuent à un flux de travail de développement plus fluide et à un environnement d&rsquo;édition plus adaptatif.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performances et chargement des ressources</h3>\n\n\n\n<p>De nouveaux outils aident les développeuses et les développeurs à créer des expériences d&rsquo;utilisation des blocs plus performantes. Un avertissement dans le crochet <code>useSelect</code> alerte lorsque les sélecteurs sont définis en ligne, un problème courant qui peut entraîner un recalcul du rendu inutile. Le filtre <code>should_load_block_assets_on_demand</code> offre un contrôle précis sur le fait que les ressources de bloc soient mises en file d&rsquo;attente globalement ou uniquement en cas de besoin, ce qui permet de réduire le CSS et le JavaScript inutilisés sur l&rsquo;interface <em>front</em>. Tous ces changements favorisent des flux de travail de développement plus efficaces et optimisés.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fhFlkFOCIl\"><a href=\"https://make.wordpress.org/core/2025/03/12/data-a-helpful-performance-warning-for-developers-in-the-useselect-hook/\">Data: A helpful performance warning for developers in the &#8216;useSelect&#8217; hook</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Data: A helpful performance warning for developers in the &#8216;useSelect&#8217; hook&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/data-a-helpful-performance-warning-for-developers-in-the-useselect-hook/embed/#?secret=450zF7Nret#?secret=fhFlkFOCIl\" data-secret=\"fhFlkFOCIl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hB2FZegD7B\"><a href=\"https://make.wordpress.org/core/2025/03/24/new-filter-should_load_block_assets_on_demand-in-6-8/\">New filter should_load_block_assets_on_demand in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New filter &lt;code&gt;should_load_block_assets_on_demand&lt;/code&gt; in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/24/new-filter-should_load_block_assets_on_demand-in-6-8/embed/#?secret=YjASEVzB2H#?secret=hB2FZegD7B\" data-secret=\"hB2FZegD7B\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"block-and-design-tool-registration\">Gestion des blocs et outils de personnalisation disponibles pour chaque bloc</h3>\n\n\n\n<p>Les améliorations apportées à l&rsquo;enregistrement des blocs et à la visibilité des outils de conception simplifient le développement pour l&rsquo;éditeur de blocs. Une approche plus efficace de l&rsquo;enregistrement des types de blocs réduit la surcharge liée au chargement des métadonnées des blocs, en particulier dans les environnements comportant de nombreux blocs personnalisés. En complément, nous avons sorti une nouvelle version de la liste des outils de personnalisation disponibles pour chaque bloc afin d’indiquer&nbsp;<strong>pour chaque outil de personnalisation les blocs qui le prennent en charge</strong>, offrant ainsi aux développeur·euses une vision plus claire des options disponibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"a3N8ljSVe9\"><a href=\"https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/\">More efficient block type registration in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;More efficient block type registration in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/embed/#?secret=QzNxSOMj2W#?secret=a3N8ljSVe9\" data-secret=\"a3N8ljSVe9\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"DOAiQNo1bl\"><a href=\"https://make.wordpress.org/core/2025/03/12/roster-of-design-tools-per-block-wordpress-6-8-edition/\">Roster of design tools per block (WordPress 6.8 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.8 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/roster-of-design-tools-per-block-wordpress-6-8-edition/embed/#?secret=dsWOhWCruy#?secret=DOAiQNo1bl\" data-secret=\"DOAiQNo1bl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"editor-ui-and-component-updates\">Interface de l’éditeur et mise à jour des composants</h3>\n\n\n\n<p>Des modifications apportées à l&rsquo;interface de l&rsquo;éditeur améliorent la cohérence, la convivialité et l&rsquo;ergonomie des différents éléments qui le composent. Les mises à jour des composants d&rsquo;interface d&rsquo;utilisation de base, tels que les boutons et les principes de mise en page, alignent le style et les comportements sur la base du nouveau système de design de WordPress. D&rsquo;autres changements concernent une meilleure cohérence du balisage dans le bloc Navigation, une prévisualisation de contenu améliorée pour le bloc Groupe et une meilleure accessibilité pour les éléments d&rsquo;interface. Ces modifications contribuent à une expérience d&rsquo;édition plus soignée et prévisible.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hCtw3Sfz1F\"><a href=\"https://make.wordpress.org/core/2025/03/25/updates-to-user-interface-components-in-wordpress-6-8/\">Updates to user-interface components in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to user-interface components in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/updates-to-user-interface-components-in-wordpress-6-8/embed/#?secret=wgcNFOWlm3#?secret=hCtw3Sfz1F\" data-secret=\"hCtw3Sfz1F\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"KihoQxj7Gw\"><a href=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-block-editor-changes-in-wordpress-6-8/\">Miscellaneous Block Editor Changes in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Block Editor Changes in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-block-editor-changes-in-wordpress-6-8/embed/#?secret=H0oRlXN4zs#?secret=KihoQxj7Gw\" data-secret=\"KihoQxj7Gw\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"accessibility\">Accessibilité</h2>\n\n\n\n<p>Un large éventail d&rsquo;améliorations de l&rsquo;accessibilité de WordPress arrive avec la version&nbsp;6.8&nbsp;: amélioration de la navigation, de la clarté du balisage et de la prise en charge des lecteurs d&rsquo;écran dans l&rsquo;ensemble de l&rsquo;éditeur de blocs&nbsp;; amélioration de la classe <code>.screen-reader-text</code> qui offre désormais un comportement de focus plus cohérent entre les composants&nbsp;; tandis que des dizaines d&rsquo;autres améliorations concernent les structures de menu, les libellés des blocs, les infobulles et la sémantique de l&rsquo;interface. Ces changements créent une expérience d’utilisation plus inclusive et rapprochent WordPress des meilleures pratiques en matière d&rsquo;accessibilité.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"lLtdPQgH11\"><a href=\"https://make.wordpress.org/core/2025/03/25/accessibility-improvements-in-wordpress-6-8/\">Accessibility Improvements in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Accessibility Improvements in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/accessibility-improvements-in-wordpress-6-8/embed/#?secret=ByVi2u33L9#?secret=lLtdPQgH11\" data-secret=\"lLtdPQgH11\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"MY8vUHKQ6W\"><a href=\"https://make.wordpress.org/core/2025/03/20/changes-to-the-screen-reader-text-class-in-wordpress-6-8/\">Changes to the .screen-reader-text class in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Changes to the .screen-reader-text class in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/20/changes-to-the-screen-reader-text-class-in-wordpress-6-8/embed/#?secret=ip8giZeKP4#?secret=MY8vUHKQ6W\" data-secret=\"MY8vUHKQ6W\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"internationalization\">Internationalisation</h2>\n\n\n\n<p>Plusieurs améliorations ont été apportées aux outils et à l&rsquo;infrastructure d&rsquo;internationalisation afin d&rsquo;améliorer l&rsquo;expérience de traduction et de localisation. Les mises à jour comprennent l&rsquo;arrivée de nouvelles fonctions de traduction, des corrections de cohérence et une meilleure prise en charge des formes plurielles, ce qui facilite la création d&rsquo;extensions, de thèmes et d&rsquo;interfaces entièrement traduisibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"NqvcibLyGF\"><a href=\"https://make.wordpress.org/core/2025/03/12/i18n-improvements-6-8/\">Internationalization improvements in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/i18n-improvements-6-8/embed/#?secret=NBUGYYmhDo#?secret=NqvcibLyGF\" data-secret=\"NqvcibLyGF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance\">Performances</h2>\n\n\n\n<p>De nouveaux outils et des conseils aident les développeurs et développeuses à créer des interfaces plus rapides. La fonctionnalité de chargement spéculatif utilise l&rsquo;API <code>Speculation Rules</code> pour précharger ou pré-afficher les cibles des liens de navigation, améliorant ainsi la performance perçue par les utilisateurs finaux lors du clic sur un lien. De plus, des modifications de l&rsquo;API <code>Interactivity</code> permettront d&rsquo;écrire du code <em>front-end</em> plus efficace et plus évolutif.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HRsy4J27Eb\"><a href=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/\">Speculative Loading in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Speculative Loading in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/embed/#?secret=d8v7ZXJwkZ#?secret=HRsy4J27Eb\" data-secret=\"HRsy4J27Eb\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"49PtIbJHVl\"><a href=\"https://make.wordpress.org/core/2025/03/24/interactivity-api-best-practices-in-6-8/\">Interactivity API best practices in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Interactivity API best practices in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/24/interactivity-api-best-practices-in-6-8/embed/#?secret=CslBN8jmlU#?secret=49PtIbJHVl\" data-secret=\"49PtIbJHVl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"rest-api\">API REST</h2>\n\n\n\n<p>Les améliorations apportées à l&rsquo;API REST étendent sa flexibilité et son utilité pour les applications WordPress <em>headless</em> et découplées. Un nouveau filtre, <code>rest_menu_read_access</code>, permet aux développeur·euses de contrôler l&rsquo;accès public aux menus de navigation, aux éléments de menu et aux emplacements de menu via l&rsquo;API REST. Ce changement permet un contrôle plus précis des données de menu exposées via l&rsquo;API, ce qui permet de prendre en charge une gamme plus large de cas d&rsquo;utilisation.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"eCrEpoAbgB\"><a href=\"https://make.wordpress.org/core/2025/03/27/new-rest-api-filter-for-exposing-menus-publicly-in-wordpress-6-8/\">New REST API Filter for Exposing Menus Publicly in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New REST API Filter for Exposing Menus Publicly in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/27/new-rest-api-filter-for-exposing-menus-publicly-in-wordpress-6-8/embed/#?secret=TmRv4OhCL7#?secret=eCrEpoAbgB\" data-secret=\"eCrEpoAbgB\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"security\">Sécurité</h2>\n\n\n\n<p>La sécurité des mots de passe a été renforcée grâce à l&rsquo;introduction de <code>bcrypt</code> comme nouvel algorithme de hachage par défaut. Ce changement modernise le stockage des mots de passe de WordPress, offrant une meilleure résistance aux attaques par force brute et s&rsquo;alignant sur les meilleures pratiques actuelles de l&rsquo;industrie. Les mots de passe existants restent valides et seront re-hachés avec <code>bcrypt</code> lors de la prochaine connexion réussie de l&rsquo;utilisateur·ice.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"qVqP1W6BMg\"><a href=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/\">WordPress 6.8 will use bcrypt for password hashing</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.8 will use bcrypt for password hashing&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/embed/#?secret=avMfXAbxDn#?secret=qVqP1W6BMg\" data-secret=\"qVqP1W6BMg\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<p>Un ensemble de modifications plus petites améliore la cohérence, l&rsquo;extensibilité et l&rsquo;expérience de développement générale. Ces changements couvrent divers domaines du cœur WordPress, notamment la gestion des médias, le rendu de certains codes courts (<em>shortcodes</em>), l&rsquo;enregistrement des types de publications, la gestion des thèmes. Bien qu&rsquo;individuellement mineures, ces modifications reflètent les efforts continus pour moderniser notre CMS.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"6yMViHGi0o\"><a href=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-developer-changes-in-wordpress-6-8/\">Miscellaneous developer changes in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous developer changes in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-developer-changes-in-wordpress-6-8/embed/#?secret=8nTjG46eRo#?secret=6yMViHGi0o\" data-secret=\"6yMViHGi0o\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"but-wait-there-is-more\">Attendez, ce n’est pas fini&nbsp;!</h2>\n\n\n\n<p>WordPress 6.8 offre encore bien davantage&nbsp;!&nbsp;Plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">170 bogues</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">104 améliorations et nouvelles fonctionnalités</a>, et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">21 tâches diverses</a>&nbsp;ont été&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">clôturés dans WordPress 6.8</a>.&nbsp; Cette version va par exemple permettre d&rsquo;afficher les nouveaux emojis de la version 15.1 de la bibliothèque Twemoji pour les internautes qui ne peuvent pas les afficher nativement dans leur navigateur (exemple de nouvel emoji&nbsp;: <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/1f426-200d-1f525.png\" alt=\"🐦‍🔥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />).</p>\n\n\n\n<p>Voici quelques modifications notables&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Remplacement des chaînes « Add New {Item} » par « Add {Item} » partout sur l&rsquo;administration (<a href=\"https://core.trac.wordpress.org/ticket/61219\">ticket #61219</a>)</li>\n\n\n\n<li>Amélioration des chaînes traduisibles sur le thème Twenty Twenty-Five (<a href=\"https://core.trac.wordpress.org/ticket/62482\">ticket #62482</a>)</li>\n\n\n\n<li>Thèmes natifs&nbsp;: amélioration de l&rsquo;accessibilité du lien du titre du site (<a href=\"https://core.trac.wordpress.org/ticket/62895\">ticket #62895</a>)</li>\n\n\n\n<li>Gestion des dates&nbsp;: les réglages des dates obtiennent deux nouvelles options, <code>j.n.Y</code> et <code>d.m.Y</code> (<a href=\"https://core.trac.wordpress.org/ticket/55685\">#55685</a>)</li>\n\n\n\n<li>Contenus embarqués&nbsp;: ajout de Canva en tant que fournisseur oEmbed (<a href=\"https://core.trac.wordpress.org/ticket/58840\">ticket #58840</a>)</li>\n\n\n\n<li>API des métadonnées&nbsp;: renommage de l’action <code>setted_transient</code>&nbsp;en&nbsp;<code>set_transient</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/62849\">ticket #62849</a>)</li>\n\n\n\n<li>API REST&nbsp;: gestion des barres obliques de fin de chaînes dans&nbsp;<code>rest_preload_api_request</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/57048\">ticket #57048</a>)</li>\n\n\n\n<li>Sécurité&nbsp;: assurance explicite du caractère requis du module PHP&nbsp;<code>hash</code>&nbsp;et ajout de vérifications des prérequis lors de l&rsquo;installation et de la mise à jour (<a href=\"https://core.trac.wordpress.org/ticket/56017\">ticket #56017</a>)</li>\n\n\n\n<li>Mises à jour&nbsp;: suppression d&rsquo;une vérification inutile lors de la vérification des mises à jour lorsque la donnée est à jour (<a href=\"https://core.trac.wordpress.org/ticket/44118\">ticket #44118</a>)</li>\n\n\n\n<li>Widgets&nbsp;: ajout de la prise en charge des types de publications dans la fonction&nbsp;<code>get_calendar()</code>. Ces modifications introduisent également un nouveau filtre&nbsp;<code>get_calendar_args</code> (<a href=\"https://core.trac.wordpress.org/ticket/34093\">ticket #34093</a>)</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.8 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.8.0/\">https://developer.wordpress.org/reference/since/6.8.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-style-serif has-charcoal-0-color has-text-color has-background has-link-color wp-elements-b65007937b1cf3a6c667456985c6a68f is-layout-constrained wp-block-group-is-layout-constrained\" style=\"background:linear-gradient(135deg,rgb(242,255,240) 0%,rgb(255,252,223) 50%,rgb(255,211,218) 100%);padding-top:1em;padding-bottom:1em\">\n<p class=\"is-style-serif has-black-color has-text-color has-link-color wp-elements-acf16339b7757858691a26a725321228\">Que vous développiez des thèmes ou des extensions, pensez à <strong>tester et retester votre code</strong> pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/10/wordpress-6-7-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em>&nbsp;de WordPress 6.8</a>.&nbsp;<br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du&nbsp;<a href=\"https://make.wordpress.org/core/2025/03/28/wordpress-6-8-field-guide/\">Field Guide&nbsp;de WP 6.8 (en anglais)</a>&nbsp;par&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci <a href=\'https://profiles.wordpress.org/clementpolito/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>clementpolito</a>, <a href=\'https://profiles.wordpress.org/rainbowgeek/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rainbowgeek</a>, <a href=\'https://profiles.wordpress.org/reskatorfr/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>reskatorfr</a>, <a href=\'https://profiles.wordpress.org/jdy68/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jdy68</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3310\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordPress 6.7 « Rollins »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://fr.wordpress.org/2024/11/12/wordpress-6-7-rollins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 23:14:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3255\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:385:\"Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 «&#160;Rollins&#160;» rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&#8217;innovation et son approche de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:69268:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/11/Release-Edition-Featured-Image-1024x535.png\" alt=\"\" class=\"wp-image-18085\" /></figure>\n\n\n\n<p>Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 «&nbsp;Rollins&nbsp;» rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&rsquo;innovation et son approche de l&rsquo;expression musicale.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.7&nbsp;!</h2>\n\n\n\n<p>WordPress 6.7 introduit le nouveau thème <bdo lang=\"en\" dir=\"ltr\"><em>Twenty Twenty-Five</em></bdo>, qui offre une flexibilité de conception ultime pour tous les sites et blogs. Vous pourrez gérer la typographie de votre site comme jamais auparavant. Les nouvelles fonctionnalités de zoom arrière vous permettront de concevoir votre site avec une vue macroscopique pour prendre du recul sur les détails de votre projet.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\" target=\"_blank\" rel=\"noreferrer noopener\">Télécharger WordPress 6.7 «&nbsp;Rollins&nbsp;» en français (ZIP – 19,1 Mo)</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Présentation du nouveau thème <bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo></h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une infinité de possibilités sans complexité</p>\n</blockquote>\n\n\n\n<p><bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo> est un thème polyvalent, axé sur le design, qui vous permet de créer des sites époustouflants en toute simplicité. Personnalisez votre esthétisme grâce à un éventail d‘options de style, de compositions de blocs et de palettes de couleurs. Réduit à l‘essentiel, c‘est un thème qui peut vraiment évoluer avec vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-tt5-2.webp\" alt=\"\" style=\"object-fit:cover\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Obtenez une vue d’ensemble en dézoomant</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Explorez votre contenu sous un nouvel angle</p>\n</blockquote>\n\n\n\n<p>Modifiez et organisez des sections entières de votre contenu comme jamais auparavant. Une vue plus large de votre site vous permet d‘ajouter, de modifier, de mélanger ou de supprimer des compositions à votre guise. Laissez s‘exprimer l‘architecte qui est en vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-zoom-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Connectez des blocs et des champs personnalisés sans souci (et sans coder)</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une manière simplifiée de créer du contenu dynamique</p>\n</blockquote>\n\n\n\n<p>Cette fonctionnalité introduit une nouvelle interface pour connecter des blocs à des champs personnalisés. Cela vous donne le contrôle d’éléments dynamiques directement dans l’éditeur. Vous pouvez relier des blocs à des champs en quelques clics, ce qui améliore la flexibilité et l’efficacité de ces actions. Vos clients vont adorer ça.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-block-bindings-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Laissez s’exprimer votre passion pour la typographie</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Nouvelle section de styles, nouvelles possibilités</p>\n</blockquote>\n\n\n\n<p>Créez, modifiez, retirez et appliquez des préréglages de taille de police avec le dernier apport à l’interface des Styles. Surchargez le thème par défaut ou créez votre propre taille de police personnalisée, avec une typographie dynamique pour un redimensionnement responsive des polices. Prenez soin des détails&nbsp;!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-font-presets-2.png\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.7 propose d’importantes mises à jour en matière de performances, notamment un chargement plus rapide des compositions, des aperçus optimisés pour le composant des vues de données, une meilleure prise en charge de PHP 8 et plus, la suppression du code obsolète, des tailles automatiques pour les images en chargement différé, ainsi qu’un traitement plus efficace des balises dans l’API HTML.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 65 correctifs et améliorations d’accessibilité focalisées sur les aspects fondamentaux de l’expérience de WordPress, de l’amélioration des composants d’interface d’administration à la navigation clavier dans l’éditeur, en passant par des niveaux de titres plus accessibles dans les écrans de connexion et de meilleurs libellés.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.7</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Lisez les <a href=\"https://wordpress.org/support/wordpress-version/version-6-7/\">notes de version de WordPress 6.7</a> pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<p>Explorez le <a href=\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\">guide des changements techniques de WordPress 6.7</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous permettent de construire votre site avec WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.7</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version&nbsp;: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a></li>\n\n\n\n<li>Direction technique&nbsp;cœur&nbsp;: <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>,&nbsp;<a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a></li>\n\n\n\n<li>Gestion de projet côté cœur&nbsp;: <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a>, <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a></li>\n\n\n\n<li>Gestion de projet côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>,&nbsp;<a href=\"https://wordpress.org/support/users/colorful-tones/\">Damon Cook</a></li>\n\n\n\n<li>Direction de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a></li>\n\n\n\n<li>Direction des tests&nbsp;: <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K. Gupta</a></li>\n\n\n\n<li>Direction artistique&nbsp;: <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a></li>\n\n\n\n<li>Direction des performances&nbsp;: <a href=\"https://profiles.wordpress.org/adamsilverstein/\"></a><a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Direction du design du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li>\n\n\n\n<li>Direction du développement du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.7 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>780 personnes provenant de tous les pays du monde</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 230 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.7 <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull is-style-short-text has-lemon-3-background-color has-background\" style=\"font-size:12px\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/75thtrombone/\">75thtrombone</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aware/\">Aaron Ware</a> · <a href=\"https://profiles.wordpress.org/aatanasov/\">aatanasov</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/ababir/\">Abir</a> · <a href=\"https://profiles.wordpress.org/acafourek/\">acafourek</a> · <a href=\"https://profiles.wordpress.org/adamkheckler/\">Adam Heckler</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adamwood/\">Adam Wood</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/adrian2k7/\">Adrian</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/ah72king/\">ah72king</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akashdhawade/\">Akash Dhawade</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/alaminfirdows/\">Al-Amin Firdows</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/alessandrotesoro/\">Alessandro Tesoro</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alex27/\">alex27</a> · <a href=\"https://profiles.wordpress.org/digitalex11/\">Alexander Frank</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/harlet7/\">Alexandru Horeanu</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">alexcu21</a> · <a href=\"https://profiles.wordpress.org/ali7ali/\">Ali Ali</a> · <a href=\"https://profiles.wordpress.org/aliaghdam/\">aliaghdam</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/alvitazwar052/\">Alvi Tazwar</a> · <a href=\"https://profiles.wordpress.org/amincharoliya/\">Amin Charoliya</a> · <a href=\"https://profiles.wordpress.org/amirthepiper/\">Amir Abbas</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/amjadr360/\">Amjad Ali</a> · <a href=\"https://profiles.wordpress.org/anthakkar08/\">Anand Thakkar</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andreiglingeanu/\">andreiglingeanu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankit k gupta/\">Ankit K. Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/the-ank/\">Ankur Vishwakarma</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/perezcarreno/\">Armando J. Perez Carreno</a> · <a href=\"https://profiles.wordpress.org/armandsdz/\">Armands</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/ambrosiawt/\">Art Smith</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/arypneta/\">arypneta</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/nmutua/\">Autumn</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/bjerke-johannessen/\">Bård Bjerke Johannessen</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/neoxx/\">Bernhard Riedl</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berubenic/\">berubenic</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai13/\">Bhavesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">bijit027</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/blindmikey/\">blindmikey</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdannikolic/\">Bogdan Nikolic</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/brentjettgmailcom/\">Brent Jett</a> · <a href=\"https://profiles.wordpress.org/brettshumaker/\">Brett Shumaker</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/bgosnell/\">Brian Gosnell</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/bridgetwes/\">bridgetwes</a> · <a href=\"https://profiles.wordpress.org/brobken/\">brobken</a> · <a href=\"https://profiles.wordpress.org/freibergergarcia/\">Bruno Freiberger Garcia</a> · <a href=\"https://profiles.wordpress.org/cambabutonono/\">Cambabutonono</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/carstenbach/\">Carsten Bach</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/mchirag2002/\">Chirag Mathur</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/eclare/\">Chris Trynkiewicz (Sukces Strony)</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/cfinke/\">Christopher Finke</a> · <a href=\"https://profiles.wordpress.org/ckanitz/\">Christopher Kanitz</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/craynor/\">craynor</a> · <a href=\"https://profiles.wordpress.org/creativethemeshq/\">creativethemeshq</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/da5f656f/\">da5f656f</a> · <a href=\"https://profiles.wordpress.org/xendo/\">Dademaru</a> · <a href=\"https://profiles.wordpress.org/daleharrison/\">daleharrison</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/colorful tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/itsdanny/\">Danny</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/d-signed/\">Dareth NHANG</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/daveagp/\">daveagp</a> · <a href=\"https://profiles.wordpress.org/fac3less/\">David</a> · <a href=\"https://profiles.wordpress.org/dballari/\">David Ballarin Prunera</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/davidhbrown/\">David Brown</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/davidgodleman10up/\">David Godleman</a> · <a href=\"https://profiles.wordpress.org/dhenriet/\">David Henriet</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/ddewan/\">ddewan</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a> · <a href=\"https://profiles.wordpress.org/dekadinious/\">Dekadinious</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dsmart/\">Derek Smart</a> · <a href=\"https://profiles.wordpress.org/deryck/\">Deryck</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/devspace/\">devspace</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divibanks/\">Divi Banks</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/djennez/\">djennez</a> · <a href=\"https://profiles.wordpress.org/cyberorca/\">Doni Kuntoro</a> · <a href=\"https://profiles.wordpress.org/dorzki/\">Dor Zuberi</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/eballeste/\">eballeste</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/beckej/\">Ed Beck</a> · <a href=\"https://profiles.wordpress.org/ejnwebmaster/\">ejnwebmaster</a> · <a href=\"https://profiles.wordpress.org/elfu98/\">elfu98</a> · <a href=\"https://profiles.wordpress.org/eliorivero/\">Elio Rivero</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/erichmond/\">Elliott Richmond</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanue ATSÉ</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/emmanuel78/\">emmanuel78</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique Sánchez</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/erikiva/\">erikiva</a> · <a href=\"https://profiles.wordpress.org/erikyo/\">erikyo</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/fahimmurshed/\">FahimMurshed</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/iamfarhan09/\">Farhan Ahmed</a> · <a href=\"https://profiles.wordpress.org/fayyazfayzi/\">Fayyaz</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fjorgemota/\">Fernando Jorge Mota (a11n)</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/fullworks/\">fullworks</a> · <a href=\"https://profiles.wordpress.org/gwallace87/\">Gale Wallace</a> · <a href=\"https://profiles.wordpress.org/gansbrest/\">gansbrest</a> · <a href=\"https://profiles.wordpress.org/garethelwell/\">Gareth Elwell</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gauravtiwari/\">Gaurav Tiwari</a> · <a href=\"https://profiles.wordpress.org/gauravsingh7/\">gauravsingh7</a> · <a href=\"https://profiles.wordpress.org/georgwordpress/\">Georg</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/germanfrelo/\">Germán Freixinós</a> · <a href=\"https://profiles.wordpress.org/gmariani405/\">gmariani405</a> · <a href=\"https://profiles.wordpress.org/graemef/\">GraemeF</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/greentreefrog/\">greentreefrog</a> · <a href=\"https://profiles.wordpress.org/greenworld/\">GreenWorld</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gyurmey/\">Gyurmey</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/halilesen/\">Halil ESEN</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardipparmar/\">Hardip Parmar</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/plaidharper/\">Harper Holsinger</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshvaishnav/\">harshvaishnav</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hectorjarquin/\">hectorjarquin</a> · <a href=\"https://profiles.wordpress.org/hedgefield/\">hedgefield</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hirschferkel/\">hirschferkel</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/htmgarcia/\">htmgarcia</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/kardi420/\">Ibrahim</a> · <a href=\"https://profiles.wordpress.org/ibrahimriaz/\">Ibrahim Riaz</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itapress/\">itapress</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jpstevens/\">Jack Stevens</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/smithjw1/\">Jacob Smith</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">jagirbahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/jtgreyd/\">Jakob Trost</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jamesosborne/\">James Osborne</a> · <a href=\"https://profiles.wordpress.org/jamesros161/\">James Rosado</a> · <a href=\"https://profiles.wordpress.org/jwgoedert/\">James Wesley Goedert</a> · <a href=\"https://profiles.wordpress.org/janpfeil/\">Jan Pfeil</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">Jarko Piironen</a> · <a href=\"https://profiles.wordpress.org/jasonbahl/\">Jason Bahl</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javad2000/\">javad2000</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/jawadwp/\">Jawad Malik</a> · <a href=\"https://profiles.wordpress.org/topdownjimmy/\">Jay</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/drjosh07/\">jbrya029</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jenilk/\">Jenil Kanani</a> · <a href=\"https://profiles.wordpress.org/jennifarhat/\">Jennifer Farhat</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">Jerry Jones</a> · <a href=\"https://profiles.wordpress.org/skobe/\">Jesko Bendmann</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jetaldobariya1/\">jetaldobariya1</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jimmyh61/\">jimmyh61</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnillo/\">John Espiritu</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/lwangaman/\">JohnRDOrazio</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/elbsegler/\">Jonas</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnywatersbb/\">Jonny Waters</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josklever/\">Jos Klever</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jossnaz/\">Jossnaz</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/julianoe/\">julianoe</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/junedsabaliya/\">Juned Sabaliya</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kaavyaiyer/\">Kaavya Iyer (woo-hc)</a> · <a href=\"https://profiles.wordpress.org/arkenon/\">Kadim Gültekin</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kamran8176/\">Kamran Hussen</a> · <a href=\"https://profiles.wordpress.org/karan4word/\">Karan Gupta</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/kartikmehta/\">Kartik Mehta</a> · <a href=\"https://profiles.wordpress.org/kartik-suthar/\">Kartik Suthar</a> · <a href=\"https://profiles.wordpress.org/kbrownkd/\">kbrownkd (a11n)</a> · <a href=\"https://profiles.wordpress.org/keffr3n/\">Keffr3n</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/kellenmace/\">Kellen Mace</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/kevinb/\">Kevin Behrens</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kevinswalsh/\">kevinswalsh</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kisquian/\">kisquian</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kowsar89/\">Kowsar Hossain</a> · <a href=\"https://profiles.wordpress.org/kracked888/\">kracked888</a> · <a href=\"https://profiles.wordpress.org/krishneup/\">Krishna Neupane</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/gohelkunjan/\">Kunjan Gohel</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/mlaetitia/\">Lae</a> · <a href=\"https://profiles.wordpress.org/notlaura/\">Lara Schenck</a> · <a href=\"https://profiles.wordpress.org/lastsplash/\">lastsplash (a11n)</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/oncecoupled/\">Lauren</a> · <a href=\"https://profiles.wordpress.org/laranz/\">Lawrence Joe</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/lifelightweb/\">lifelightweb</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/crixu/\">Lucas</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasbesch/\">lukasbesch</a> · <a href=\"https://profiles.wordpress.org/lukecarbis/\">Luke Carbis</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/nadimcse/\">Mahmudul Haque Nadim</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/manbo/\">manbo</a> · <a href=\"https://profiles.wordpress.org/maneshtimilsina/\">Manesh Timilsina</a> · <a href=\"https://profiles.wordpress.org/targz-1/\">Manuel Schmalstieg</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/marianguas/\">María Anguas</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/mardroid/\">Marcel Tannich</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/iworks/\">Marcin Pietrzak</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/pereirinha/\">Marco Pereirinha</a> · <a href=\"https://profiles.wordpress.org/marcwieland95/\">marcwieland95</a> · <a href=\"https://profiles.wordpress.org/igreenie/\">Marek Železný</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markparnell/\">Mark Parnell</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">marybaum</a> · <a href=\"https://profiles.wordpress.org/mat_/\">mat_</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattormeeple/\">Matt Sherman</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/lonelyvegan/\">Matthew Riley MacPherson</a> · <a href=\"https://profiles.wordpress.org/kittmedia/\">Matthias Kittsteiner</a> · <a href=\"https://profiles.wordpress.org/mattraines/\">mattraines</a> · <a href=\"https://profiles.wordpress.org/maurodf/\">maurodf</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mcrisp1972/\">mcrisp1972</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/istiaqhossain/\">Md. Istiaq Hossain</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/iammehedi1/\">Mehedi Hassan</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/meteorlxy/\">meteorlxy</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith</a> · <a href=\"https://profiles.wordpress.org/michaelbourne/\">Michael Bourne</a> · <a href=\"https://profiles.wordpress.org/hrkhal/\">Michael James Ilett</a> · <a href=\"https://profiles.wordpress.org/michaelpick/\">michaelpick</a> · <a href=\"https://profiles.wordpress.org/michaelwp85/\">michaelwp85</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/mielbu/\">Michelle Bulloch</a> · <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikeb8s/\">mikeb8s</a> · <a href=\"https://profiles.wordpress.org/mikeybinns/\">Mikey Binns</a> · <a href=\"https://profiles.wordpress.org/milamj/\">milamj</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mklusak/\">mklusak</a> · <a href=\"https://profiles.wordpress.org/mleathem/\">mleathem</a> · <a href=\"https://profiles.wordpress.org/mlf20/\">mlf20</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/morganestes/\">Morgan Estes</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mossy2100/\">mossy2100</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir a11n</a> · <a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a> · <a href=\"https://profiles.wordpress.org/nagpai/\">Nagesh Pai</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">Nate Finch</a> · <a href=\"https://profiles.wordpress.org/nateinaction/\">Nate Gay</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/nebojsajurcic/\">Nebojša Jurčić</a> · <a href=\"https://profiles.wordpress.org/nek285/\">nek285</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">neo2k23</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nickbohle/\">Nick Bohle</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nick_thegeek/\">Nick the Geek</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nurielmeni/\">nurielmeni</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/olivierlafleur/\">Olivier Lafleur</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/oscarhugopaz/\">Oscar Hugo Paz</a> · <a href=\"https://profiles.wordpress.org/prestonwordsworth/\">p15h</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/otakupahp/\">Pablo Hernández</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pamprn/\">Pamela Ribeiro</a> · <a href=\"https://profiles.wordpress.org/pander/\">pander</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/obrienlabs/\">Pat O’Brien</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a> · <a href=\"https://profiles.wordpress.org/paulwilde/\">Paul Wilde</a> · <a href=\"https://profiles.wordpress.org/paulcline/\">paulcline</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/perryrylance/\">perryrylance</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/pevogam/\">pevogam</a> · <a href=\"https://profiles.wordpress.org/mr2p/\">Phi Phan</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pgeorgiev/\">Plamen Georgiev</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/ppolo99/\">ppolo99</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranitdugad/\">Pranit Dugad</a> · <a href=\"https://profiles.wordpress.org/pratikkry/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/pwtyler/\">pwtyler</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/spanglishwebs/\">Rachel Winspear</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rafaelgalani/\">Rafael Gallani</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/rahmatgumilar/\">Rahmat Gumilar</a> · <a href=\"https://profiles.wordpress.org/rahulharpal/\">rahulharpal</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/shashwatahalder01/\">rajkumar shashwata halder</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ramswarup/\">Ramswarup Rathod</a> · <a href=\"https://profiles.wordpress.org/xyulex/\">Raul Martinez</a> · <a href=\"https://profiles.wordpress.org/rcneil/\">rcneil</a> · <a href=\"https://profiles.wordpress.org/realthemes/\">realthemes</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/reputeinfosystems/\">reputeinfosystems</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rhellewellgmailcom/\">Rick Hellewell</a> · <a href=\"https://profiles.wordpress.org/riddhipatel/\">Riddhi Patel</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rithik56/\">rithik56</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/robert-biswas/\">Robert Biswas</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/rocketworks/\">rocket.works – Dominik Friedrich</a> · <a href=\"https://profiles.wordpress.org/rodelgc/\">Rodel Calasagsag a11n</a> · <a href=\"https://profiles.wordpress.org/rghedin/\">Rodrigo</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Wolný</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roygbyte/\">roygbyte</a> · <a href=\"https://profiles.wordpress.org/royho/\">royho</a> · <a href=\"https://profiles.wordpress.org/rpf5573/\">rpf5573</a> · <a href=\"https://profiles.wordpress.org/rslee/\">rslee</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rleeson/\">Ryan Leeson</a> · <a href=\"https://profiles.wordpress.org/ryancurban/\">Ryan Urban</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sadmansh/\">sadmansh</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sahiladit/\">sahiladit</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a> · <a href=\"https://profiles.wordpress.org/samtoohey93/\">Sam Toohey</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/samuelsilvapt/\">Samuel Silva</a> · <a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarahricker/\">sarahricker</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/sauliusv/\">Saulius Vikerta</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scottculverhouse/\">scottculverhouse</a> · <a href=\"https://profiles.wordpress.org/seanavers/\">seanavers</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/kuuuzya/\">Sergey</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/zahardoc/\">Serhiy Zakharchenko</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/sharonaustin/\">Sharon Austin</a> · <a href=\"https://profiles.wordpress.org/sheulyshila/\">sheulyshila</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/showravhasan/\">Showrav Hasan</a> · <a href=\"https://profiles.wordpress.org/shreya0204/\">Shreya Agarwal</a> · <a href=\"https://profiles.wordpress.org/silaskoehler/\">Silas Köhler</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sophiegy/\">Sophie – a11n</a> · <a href=\"https://profiles.wordpress.org/souptik/\">Souptik Datta</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/thompsonsj/\">Steven Thompson</a> · <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a> · <a href=\"https://profiles.wordpress.org/styleshit/\">styleshit</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">Sunil Prajapati</a> · <a href=\"https://profiles.wordpress.org/quadthemes/\">Sunny</a> · <a href=\"https://profiles.wordpress.org/superchlorine/\">superchlorine</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/jannathsyeda/\">Syeda Fahima Jannath</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Takahashi Fumiki</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanvirul/\">Tanvirul Haque</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tdrayson/\">tdrayson</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tmanoilov/\">tmanoilov</a> · <a href=\"https://profiles.wordpress.org/toastercookie/\">toastercookie</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/thomasdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomhine/\">tomhine</a> · <a href=\"https://profiles.wordpress.org/tomllobet/\">tomllobet</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">valer1e</a> · <a href=\"https://profiles.wordpress.org/vertisoft/\">vertisoft</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">vipulpatil</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">vrishabhsk</a> · <a href=\"https://profiles.wordpress.org/wbdv/\">wbdv</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/webwurm/\">webwurm</a> · <a href=\"https://profiles.wordpress.org/wesrapyd/\">wesrapyd</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williamalexander/\">William Alexander</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/wpeople/\">WPeople</a> · <a href=\"https://profiles.wordpress.org/wpsoul/\">wpsoul</a> · <a href=\"https://profiles.wordpress.org/wzieba/\">wzieba</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/collet/\">Yann</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/ytfeldrawkcab/\">ytfeLdrawkcaB</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yukinobu/\">Yukinobu Asakawa</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/zackkrida/\">Zack Krida</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zitaruksergij/\">zitaruksergij</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.7 en français</h2>\n\n\n\n<p>WordPress est un projet international et la version 6.7 est déjà complètement disponible dans plus de 40 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.7 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/xibe\">Xavier Borderie</a>, <a href=\"https://profiles.wordpress.org/amebref\">amebref</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/chris-kns\">chris-kns</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/dfi42\">dfi42</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/florientinneo\">Florient DELAFOY</a>, <a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>, <a href=\"https://profiles.wordpress.org/laeti972\">Laetitia de Perthuis</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/lymx\">Maxime LEROY</a>, <a href=\"https://profiles.wordpress.org/firestar300\">Milan Ricoul</a>, <a href=\"https://profiles.wordpress.org/momo-fr\">momo-fr</a>, <a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>, <a href=\"https://profiles.wordpress.org/phoenix13\">phoenix13</a>, <a href=\"https://profiles.wordpress.org/pierrelannoy\">Pierre Lannoy</a>, <a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>, et <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article traduit par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\"https://profiles.wordpress.org/laboiteare/\">Renaud Pacouil</a> pour sa relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Oct 2024 10:49:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3243\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:436:\"WordPress 6.7 comprend la résolution de plus de&#160;300 tickets sur Trac, dont&#160;87 améliorations et nouvelles fonctionnalités, plus de 200 corrections de bogues. cette version comprend&#160;23 tickets focalisés sur les performances,&#160;21 sur l’accessibilité et&#160;12 sur la modernisation du code et la conformité aux standards de code. Les modifications de 6.7 s’étalent sur&#160;38 composants du cœur du [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:28154:\"\n<figure class=\"wp-block-image alignfull size-large is-style-serif wp-elements-f590cfee42cfa860d05ec74ddea8b4ef\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\"><a href=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"515\" src=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png\" alt=\"\" class=\"wp-image-3244\" srcset=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png 1024w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-300x151.png 300w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-768x386.png 768w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1536x772.png 1536w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-2048x1029.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>WordPress 6.7 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=milestone&amp;order=priority\">300 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">87 améliorations et nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 200 corrections de bogues</a>. cette version comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">23 tickets focalisés sur les performances</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">21 sur l’accessibilité</a> et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">12 sur la modernisation du code et la conformité aux standards de code</a>. Les modifications de 6.7 s’étalent sur&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">38 composants du cœur du CMS</a>.</p>\n\n\n\n<p>Cette version comprend aussi <a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">445 améliorations</a>,&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">464 corrections de bogues</a> et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">55 améliorations d’accessibilité</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-ca39a6cbb68f24eb2fca5cc30331b23f\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.7, dont la sortie est prévue le 12 novembre 2024.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/6-7/\">Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.7, consultez cette page.</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"Block-Editor\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>WordPress 6.7 implémente 8 versions de Gutenberg &#8211; <a href=\"https://make.wordpress.org/core/2024/06/20/whats-new-in-gutenberg-18-6/\">18.6</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/04/whats-new-in-gutenberg-18-7-03-july/\">18.7</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/17/whats-new-in-gutenberg-18-8-17-july/\">18.8</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/31/whats-new-in-gutenberg-18-9-31-july/#:~:text=In%20a%20recurring%20effort%20to,Links%2C%20and%20Term%20Description%20blocks.\">18.9</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/14/whats-new-in-gutenberg-19-0-14-august/\">19.0</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/28/whats-new-in-gutenberg-19-1-28-august/\">19.1</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/12/what-is-new-in-gutenberg-19-2-11-september/\">19.2</a> et&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/25/whats-new-in-gutenberg-19-3-25-september/\">19.3</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Changements techniques</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"UyWJ3kHEmz\"><a href=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/\">Post Editor iframing with meta boxes in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Post Editor iframing with meta boxes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/embed/#?secret=tSMGBJfYjQ#?secret=UyWJ3kHEmz\" data-secret=\"UyWJ3kHEmz\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"jF8mPpPXlS\"><a href=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/\">Block Bindings: Improvements to the Editor Experience in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Block Bindings: Improvements to the Editor Experience in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/embed/#?secret=LyXnzsvvCL#?secret=jF8mPpPXlS\" data-secret=\"jF8mPpPXlS\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"G8lRmWqAor\"><a href=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/\">Updates to Block Hooks in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Block Hooks in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/embed/#?secret=J4XDYs3pSJ#?secret=G8lRmWqAor\" data-secret=\"G8lRmWqAor\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"h00792iEep\"><a href=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/\">Updates to user-interface components in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to user-interface components in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/embed/#?secret=TCajqUjanO#?secret=h00792iEep\" data-secret=\"h00792iEep\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"react\">Changements concernant les outils de design dans l’éditeur</h3>\n\n\n\n<p>Nous avons poursuivi l’effort de consolidation des outils de design et plusieurs blocs prennent désormais en charge davantage de fonctionnalités de mise en page et de mise en forme.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"obfs4hTFIv\"><a href=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/\">Roster of design tools per block (WordPress 6.7 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.7 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/embed/#?secret=3D3EUMW9w6#?secret=obfs4hTFIv\" data-secret=\"obfs4hTFIv\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-block-editor-changes\">Autres modifications concernant l’éditeur</h3>\n\n\n\n<p>D&rsquo;autres modifications diverses ont été listées dans des notes de développement dédiées&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"Mh1YE1VTiU\"><a href=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/\">Extending the Preview Dropdown Menu in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Extending the Preview Dropdown Menu in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/embed/#?secret=ViTZEpwoUq#?secret=Mh1YE1VTiU\" data-secret=\"Mh1YE1VTiU\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"5T9ubgS9pA\"><a href=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/\">Miscellaneous Block Editor Changes in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Block Editor Changes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/embed/#?secret=45jLTa4za3#?secret=5T9ubgS9pA\" data-secret=\"5T9ubgS9pA\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">API de gestion des interactions et modules de script</h2>\n\n\n\n<p>WordPress 6.7 comprend des mises à jour de l’API <code>Interactivity</code>, comme par exemple une nouvelle façon d’interagir avec les changements d’état côté serveur dans la navigation côté client. Les mises à jour des modules <code>Script</code>s comprennent des améliorations du chargement des scripts existants en tant que dépendances.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"N7suow7aP5\"><a href=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/\">Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/embed/#?secret=XXyFFljgkB#?secret=N7suow7aP5\" data-secret=\"N7suow7aP5\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"64ynOvr7Ew\"><a href=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/\">Updates to Script Modules in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Script Modules in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/embed/#?secret=6Cxd5rFVoy#?secret=64ynOvr7Ew\" data-secret=\"64ynOvr7Ew\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"html-api\">API HTML</h2>\n\n\n\n<p>WordPress 6.7 comprend plusieurs mises à jour de l&rsquo;API <code>HTML</code>. Plusieurs fonctionnalités majeures sont sorties ainsi qu&rsquo;un amélioration conséquente de l&rsquo;utilisabilité du processeur HTML.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"kbJtxPGfqW\"><a href=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/\">Updates to the HTML API in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/embed/#?secret=34UZ0w1coA#?secret=kbJtxPGfqW\" data-secret=\"kbJtxPGfqW\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h2>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/query?component=I18N&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Diverses améliorations de l&rsquo;internationalisation</a> sont disponibles avec WordPress 6.7&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hQXSqWJGem\"><a href=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/\">Internationalization improvements in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/embed/#?secret=eFPqVd4tTO#?secret=hQXSqWJGem\" data-secret=\"hQXSqWJGem\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance\">Performances</h2>\n\n\n\n<p>WordPress 6.7 apporte aussi plusieurs améliorations focalisées sur les performances, telles qu&rsquo;une nouvelle façon de déclarer les blocs utilisant des fichiers PHP générés pour contrecarrer les goulots d&rsquo;étranglement liés au chargement et au parcours des fichiers JSON.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"8oQC5S3C02\"><a href=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/\">New block type registration APIs to improve performance in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New block type registration APIs to improve performance in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/embed/#?secret=XzjPRUchA9#?secret=8oQC5S3C02\" data-secret=\"8oQC5S3C02\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"7r05WrUm18\"><a href=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/\">Auto Sizes for Lazy Loaded Images in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Auto Sizes for Lazy Loaded Images in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/embed/#?secret=wpQMBPVn0N#?secret=7r05WrUm18\" data-secret=\"7r05WrUm18\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fmwVz6LB0l\"><a href=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/\">New Plugin Template Registration API in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New Plugin Template Registration API in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/embed/#?secret=rHnFsEBoL1#?secret=fmwVz6LB0l\" data-secret=\"fmwVz6LB0l\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zeZlu13TM1\"><a href=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/\">Automatic conversion of HEIC images to JPEG in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Automatic conversion of HEIC images to JPEG in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/embed/#?secret=9ECwfO9e5P#?secret=zeZlu13TM1\" data-secret=\"zeZlu13TM1\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.7 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.7.0/\">https://developer.wordpress.org/reference/since/6.7.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-87f312e26bd4a386f9cdeec66ae58d52\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser <a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension « <em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em> »</a> sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/10/wordpress-6-7-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em> de WordPress 6.7</a>. <br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/10/23/wordpress-6-7-field-guide/\">Field Guide de WP 6.7 (en anglais)</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Benard</a> et <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3243\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Nouveau programme de mentorat pour la contribution à WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://fr.wordpress.org/2024/08/21/nouveau-programme-de-mentorat-pour-la-contribution-a-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Aug 2024 09:34:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:18:\"mentorship program\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3204\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:389:\"Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre. Mais c’est quoi exactement ce programme&#160;? Il s’agit du troisième programme organisé par l’équipe Community afin de faciliter [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6506:\"\n<p>Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Mais c’est quoi exactement ce programme&nbsp;?</h2>\n\n\n\n<p>Il s’agit du troisième programme organisé par l’équipe <a href=\"https://make.wordpress.org/community/\">Community</a> afin de faciliter l’intégration de nouvelles personnes aux <a href=\"https://make.wordpress.org/\">diverses équipe de contribution</a>.</p>\n\n\n\n<p>Ce programme met en place de petites équipes avec un mentor et des mentoré·e·s qui travaillent ensemble sur un projet proposé par le mentor lors de sa candidature.</p>\n\n\n\n<p>Les organisateurs répartissent donc les contributeurs/contributrices selon les souhaits qu&rsquo;ils/elles ont définis lors de leur candidature.</p>\n\n\n\n<p>Tout au long du programme, le/la mentor prend en charge l&rsquo;équipe de mentoré·e·s pour avancer le projet qu&rsquo;il/elle a proposé, et quelques réunions en visio sont proposées par les organisateurs.</p>\n\n\n\n<p>Si vous souhaitez débuter la contribution à WordPress mais ne savez pas comment, ni par où commencer, alors ce programme est parfait pour vous en tant que mentoré·e.&nbsp; Vous serez guidé·e tout au long du programme par des mentors et pourrez ainsi obtenir toutes les informations nécessaires à une contribution efficace.<br>Et si vous contribuez déjà et souhaitez transmettre vos connaissances à d’autres personnes alors participez au programme en tant que mentor ! Ce sera l’occasion d’accueillir de nouvelles personnes dans vos équipes respectives.</p>\n\n\n\n<p>Cette cohorte est synchronisée avec la sortie de la version 6.7 afin de permettre aux participants, qui rejoignent l’équipe Core ou celle du développement du thème Twenty Twenty-Five, de contribuer spécifiquement à cette version de WordPress. Mais, la contribution à WordPress ne se résumant pas à son code, vous avez aussi l’opportunité de rejoindre des équipes de contribution non liées au code telles que Communauté (organisation d’évènements et encadrement des équipes), Design, Documentation, Formation, etc.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Qui peut candidater ?</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Pour les mentoré·e·s : toute personne souhaitant débuter la contribution à WordPress, ou encore contribuer à d’autres équipes que celle(s) où il/elle contribue déjà.</li>\n\n\n\n<li>Pour les mentors : toute personne ayant déjà un peu d’expérience dans la contribution WordPress.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Comment rejoindre le programme ?</h2>\n\n\n\n<p>Pour rejoindre le programme, il faut remplir un petit formulaire :</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSd6faivlMZzyiq1sx_78fvnw7-JOshZMZcIO6BTp-B7TuM2ww/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentoré·e</a></div>\n\n\n\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSfDzRRrIDJcQcVF0m3I16-RfwrjmXBHboxCC5Rx0OHatK_EBQ/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentor</a></div>\n</div>\n\n\n\n<p>Mais <strong>attention date limite des candidatures</strong> : </p>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-vivid-red-background-color has-text-color has-background has-link-color wp-elements-18846e5805f4ed69ba3dc19961036bd1\" style=\"margin-top:var(--wp--preset--spacing--10);margin-right:var(--wp--preset--spacing--10);margin-bottom:var(--wp--preset--spacing--10);margin-left:var(--wp--preset--spacing--10);padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\">le 26 août 2024</p>\n\n\n\n<p>Vous serez ensuite recontacté·e.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contribuer dans votre langue</h2>\n\n\n\n<p>Ce 3<sup>e</sup> programme propose une nouveauté : selon le projet auquel vous participerez, vous aurez peut être l’opportunité de contribuer en français, puisque des équipes par locale vont être constituées.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Plus d&rsquo;informations</h2>\n\n\n\n<p>Retrouvez plus d&rsquo;informations sur le programme dans cet article (en anglais) :</p>\n\n\n\n<figure class=\"wp-block-embed aligncenter is-type-wp-embed is-provider-wordpress-org-project wp-block-embed-wordpress-org-project\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"TOusFk6YKX\"><a href=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/\">WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors&#8221; &#8212; WordPress.org Project\" src=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/embed/#?secret=93CdKWMRfW#?secret=TOusFk6YKX\" data-secret=\"TOusFk6YKX\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-purple-2-background-color has-text-color has-background has-link-color has-extra-large-font-size wp-elements-ce3e97f8976a3a3f44d47b605fc66a4f\" style=\"margin-top:var(--wp--preset--spacing--30);margin-right:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30);margin-left:var(--wp--preset--spacing--30);padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\">On compte sur vous pour vous inscrire nombreux et nombreuses à ce programme !<br>Si vous n’avez jamais contribué c’est l’occasion rêvée de commencer, si vous contribuez déjà et souhaitez rejoindre de nouvelles équipes ce programme est fait pour vous !</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 6.6 « Dorsey »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://fr.wordpress.org/2024/07/16/wordpress-6-6-dorsey/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jul 2024 17:40:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3181\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:408:\"Nous avons le plaisir de vous présenter WordPress&#160;6.6 «&#160;Dorsey&#160;», version nommée en l&#8217;honneur du légendaire leader de big band américain Tommy Dorsey. Reconnu pour son timbre de trombone et pour ses compositions, la musique de Dorsey envoûte son audience grâce à sa profondeur émotionnelle et son énergie. Écoutez la musique du Dorsey’s Big Band tandis que vous [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:68957:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2024/07/dorsey.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"680\" src=\"https://fr.wordpress.org/files/2024/07/dorsey-1024x680.png\" alt=\"\" class=\"wp-image-3199\" srcset=\"https://fr.wordpress.org/files/2024/07/dorsey-1024x680.png 1024w, https://fr.wordpress.org/files/2024/07/dorsey-300x199.png 300w, https://fr.wordpress.org/files/2024/07/dorsey-768x510.png 768w, https://fr.wordpress.org/files/2024/07/dorsey-1536x1021.png 1536w, https://fr.wordpress.org/files/2024/07/dorsey-2048x1361.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Nous avons le plaisir de vous présenter WordPress&nbsp;6.6 «&nbsp;Dorsey&nbsp;», version nommée en l&rsquo;honneur du légendaire <bdo lang=\"en\" dir=\"ltr\">leader</bdo> de <bdo lang=\"en\" dir=\"ltr\">big band</bdo> américain Tommy Dorsey. Reconnu pour son timbre de trombone et pour ses compositions, la musique de Dorsey envoûte son audience grâce à sa profondeur émotionnelle et son énergie.</p>\n\n\n\n<p>Écoutez la musique du <a href=\"https://open.spotify.com/playlist/37i9dQZF1DZ06evO2TT3Ge?si=d9872e46371c4ed7\" target=\"_blank\" rel=\"noreferrer noopener\"><bdo lang=\"en\" dir=\"ltr\">Dorsey’s Big Band</bdo></a> tandis que vous découvrirez les nouvelles fonctionnalités et les améliorations de WordPress 6.6.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue à 6.6&nbsp;!</h2>\n\n\n\n<p>WordPress 6.6 répond à la promesse d’un web meilleur en ajoutant de nouveaux outils pour améliorer le quotidien des créateurs de contenus, des sites les plus complexes aux sites «&nbsp;<bdo lang=\"en\" dir=\"ltr\">one page</bdo>&nbsp;». Sans jamais mettre de côté la sécurité, la stabilité ou les performances, WordPress 6.6 apporte de nouveaux outils et améliore les flux de rédaction déjà en place.</p>\n\n\n\n<p>Une nouvelle fonctionnalité de restauration pour les mises à jour automatiques des extensions vous offre quant à elle sécurité, flexibilité et sérénité.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/download/\">Téléchargez WordPress 6.6 «&nbsp;Dorsey&nbsp;»</a></div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Palettes de couleurs et ensembles de polices</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/color-palettes.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Ajout de davantage d’options de conception aux thèmes basés sur des blocs.</strong>&nbsp;Les auteur·ices de thèmes basés sur les blocs peuvent créer un nombre illimité de palettes de couleurs ou de polices personnalisées pour offrir des options graphiques plus spécifiques au sein du même thème. Ces palettes offrent des possibilités graphiques plus harmonisées, permettant une personnalisation sans modifier le style global du site, au-delà des paramètres de couleur ou de typographie.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Aperçu rapide des pages</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/page-previews.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Simplifiez votre flux de travail avec une nouvelle mise en page conçue pour les pages.</strong>&nbsp;Découvrez toutes vos pages et un aperçu de n’importe quelle page sélectionnée avant de la modifier via une nouvelle mise en page dans l’éditeur de site.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Retour en arrière pour les mises à jour automatiques d’extensions</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/feature-rollbacks.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Mettez à jour vos extensions en toute tranquillité.</strong>&nbsp;Bénéficiez de la facilité des mises à jour automatiques des extensions avec la possibilité de restauration en cas de problème, améliorant ainsi la sécurité de votre site tout en minimisant les risques d’indisponibilité potentielle de celui-ci.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Surcharges</h3>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:33.33%\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.6/overrides.webp\" alt=\"\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:66.66%\">\n<p><strong>Ajout de la possibilité de personnaliser les contenus dans les compositions synchronisées.</strong>&nbsp;Autoriser la personnalisation des éléments de contenu spécifiques dans chaque apparition d’une composition synchronisée tout en conservant un style uniformisé pour toutes les apparitions, simplifiant ainsi les futures mises à jour. Actuellement, vous pouvez définir des surcharges pour les blocs Titre, Paragraphe, Bouton et Image.</p>\n</div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.6 comprend des mises à jour importantes comme le retrait d&rsquo;appels redondants vers <code>WP_Theme_JSON</code>, la désactivation du chargement automatique pour les options les plus volumétriques, la suppression de dépendances inutiles, le chargement différé des contenus embarqués, la nouvelle directive <code>data-wp-on-async</code> et une réduction de 33 % du chargement des modèles dans l&rsquo;éditeur.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 55 correctifs d’accessibilité et améliorations se concentrent sur des aspects fondamentaux de l’expérience WordPress, en particulier le composant de vue de données qui alimente la nouvelle expérience de modification de site et des domaines comme l’outil d’insertion qui fournit un moyen-clé d’interagir avec les blocs et les compositions.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Et bien plus encore</h3>\n\n\n\n<p>Pour une vision complète de toutes les nouvelles fonctionnalités et améliorations de WordPress 6.6, vous pouvez consulter le site de démonstration des fonctionnalités.</p>\n\n\n\n<p><a href=\"https://fr.wordpress.org/download/releases/6-6/\">Découvrez toutes les nouveautés</a></p>\n\n\n\n<h3 class=\"wp-block-heading\">En savoir plus sur WordPress 6.6</h3>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Explorez le&nbsp;<a href=\"https://fr.wordpress.org/2024/06/27/guide-des-changements-techniques-de-wordpress-6-6/\">Guide des changements techniques de WordPress 6.6</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous aident à construire avec WordPress.</p>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-6/\">Lisez les notes de version de WordPress 6.6</a>&nbsp;pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.6</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination générale&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a></li>\n\n\n\n<li>Direction technique côté Cœur&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>,&nbsp;<a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a></li>\n\n\n\n<li>Gestion de projet technique côté Cœur&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a></li>\n\n\n\n<li>Gestion de projet technique côté Gutenberg&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a>&nbsp;</li>\n\n\n\n<li>Responsables de la documentation&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a>,&nbsp;<a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/josepmoran/\">Josep Morán</a></li>\n\n\n\n<li>Direction marketing et communication&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a></li>\n\n\n\n<li>Direction artistique : <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a></li>\n\n\n\n<li>Responsable des performances&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a></li>\n\n\n\n<li>Responsables des tests&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a>,&nbsp;<a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a>&nbsp;et&nbsp;<a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a></li>\n\n\n\n<li>Responsable des thèmes natifs&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.6 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>630 personnes provenant d’au moins 50 pays différents</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 150 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.6 <img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p style=\"font-size:10px\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/_ck_/\">_ck_</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/abmamun007/\">Abdullah Mamun</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/abletec/\">abletec</a> · <a href=\"https://profiles.wordpress.org/acosmin/\">acosmin</a> · <a href=\"https://profiles.wordpress.org/adampickering/\">Adam Pickering</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/ajmcfadyen/\">admcfajn</a> · <a href=\"https://profiles.wordpress.org/adrianduffell/\">adrianduffell</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajithrn/\">Ajith R N</a> · <a href=\"https://profiles.wordpress.org/skyakash12/\">Akash Muchandikar</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akmelias/\">akmelias</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/ahoereth/\">Alex</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexkingorg/\">Alex King</a> · <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexanderkoledov/\">AlexKole</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/sabreuse/\">Amy Hendrix (sabreuse)</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anandau14/\">Anand Upadhyay</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/l1nuxjedi/\">Andrew Hutchings</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/norcross/\">Andrew Norcross</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewleap/\">andrewleap</a> · <a href=\"https://profiles.wordpress.org/andbalashov/\">Andrii Balashov</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/apeatling/\">Andy Peatling</a> · <a href=\"https://profiles.wordpress.org/aneeshd16/\">Aneesh Devasthale</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonlukin/\">Anton Lukin</a> · <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/lighthouse79/\">Antonella</a> · <a href=\"https://profiles.wordpress.org/colomet/\">Antonio D.</a> · <a href=\"https://profiles.wordpress.org/antonisme/\">Antonis Lilis</a> · <a href=\"https://profiles.wordpress.org/arena94/\">arena94</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/passoniate/\">Arslan Kalwar</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/iamarunchaitanyajami/\">Arun Chaitanya Jami</a> · <a href=\"https://profiles.wordpress.org/dextorlobo/\">Arun Sharma</a> · <a href=\"https://profiles.wordpress.org/ideag/\">Arunas Liuiza</a> · <a href=\"https://profiles.wordpress.org/iamasadpolash/\">Asad Polash</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/audunmb/\">audunmb</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/filosofo/\">Austin Matzko</a> · <a href=\"https://profiles.wordpress.org/axwax/\">axwax</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/bahia0019/\">bahia0019</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/bangank36/\">bangank36</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/barryhughes-1/\">Barry</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/bartkleinreesink/\">bartkleinreesink</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/beaulebens/\">Beau Lebens</a> · <a href=\"https://profiles.wordpress.org/bedas/\">Beda</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/ubernaut/\">Ben Hansen</a> · <a href=\"https://profiles.wordpress.org/husobj/\">Ben Huson</a> · <a href=\"https://profiles.wordpress.org/benlk/\">Ben Keith</a> · <a href=\"https://profiles.wordpress.org/blobaugh/\">Ben Lobaugh (blobaugh)</a> · <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner – Kadence WP</a> · <a href=\"https://profiles.wordpress.org/retlehs/\">Ben Word</a> · <a href=\"https://profiles.wordpress.org/benjamingosset/\">Benjamin Gosset</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benjaminknox/\">benjaminknox</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/benoitfouc/\">benoitfouc</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/billseymour/\">billseymour</a> · <a href=\"https://profiles.wordpress.org/bplv/\">Biplav</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/bobbingwide/\">bobbingwide</a> · <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a> · <a href=\"https://profiles.wordpress.org/born2webdesign/\">born2webdesign</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradparbs/\">Brad Parbs</a> · <a href=\"https://profiles.wordpress.org/williamsba1/\">Brad Williams</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/drrobotnik/\">Brandon Lavigne</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/fischfood/\">Brian Fischer</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/brookemk/\">Brooke</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/icaleb/\">Caleb Burks</a> · <a href=\"https://profiles.wordpress.org/ecc/\">camya</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cenkdemir/\">cenkdemir</a> · <a href=\"https://profiles.wordpress.org/cfinnberg/\">cfinnberg</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/chasedsiedu/\">chased@si.edu</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/chrisdavidmiles/\">Chris David Miles</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/itschristiandale/\">christian-dale</a> · <a href=\"https://profiles.wordpress.org/christopherplus/\">Christopher</a> · <a href=\"https://profiles.wordpress.org/chrystl/\">Chrystl</a> · <a href=\"https://profiles.wordpress.org/codepo8/\">codepo8</a> · <a href=\"https://profiles.wordpress.org/cdevroe/\">Colin Devroe</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/cookiesfordevo/\">CookiesForDevo</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/creativeslice/\">Creative Slice</a> · <a href=\"https://profiles.wordpress.org/crstauf/\">crstauf</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cvorko/\">cvorko</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/cyberchicken/\">Cyberchicken</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dansoschin/\">Dan Soschin</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/mzaweb/\">Daniel Dvorkin</a> · <a href=\"https://profiles.wordpress.org/mapumba/\">Daniel Käfer</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/schutzsmith/\">Daniel Schutzsmith</a> · <a href=\"https://profiles.wordpress.org/danieldudzic/\">danieldudzic</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danieltj/\">danieltj</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/darssen/\">darssen</a> · <a href=\"https://profiles.wordpress.org/davecpage/\">Dave Page</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/dglingren/\">David Lingren</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/dionysous/\">Dennis Hipp</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/derekblank/\">Derek Blank</a> · <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a> · <a href=\"https://profiles.wordpress.org/derekspringer/\">Derek Springer</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/desrosjbot/\">Desrosj Bot</a> · <a href=\"https://profiles.wordpress.org/dernin/\">Devin Curtis</a> · <a href=\"https://profiles.wordpress.org/dlocc/\">Devin Walker</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dougal/\">Dougal Campbell</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/lots0logs/\">Dustin Falgout</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/ehtis/\">Ehtisham Siddiqui</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emirpprime/\">emirpprime</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/endymion00/\">Endymion00</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/enwikuna/\">Enwikuna</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/evanltd/\">evanltd</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisalahmed29/\">Faisal Ahmed</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fanly/\">Fanly</a> · <a href=\"https://profiles.wordpress.org/feastdesignco/\">Feast Design Co.</a> · <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/flhz/\">Florent Hernandez</a> · <a href=\"https://profiles.wordpress.org/fgiannar/\">Foteini Giannaropoulou (a11n)</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/francescocarlucci/\">FrancescoCarlucci</a> · <a href=\"https://profiles.wordpress.org/fotodrachen/\">Frank Jäger</a> · <a href=\"https://profiles.wordpress.org/nexflaszlo/\">Frank Laszlo</a> · <a href=\"https://profiles.wordpress.org/wazeter/\">Frank Wazeter</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garibiza/\">Garbiñe</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gavande1/\">gavande1</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/gerardreches/\">Gerard Reches</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuseppemazzapica-1/\">Giuseppe Mazzapica</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/goldenapples/\">goldenapples</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/poran766/\">H.M. Mushfiqur Rahman</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hztyfoon/\">Hanzala Taifun</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harsh175/\">Harsh Patel</a> · <a href=\"https://profiles.wordpress.org/hasanuzzamanshamim/\">Hasanuzzaman Shamim</a> · <a href=\"https://profiles.wordpress.org/halounsbury/\">Heather Wilkins</a> · <a href=\"https://profiles.wordpress.org/muhme/\">Heiko Lübbe</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/tejwanihemant/\">Hemant Tejwani</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/howdy_mcgee/\">Howdy_McGee</a> · <a href=\"https://profiles.wordpress.org/hrrarya/\">Hridoy Mozumder</a> · <a href=\"https://profiles.wordpress.org/hrithikd/\">Hrithik Dalal</a> · <a href=\"https://profiles.wordpress.org/hlashbrooke/\">Hugh Lashbrooke</a> · <a href=\"https://profiles.wordpress.org/ganon/\">Hugo Chinchilla</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/idad5/\">idad5</a> · <a href=\"https://profiles.wordpress.org/igmoweb/\">Ignacio Cruz Moreno</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/shaampk1/\">Ihtisham Zahoor</a> · <a href=\"https://profiles.wordpress.org/fnpen/\">Ilya Zolotov</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itecrs/\">itecrs</a> · <a href=\"https://profiles.wordpress.org/ivanzhuck/\">Ivan Zhuck</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jadpm/\">jadpm</a> · <a href=\"https://profiles.wordpress.org/jamescollins/\">James Collins</a> · <a href=\"https://profiles.wordpress.org/macmanx/\">James Huff</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/james roberts/\">James Roberts</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/perrelet/\">Jamie Perrelet</a> · <a href=\"https://profiles.wordpress.org/jane/\">jane</a> · <a href=\"https://profiles.wordpress.org/whiteshadow/\">Janis Elsts</a> · <a href=\"https://profiles.wordpress.org/jsandtro/\">jansan</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a> · <a href=\"https://profiles.wordpress.org/japh/\">Japh</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarednova/\">jarednova</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/pbking/\">Jason Crist</a> · <a href=\"https://profiles.wordpress.org/coolmann/\">Jason Crouse</a> · <a href=\"https://profiles.wordpress.org/jsnjohnston/\">Jason Johnston</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/jbobich/\">jbobich</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/amieiro/\">Jesús Amieiro</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jghazally/\">jghazally</a> · <a href=\"https://profiles.wordpress.org/jipmoors/\">Jip Moors</a> · <a href=\"https://profiles.wordpress.org/jivygraphics/\">jivygraphics</a> · <a href=\"https://profiles.wordpress.org/jltallon/\">jltallon</a> · <a href=\"https://profiles.wordpress.org/joanrodas/\">Joan</a> · <a href=\"https://profiles.wordpress.org/morehawes/\">Joe</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joelcj91/\">Joel James</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnciacia/\">johnciacia</a> · <a href=\"https://profiles.wordpress.org/jb510/\">Jon Brown</a> · <a href=\"https://profiles.wordpress.org/duck_/\">Jon Cave</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jbrinley/\">Jonathan Brinley</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/joppuyo/\">joppuyo</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/jorgevilchez/\">Jorge Vilchez</a> · <a href=\"https://profiles.wordpress.org/jornp/\">jornp</a> · <a href=\"https://profiles.wordpress.org/joefusco/\">Joseph Fusco</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/joshcanhelp/\">joshcanhelp</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/joshuatf/\">joshuatf</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a> · <a href=\"https://profiles.wordpress.org/jsmoriss/\">JS Morisset</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juhise/\">Juhi Saxena</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/ashikur698/\">K M Ashikur Rahman</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/bosskhj/\">Kamrul Hasan</a> · <a href=\"https://profiles.wordpress.org/karinclimber/\">Kari Anderson</a> · <a href=\"https://profiles.wordpress.org/karlijnbk/\">Karlijn Bok</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/tadamarketing/\">Katka</a> · <a href=\"https://profiles.wordpress.org/kawsaralameven/\">kawsaralameven</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kbat82/\">Kevin Batdorf</a> · <a href=\"https://profiles.wordpress.org/kevincoleman/\">Kevin Coleman</a> · <a href=\"https://profiles.wordpress.org/kevinwhoffman/\">Kevin Hoffman</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/koen12344/\">Koen Reus</a> · <a href=\"https://profiles.wordpress.org/koesper/\">Koesper</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/kdowns/\">Kylen Downs</a> · <a href=\"https://profiles.wordpress.org/laumindproductscomau/\">lau@mindproducts.com.au</a> · <a href=\"https://profiles.wordpress.org/lada7042/\">Laura Adamonis</a> · <a href=\"https://profiles.wordpress.org/laurlittle/\">Lauren Stein</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/munizleo/\">Leo Muniz</a> · <a href=\"https://profiles.wordpress.org/leonnugraha/\">Leonardus Nugraha</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/liammcarthur/\">LiamMcArthur</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a> · <a href=\"https://profiles.wordpress.org/logikal16/\">logikal16</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/luboslives/\">luboslives</a> · <a href=\"https://profiles.wordpress.org/lucasbustamante/\">lucasbustamante</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">Luis Herranz</a> · <a href=\"https://profiles.wordpress.org/lpawlik/\">Lukas Pawlik</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukefiretoss/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maartenbelmans/\">Maarten</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/mrdollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mhimon/\">Mahbub Hasan Imon</a> · <a href=\"https://profiles.wordpress.org/mahnewr/\">mahnewr</a> · <a href=\"https://profiles.wordpress.org/maahrokh/\">Mahrokh</a> · <a href=\"https://profiles.wordpress.org/malae/\">Malae</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manyourisms/\">manyourisms</a> · <a href=\"https://profiles.wordpress.org/marc_j/\">Marc_J</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/marcoevich/\">Marcoevich</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/chaton666/\">Marie Comet</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markjaquith/\">Mark Jaquith</a> · <a href=\"https://profiles.wordpress.org/markoheijnen/\">Marko Heijnen</a> · <a href=\"https://profiles.wordpress.org/markoserb/\">Marko Ivanovic</a> · <a href=\"https://profiles.wordpress.org/flootr/\">Markus</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/mathewemoore/\">mathewemoore</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matiasrecondo77/\">matiasrecondo77</a> · <a href=\"https://profiles.wordpress.org/webdevmattcrom/\">Matt Cromwell</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/cadic/\">Max Lyuchin</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/hrshahin/\">Md HR Shahin</a> · <a href=\"https://profiles.wordpress.org/devsahadat/\">Md Sahadat Husain</a> · <a href=\"https://profiles.wordpress.org/megphillips91/\">Meg Phillips</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/melcarthus/\">melcarthus</a> · <a href=\"https://profiles.wordpress.org/meta4/\">meta4</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/254volkan/\">mevolkan</a> · <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a> · <a href=\"https://profiles.wordpress.org/mshowes/\">Michael Showes</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michalooki/\">Michalooki</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/miguelsansegundo/\">miguelsansegundo</a> · <a href=\"https://profiles.wordpress.org/miikkamakela/\">Miikka</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley (a11n)</a> · <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel</a> · <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/gonzomir/\">Milen Petrinski – Gonzo</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/illuminea/\">Miriam Schwab</a> · <a href=\"https://profiles.wordpress.org/mkismy/\">mkismy</a> · <a href=\"https://profiles.wordpress.org/mnydigital/\">mnydigital</a> · <a href=\"https://profiles.wordpress.org/batmoo/\">Mohammad Jangda</a> · <a href=\"https://profiles.wordpress.org/boemedia/\">Monique Dubbelman</a> · <a href=\"https://profiles.wordpress.org/monzuralam/\">Monzur Alam</a> · <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/seusmaniqbal/\">Muhammad Usman Iqbal</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/tanjimtc71/\">Musarrat Anjum Chowdhury</a> · <a href=\"https://profiles.wordpress.org/nahidkhanseo/\">Nahid Khan</a> · <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a> · <a href=\"https://profiles.wordpress.org/navjotjsingh/\">Navjot Singh</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/neffff/\">neffff</a> · <a href=\"https://profiles.wordpress.org/neilorangepeel/\">Neil Hainsworth</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/nerdpressteam/\">NerdPress</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/sessioncookiemonster/\">Nick Martianov</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/bgnicolepaschen/\">Nicole Paschen Caylor</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nko/\">Nikita</a> · <a href=\"https://profiles.wordpress.org/nikmeyer/\">nikmeyer</a> · <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a> · <a href=\"https://profiles.wordpress.org/nilovelez/\">Nilo Velez</a> · <a href=\"https://profiles.wordpress.org/dhrupo/\">Niluthpal Purkayastha</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/nvwd/\">Nowell VanHoesen</a> · <a href=\"https://profiles.wordpress.org/nudge/\">Nudge Themes</a> · <a href=\"https://profiles.wordpress.org/nwjames/\">nwjames</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/ockham/\">ockham</a> · <a href=\"https://profiles.wordpress.org/oguzkocer/\">oguzkocer</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/dargus/\">Old account</a> · <a href=\"https://profiles.wordpress.org/olegfuture/\">olegfuture</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pacicio/\">Pacicio</a> · <a href=\"https://profiles.wordpress.org/pannelars/\">pannelars</a> · <a href=\"https://profiles.wordpress.org/partyfrikadelle/\">partyfrikadelle</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/pauldewouters/\">Paul de Wouters</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/djpaul/\">Paul Wong-Gibbs</a> · <a href=\"https://profiles.wordpress.org/pavelevap/\">pavelevap</a> · <a href=\"https://profiles.wordpress.org/pbaylies/\">Peter Baylies</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philipp15b/\">Philipp15b</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/mordauk/\">Pippin Williamson</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pmeenan/\">pmeenan</a> · <a href=\"https://profiles.wordpress.org/webtechpooja/\">Pooja Derashri</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/pouicpouic/\">pouicpouic</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/freewebmentor/\">Prem Tiwari</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">presstoke</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiq</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/rashiguptaa/\">Rashi Gupta</a> · <a href=\"https://profiles.wordpress.org/ratneshsonar/\">Ratnesh Sonar</a> · <a href=\"https://profiles.wordpress.org/rawrly/\">rawrly</a> · <a href=\"https://profiles.wordpress.org/rcain/\">rcain</a> · <a href=\"https://profiles.wordpress.org/rebasaurus/\">rebasaurus</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/renehermi/\">Rene Hermenau</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/rdcoll/\">Rich Collier</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/ravanh/\">Rolf Allard van Hagen</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/pogidude/\">Ryann Micua</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sereedmedia/\">Sé Reed</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sabbirshouvo/\">Sabbir Hasan</a> · <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">Sachyya</a> · <a href=\"https://profiles.wordpress.org/sadizaman/\">Sadi Mohammad Zaman</a> · <a href=\"https://profiles.wordpress.org/sadpencil/\">sadpencil</a> · <a href=\"https://profiles.wordpress.org/introvertedbot/\">Sahil</a> · <a href=\"https://profiles.wordpress.org/tohincoderex/\">Saiduzzaman Tohin</a> · <a href=\"https://profiles.wordpress.org/sakibsnaz/\">Sakib MD Nazmush</a> · <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a> · <a href=\"https://profiles.wordpress.org/xronn/\">Sam Berry</a> · <a href=\"https://profiles.wordpress.org/samba45/\">samba45</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/kim88/\">Samuel Rüegger</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sacerro/\">Santiago Cerro López</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/hellosatya/\">Satyam Vishwakarma (Satya)</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/saxonfletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayful/\">Sayful Islam</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sgr33n/\">Sergio De Falco</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shahariaazam/\">Shaharia Azam</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/shanef/\">ShaneF</a> · <a href=\"https://profiles.wordpress.org/cafenoirdesign/\">Shannon Smith</a> · <a href=\"https://profiles.wordpress.org/shaunandrews/\">shaunandrews</a> · <a href=\"https://profiles.wordpress.org/shooper/\">Shawn Hooper</a> · <a href=\"https://profiles.wordpress.org/shidouhikari/\">shidouhikari</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreyash3087/\">Shreyash Srivastava</a> · <a href=\"https://profiles.wordpress.org/shubhamsedani/\">Shubham Sedani</a> · <a href=\"https://profiles.wordpress.org/rsiddharth/\">siddharth ravikumar</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/sirajummahdi/\">Sirajum Mahdi</a> · <a href=\"https://profiles.wordpress.org/sjregan/\">sjregan</a> · <a href=\"https://profiles.wordpress.org/virtality-marketing-solutions/\">SourceView</a> · <a href=\"https://profiles.wordpress.org/sruthi89/\">sruthi89</a> · <a href=\"https://profiles.wordpress.org/stacimc/\">stacimc</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephencronin/\">Stephen Cronin</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/stephenh1988/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/stevejonesdev/\">Steve Jones</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sumisubedi/\">Sumi Subedi</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/svitlana41319/\">Svitlana Sukhoveiko</a> · <a href=\"https://profiles.wordpress.org/syamraj24/\">syamraj24</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> · <a href=\"https://profiles.wordpress.org/nuhel/\">Syed Nuhel</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/sparklingrobots/\">Tara King</a> · <a href=\"https://profiles.wordpress.org/buley/\">Taylor</a> · <a href=\"https://profiles.wordpress.org/taylorde/\">Taylor Dewey</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tazotodua/\">tazotodua</a> · <a href=\"https://profiles.wordpress.org/tykoted/\">Teddy Patriarca</a> · <a href=\"https://profiles.wordpress.org/tellyworth/\">Tellyworth</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/thinkluke/\">thinkluke</a> · <a href=\"https://profiles.wordpress.org/griffinjt/\">Thomas Griffin</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/threadi/\">threadi</a> · <a href=\"https://profiles.wordpress.org/tnolte/\">Tim Nolte</a> · <a href=\"https://profiles.wordpress.org/timbroddin/\">timbroddin</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomybyte/\">Tom</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/hifidesign/\">Tom Finley</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomluckies/\">tomluckies</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/tomsommer/\">tomsommer</a> · <a href=\"https://profiles.wordpress.org/tomxygen/\">tomxygen</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/starbuck/\">Tony G</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/toru/\">Toru Miki</a> · <a href=\"https://profiles.wordpress.org/toscho/\">toscho</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/valerogarte/\">valerogarte</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vikram6/\">vikram6</a> · <a href=\"https://profiles.wordpress.org/viliamkopecky/\">viliamkopecky</a> · <a href=\"https://profiles.wordpress.org/vipuljnext/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/wasiur195/\">Wasiur Rahman</a> · <a href=\"https://profiles.wordpress.org/welaunchio/\">welaunchio</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whsajid/\">WHSajid</a> · <a href=\"https://profiles.wordpress.org/nestea29950/\">WilliamG</a> · <a href=\"https://profiles.wordpress.org/wpcorner/\">WP Corner</a> · <a href=\"https://profiles.wordpress.org/xlthlx/\">xlthlx</a> · <a href=\"https://profiles.wordpress.org/yansern/\">Yan Sern</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/tollmanz/\">Zack Tollman</a> · <a href=\"https://profiles.wordpress.org/zanematthew/\">Zane Matthew</a> · <a href=\"https://profiles.wordpress.org/zebaafiashama/\">Zeba Afia Shama</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">zieladam</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a></p>\n\n\n\n<h1 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress 6.6 en français</h1>\n\n\n\n<p>WordPress est un projet international et la version 6.6 est déjà complètement disponible dans plus de 70 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress 6.6 en français :</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/wolforg\">Didier Demory</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/amebref\">amebref</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/bonaldi\">Bonaldi</a>, <a href=\"https://profiles.wordpress.org/chris-kns\">chris-kns</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/coralietixeront\">coralietixeront</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/scoco\">Emilien M.</a>, <a href=\"https://profiles.wordpress.org/florientinneo\">Florient DELAFOY</a>, <a href=\"https://profiles.wordpress.org/gaeldenysiak\">Gael Denysiak</a>, <a href=\"https://profiles.wordpress.org/gaellebesson\">gaellebesson</a>, <a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>, <a href=\"https://profiles.wordpress.org/laeti972\">laeti972</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/nuryko\">Marianna</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/lymx\">Maxime LEROY</a>, <a href=\"https://profiles.wordpress.org/momo-fr\">momo-fr</a>, <a href=\"https://profiles.wordpress.org/nlangle\">Nicolas Langle</a>, <a href=\"https://profiles.wordpress.org/mrbalou06\">Pascal T</a>, <a href=\"https://profiles.wordpress.org/pierrelannoy\">Pierre Lannoy</a>, <a href=\"https://profiles.wordpress.org/nekojonez\">Pieterjan Deneys</a>, <a href=\"https://profiles.wordpress.org/larrach\">Rachel Peter</a>, <a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>, <a href=\"https://profiles.wordpress.org/valer1e\">Valérie Galassi</a>, <a href=\"https://profiles.wordpress.org/virgar\">Virginie Garnier</a>, et <a href=\"https://profiles.wordpress.org/whaze\">whaze</a>.</p>\n\n\n\n<p></p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3181\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"Comment contribuer aux « release parties » des nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://fr.wordpress.org/2024/07/15/comment-contribuer-aux-release-parties-des-nouvelles-versions-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 15 Jul 2024 13:28:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3159\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"Lors des phases de développement d’une nouvelle version de WordPress, il est possible d’aider à la livraison des versions bêta et release candidate de WP en participant aux « release parties », qui sont des événements planifiés à l’avance pour procéder à la construction d’une version bêta ou release candidate, ou d&#8217;une version finale, et à sa [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7155:\"\n<p>Lors des phases de développement d’une nouvelle version de WordPress, il est possible d’aider à la livraison des versions bêta et <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em> de WP en participant aux <em><bdo lang=\"en\" dir=\"ltr\">« release parties »</bdo></em>, qui sont des événements planifiés à l’avance pour procéder à la construction d’une version bêta ou release candidate, ou d&rsquo;une version finale, et à sa livraison au public.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Prérequis</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Aucun niveau technique particulier n’est nécessaire à part savoir utiliser WordPress</li>\n\n\n\n<li>Avoir un site de test installé en local ou en ligne</li>\n\n\n\n<li>Installer l’extension <em><bdo lang=\"en\" dir=\"ltr\"><a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\">Beta Tester</a></bdo></em> et la paramétrer (dans <code>Outils &gt; Test Bêta</code>) de la façon suivante (ici nous sommes sur une installation en anglais, si vous êtes sur une installation en français, faites la correspondance des options)&nbsp;:</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"427\" src=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1024x427.png\" alt=\"\" class=\"wp-image-3160\" srcset=\"https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1024x427.png 1024w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-300x125.png 300w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-768x320.png 768w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-1536x641.png 1536w, https://fr.wordpress.org/files/2024/07/reglages-beta-tester-2048x854.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p><em><bdo lang=\"en\" dir=\"ltr\">Bleeding edge</bdo></em> : version en cours de développement. Cette version utilise le code en cours de développement (<em><bdo lang=\"en\" dir=\"ltr\">Bleeding edge nightlies</bdo></em>) qui peut parfois être instable. <em>Ne l’utilisez en production que si vous savez vraiment ce que vous faites</em>.</p>\n\n\n\n<p><em><bdo lang=\"en\" dir=\"ltr\">Bêta/RC only </bdo></em>: ceci concerne uniquement les versions bêta/RC du canal sélectionné.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Déroulement de la <em><bdo lang=\"en\" dir=\"ltr\">release party</bdo></em></h2>\n\n\n\n<p>Les <em><bdo lang=\"en\" dir=\"ltr\">release parties</bdo></em> se déroulent entièrement sur le Slack <a href=\"http://Make.WordPress.org\">Make.WordPress.org</a>, sur le canal #core. Pour le rejoindre utilisez votre nom de compte WordPress.org, ici : <a href=\"https://make.wordpress.org/chat/\">https://make.wordpress.org/chat/</a>.</p>\n\n\n\n<p>Généralement, il y en a pour 30-40 minutes si c’est une version beta/RC.</p>\n\n\n\n<p>Normalement les <em><bdo lang=\"en\" dir=\"ltr\">release parties</bdo></em> commencent à peu près à l’heure, souvent en fin d’après midi. Voici le déroulement :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Message d’accueil de la personne qui dirige la <bdo lang=\"en\" dir=\"ltr\"><em>release party</em></bdo>, tout le monde fait coucou et ça permet de consigner le nombre de contributrices et contributeurs qui participent à la <em><bdo lang=\"en\" dir=\"ltr\">release</bdo></em></li>\n\n\n\n<li>Quelques<bdo lang=\"en\" dir=\"ltr\"> vérificatio</bdo>ns techniques entre le ou la <em><bdo lang=\"en\" dir=\"ltr\">lead</bdo></em>, la personne faisant office de <em><bdo lang=\"en\" dir=\"ltr\">committer</bdo></em> (qui va créer la version de WordPress concernée) et le contrôle de mission (<em><bdo lang=\"en\" dir=\"ltr\">mission control</bdo></em>, qui est chargé de construire le paquet ZIP de la version), ça peut prendre 10-15 minutes mais c’est souvent moins.</li>\n\n\n\n<li>Les checks de sécurité et les tests unitaires sont lancés par la personne chargée des <em><bdo lang=\"en\" dir=\"ltr\">commits</bdo></em> et le contrôle de mission</li>\n\n\n\n<li>Le ou la <em><bdo lang=\"en\" dir=\"ltr\">core committer</bdo></em> fait un premier <bdo lang=\"en\" dir=\"ltr\"><em>commit</em></bdo> de version</li>\n\n\n\n<li>Le contrôle de mission livre un premier ZIP de la version</li>\n\n\n\n<li>C’EST LÀ QUE VOUS INTERVENEZ ! Vous pouvez&nbsp;:\n<ul class=\"wp-block-list\">\n<li>(plus long) Récupérer le ZIP et l’installer en local</li>\n\n\n\n<li>(plus rapide mais plus technique) Installer la version via <em>WP-CLI</em></li>\n\n\n\n<li>(recommandé) Via Beta Tester :\n<ul class=\"wp-block-list\">\n<li>Aller sur une installation avec l’extension WP Beta Tester installée, paramétrée comme expliqué ci-dessus</li>\n\n\n\n<li>Normalement, au bout de quelques secondes après que le ZIP soit disponible, vous devriez voir un petit message sur l’écran d’accueil de l’admin indiquant qu’une nouvelle version est disponible pour test</li>\n\n\n\n<li>Pensez à noter le numéro de version de WP que vous aviez avant de mettre à jour !</li>\n\n\n\n<li>Cliquez sur le lien de mise à jour et installez la version</li>\n</ul>\n</li>\n</ul>\n</li>\n\n\n\n<li>Les choses que vous pouvez tester :\n<ul class=\"wp-block-list\">\n<li>Fonctionnement de quelques écrans de l’admin</li>\n\n\n\n<li>Bon fonctionnement de l’éditeur : insertion d’un bloc, enregistrement d’un article</li>\n\n\n\n<li>Bon fonctionnement de l’éditeur de site (navigation dans quelques écrans)</li>\n\n\n\n<li>Bon fonctionnement de quelques écrans du front</li>\n\n\n\n<li>Bon fonctionnement de l&rsquo;éditeur après installation d&rsquo;un thème classique</li>\n\n\n\n<li>Bon fonctionnement de l&rsquo;éditeur après installation de l&rsquo;extension <em><bdo lang=\"en\" dir=\"ltr\"><a href=\"https://fr.wordpress.org/plugins/classic-editor/\">Classic Editor</a></bdo></em></li>\n\n\n\n<li>Si vous disposez d&rsquo;une instance multisite, mentionnez-le</li>\n\n\n\n<li>Si vous avez les moyens de tester la mise à jour depuis une vieille version de WP (version 4.9 ou au dessus), c&rsquo;est très utile aussi. Mentionnez la version depuis laquelle vous avez fait la mise à jour</li>\n</ul>\n</li>\n\n\n\n<li>Une fois que vous avez testé, mettez un petit message dans le canal #core, en indiquant la version que vous aviez avant la <abbr title=\"Mise à jour\">MAJ</abbr> et la version vers laquelle vous avez mis à jour. Par exemple :</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full is-resized\"><a href=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png\"><img loading=\"lazy\" decoding=\"async\" width=\"706\" height=\"806\" src=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png\" alt=\"\" class=\"wp-image-3161\" style=\"width:400px\" srcset=\"https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10.png 706w, https://fr.wordpress.org/files/2024/07/Capture-decran-2024-03-05-a-10.42.10-263x300.png 263w\" sizes=\"auto, (max-width: 706px) 100vw, 706px\" /></a></figure>\n\n\n\n<p>Vous pourrez ensuite suivre le reste de la <em><bdo lang=\"en\" dir=\"ltr\">release party</bdo></em> tranquillement.</p>\n\n\n\n<p>Et vous serez aussi crédité·es pour votre participation à cette version. Bravo&nbsp;!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3159\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/06/27/guide-des-changements-techniques-de-wordpress-6-6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Jun 2024 08:36:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3125\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:140:\"Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress 6.6, dont la sortie est prévue le 16 juillet 2024.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:33232:\"\n<figure class=\"wp-block-image alignfull size-large\"><a href=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"548\" src=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1024x548.png\" alt=\"\" class=\"wp-image-3134\" srcset=\"https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1024x548.png 1024w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-300x160.png 300w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-768x411.png 768w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-1536x821.png 1536w, https://fr.wordpress.org/files/2024/06/WP-66-guide-changements-techniques-min-2048x1095.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p class=\"is-style-serif has-blueberry-4-background-color has-background\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.6, dont la sortie est prévue le 16 juillet 2024.</p>\n\n\n\n<p>WordPress 6.6 comprend au minimum la résolution de <a href=\"https://core.trac.wordpress.org/query?resolution=fixed&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;order=type\" target=\"_blank\" rel=\"noreferrer noopener\">299 tickets Trac</a>, dont <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.6&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">108 améliorations et nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.5&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">171 résolutions de bogues</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.6&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">10 autres tâches de maintenance</a>. Pour cette version, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">16 tickets étaient centrés sur les performances</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">24 sur l&rsquo;accessibilité</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=focuses&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\" target=\"_blank\" rel=\"noreferrer noopener\">15 tickets portaient sur la modernisation du code source de notre CMS</a>. Les modifications de WP&nbsp;6.6 concernent <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.6&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">40 composants du code source de WordPress</a>.</p>\n\n\n\n<p>Cette version comprend aussi 392 améliorations, 462 corrections de bogues et 46 améliorations de l&rsquo;accessibilité de <a href=\"https://github.com/WordPress/gutenberg/commits/wp/6.6\">l&rsquo;éditeur de blocs</a> (Gutenberg).</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p>Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.6, consultez cette page : <a href=\"https://make.wordpress.org/core/6-5/\">https://make.wordpress.org/core/6-5/</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"Block-Editor\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>WordPress 6.6 implémente 8 versions de Gutenberg &#8211; <a href=\"https://make.wordpress.org/core/2024/02/28/whats-new-in-gutenberg-17-8-28-february/\">17.8</a>, <a href=\"https://make.wordpress.org/core/2024/03/13/whats-new-in-gutenberg-17-9-13-march/\">17.9</a>, <a href=\"https://make.wordpress.org/core/2024/03/27/whats-new-in-gutenberg-18-0-27-march/\">18.0</a>, <a href=\"https://make.wordpress.org/core/2024/04/10/whats-new-in-gutenberg-18-1-10-april/\">18.1</a>, <a href=\"https://make.wordpress.org/core/2024/04/24/whats-new-in-gutenberg-18-2-24-april/\">18.2</a>, <a href=\"https://make.wordpress.org/core/2024/05/08/whats-new-in-gutenberg-18-3-8-may/\">18.3</a>, <a href=\"https://make.wordpress.org/core/2024/05/23/whats-new-in-gutenberg-18-4-22-may/\">18.4</a> et <a href=\"https://make.wordpress.org/core/2024/06/09/what-is-new-in-gutenberg-18-5-05-jun/\">18.5</a>. L&rsquo;éditeur de blocs reçoit ainsi de nombreuses améliorations liées à la bibliothèque React, à l’API <code>Block</code>, à la gestion des thèmes, et bien plus encore.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"react\">React</h3>\n\n\n\n<p>Une nouvelle version de React et la nouvelle <a href=\"https://legacy.reactjs.org/blog/2020/09/22/introducing-the-new-jsx-transform.html\">API JSX transform</a> font leur entrée dans WordPress&nbsp;6.6.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dWLxJUI3h0\"><a href=\"https://make.wordpress.org/core/2024/06/06/jsx-in-wordpress-6-6/\">JSX in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;JSX in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/06/jsx-in-wordpress-6-6/embed/#?secret=XMglYBeDLC#?secret=dWLxJUI3h0\" data-secret=\"dWLxJUI3h0\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"52Rfu8yAtE\"><a href=\"https://make.wordpress.org/core/2024/06/07/preparation-for-react-19-upgrade/\">Preparation for React 19 Upgrade</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Preparation for React 19 Upgrade&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/07/preparation-for-react-19-upgrade/embed/#?secret=YV2Zkzjfyy#?secret=52Rfu8yAtE\" data-secret=\"52Rfu8yAtE\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"block-api\">API <code>Block</code></h3>\n\n\n\n<p>Des changements arrivent sur l&rsquo;API <code>Block</code>&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Unification des API d&rsquo;extensibilité entre les éditeurs de publications et du site</li>\n\n\n\n<li>Amélioration de la propriété <code>isActive</code> sur les variations de blocs</li>\n\n\n\n<li>Améliorations de plusieurs blocs proposés par le cœur de WordPress</li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"FC595uD9El\"><a href=\"https://make.wordpress.org/core/2024/06/18/editor-unified-extensibility-apis-in-6-6/\">Editor: Unified Extensibility APIs in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Editor: Unified Extensibility APIs in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/editor-unified-extensibility-apis-in-6-6/embed/#?secret=d9wcTgYeLu#?secret=FC595uD9El\" data-secret=\"FC595uD9El\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"vsiCQ8RUpF\"><a href=\"https://make.wordpress.org/core/2024/06/18/improvements-to-active-block-variation-detection/\">Improvements to active block variation detection</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Improvements to active block variation detection&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/improvements-to-active-block-variation-detection/embed/#?secret=BlfgJ2v86t#?secret=vsiCQ8RUpF\" data-secret=\"vsiCQ8RUpF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fcUHSrfEG8\"><a href=\"https://make.wordpress.org/core/2024/06/19/social-links-block-changes-in-wordpress-6-6/\">Social Links block changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Social Links block changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/19/social-links-block-changes-in-wordpress-6-6/embed/#?secret=KTnVlZwICZ#?secret=fcUHSrfEG8\" data-secret=\"fcUHSrfEG8\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"themes-6-6\">Thèmes</h3>\n\n\n\n<p>WordPress 6.6 introduit plusieurs mises à jour liées aux thèmes, comprenant&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Une nouvelle version 3 du <code>theme.json</code></li>\n\n\n\n<li>L&rsquo;uniformisation de la spécificité CSS appliquée aux styles du cœur de WP</li>\n\n\n\n<li>Introduction de la section «&nbsp;styles&nbsp;» pour améliorer l&rsquo;efficacité de la personnalisation des blocs et de leurs éléments internes</li>\n\n\n\n<li>Fonctionnalités additionnelles de la mise en page en grille dans les blocs</li>\n\n\n\n<li>Capacité de définir des images d&rsquo;arrière-plan pour l&rsquo;ensemble du site via le <code>theme.json</code> et via l’éditeur de site</li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"3qkQI6VB3V\"><a href=\"https://make.wordpress.org/core/2024/06/19/theme-json-version-3/\">Theme.json version 3</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Theme.json version 3&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/19/theme-json-version-3/embed/#?secret=qFVVO9yctD#?secret=3qkQI6VB3V\" data-secret=\"3qkQI6VB3V\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"WwNatJ4yuP\"><a href=\"https://make.wordpress.org/core/2024/06/24/section-styles/\">Section Styles</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Section Styles&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/section-styles/embed/#?secret=myss8Gv9Su#?secret=WwNatJ4yuP\" data-secret=\"WwNatJ4yuP\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"5tYWFN7C0m\"><a href=\"https://make.wordpress.org/core/2024/06/21/wordpress-6-6-css-specificity/\">WordPress 6.6 CSS Specificity</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.6 CSS Specificity&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/21/wordpress-6-6-css-specificity/embed/#?secret=0Ak975GLQd#?secret=5tYWFN7C0m\" data-secret=\"5tYWFN7C0m\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"g0n7RPlGmY\"><a href=\"https://make.wordpress.org/core/2024/06/18/grid-layout-type/\">Grid layout type</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Grid layout type&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/grid-layout-type/embed/#?secret=c59OLorfmE#?secret=g0n7RPlGmY\" data-secret=\"g0n7RPlGmY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ZPfvPc14dl\"><a href=\"https://make.wordpress.org/core/2024/06/20/site-wide-background-images-in-wordpress-6-6/\">Site-wide background images in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Site-wide background images in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/20/site-wide-background-images-in-wordpress-6-6/embed/#?secret=GtFb16IOEz#?secret=ZPfvPc14dl\" data-secret=\"ZPfvPc14dl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-block-editor-changes\">Modifications diverses concernant l’éditeur</h3>\n\n\n\n<p>Plusieurs autres modifications de l’éditeur de bloc sont aussi incluses dans WordPress 6.6 :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Added-wp-block-list-class-to-the-list-block\">Ajout de la classe <code>wp-block-list</code>&nbsp;au bloc Liste</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#New-Interactivity-API-directives\">Nouvelles directives pour l&rsquo;API <code>Interactivity</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Allow-view-access-of-the-template-REST-API-endpoint-to-anyone-with-the-edit_post-capability\">Ajout de l’accès en lecture au point de terminaison <code>template</code> de l’API REST à toute personne disposant de la permission <code>edit_post</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Unified-split-logic-for-writing-flow\">Unification de la logique de séparation dans le flux de rédaction</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#BlockPopover-Component-is-now-public\">Le composant BlockPopover est maintenant public</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Add-filter-to-modify-the-list-of-post-content-block-types\">Ajout d&rsquo;un filtre pour modifier la liste des types de blocs de contenu</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Global-Styles-Filter-out-color-and-typography-variations\">Styles globaux&nbsp;: ajout de filtres pour les variations de couleur et de typographie</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Add-custom-Aspect-Ratio-presets-through-theme-json\">Ajout de pré-réglages de proportions gérables via le fichier&nbsp;<code>theme.json</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#root-padding-style-updates\">Mise à jour des styles de marge interne racine via <code>:root</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/#Added-Text-alignment-block-support\">Ajout de la prise en charge de l&rsquo;alignement de texte des blocs</a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zwjsgiLBc3\"><a href=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/\">Miscellaneous Editor changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Editor changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/miscellaneous-editor-changes-in-wordpress-6-6/embed/#?secret=ixOVYPSn2d#?secret=zwjsgiLBc3\" data-secret=\"zwjsgiLBc3\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>Un tableau des outils de conception supportés par chaque bloc sur WordPress&nbsp;6.6 a été publié en guise de référence.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dIjJDZTSGY\"><a href=\"https://make.wordpress.org/core/2024/06/20/roster-of-design-tools-per-block-wordpress-6-6-edition/\">Roster of design tools per block (WordPress 6.6 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.6 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/20/roster-of-design-tools-per-block-wordpress-6-6-edition/embed/#?secret=xV9lWVls3h#?secret=dIjJDZTSGY\" data-secret=\"dIjJDZTSGY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"html-api\">API HTML</h2>\n\n\n\n<p>WordPress 6.6 comprend une version de maintenance de l&rsquo;API HTML. Cela inclut quelques nouvelles fonctionnalités et une amélioration majeure de l&rsquo;utilisabilité du processeur HTML. Cela poursuit les travaux d&rsquo;amélioration continue engagés depuis WP 6.5.</p>\n\n\n\n<p>Une nouvelle structure de données vient aussi avec la version 6.6&nbsp;: il s&rsquo;agit de l&rsquo;API&nbsp;<code>WP_Token_Map</code>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wuD7UIc043\"><a href=\"https://make.wordpress.org/core/2024/06/24/updates-to-the-html-api-in-6-6/\">Updates to the HTML API in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/updates-to-the-html-api-in-6-6/embed/#?secret=jA5d2tI5LY#?secret=wuD7UIc043\" data-secret=\"wuD7UIc043\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"cLzvpODa71\"><a href=\"https://make.wordpress.org/core/2024/06/24/introducing-the-token-map/\">Introducing the Token Map</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Introducing the Token Map&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/introducing-the-token-map/embed/#?secret=96WcqwTl9C#?secret=cLzvpODa71\" data-secret=\"cLzvpODa71\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"options-api\">API <code>Options</code></h2>\n\n\n\n<p>Plusieurs modifications ont été faites sur l&rsquo;API <code>Options</code> pour prendre en charge une optimisation du comportement de chargement automatique et pour créer une façon d’appliquer les prochaines optimisations à venir.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"sY4OPd8z50\"><a href=\"https://make.wordpress.org/core/2024/06/18/options-api-disabling-autoload-for-large-options/\">Options API: Disabling autoload for large options</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Options API: Disabling autoload for large options&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/18/options-api-disabling-autoload-for-large-options/embed/#?secret=Fd1Vmk80wn#?secret=sY4OPd8z50\" data-secret=\"sY4OPd8z50\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h2>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/query?component=I18N&amp;milestone=6.5&amp;&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Plusieurs améliorations de l&rsquo;internationalisation</a> ont été intégrées dans WP&nbsp;6.6&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#Enhanced-support-for-only-using-PHP-translation-files\">Amélioration de la prise en charge des fichiers de traduction PHP</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#New-lang_dir_for_domain-filter\">Nouveau filtre&nbsp;<code>lang_dir_for_domain</code></a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6#Additional-context-for-the-load_translation_file-filter\">Ajout d&rsquo;un contexte pour le filtre <code>load_translation_file</code></a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"MSrk50CwxF\"><a href=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6/\">Internationalization improvements in 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/24/i18n-improvements-6-6/embed/#?secret=3bBLcbcQOl#?secret=MSrk50CwxF\" data-secret=\"MSrk50CwxF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#allowed-disabling-autosave-support-for-individual-post-types\">Désactivation de la sauvegarde automatique indépendamment pour chaque type de publication</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#default-length-of-time-for-comment-author-cookies-has-changed\">Modification de la durée native de conservation des cookies de commentaires</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#site-editor-patterns-on-classic-themes\">Prise en charge des compositions de l’éditeur de site dans les thèmes classiques</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#fluid-typography\">Prise en charge des polices fluides</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#jquery-ui-library-update\">Mise à jour de la bibliothèque jQuery UI</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#new-array-arguments-for-wp-login-form\">Nouveaux paramètres pour la fonction for wp_login_form()</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#custom-ports-for-multisite-site-addresses\">Ports personnalisés pour les adresses des sites d&rsquo;un multisite</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#update-enabled-mime-types-for-new-multisite-installs\">Mise à jour des types MIME activés pour les nouvelles installations multisite</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#obsolete-polyfills-dependencies-have-been-removed\">Suppression des dépendances polyfill obsolètes</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#script-modules-can-now-be-used-in-the-wordpress-admin\">Les modules de Script peuvent maintenant être utilisés sur l&rsquo;administration</a></li>\n\n\n\n<li><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/#search-has-a-much-later-priority\">Mise en place d&rsquo;une priorité moins importante sur le composant de recherche de la barre d&rsquo;administration</a></li>\n</ul>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"q0i57KuxlF\"><a href=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/\">Miscellaneous developer changes in WordPress 6.6</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous developer changes in WordPress 6.6&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/06/25/miscellaneous-developer-changes-in-wordpress-6-6/embed/#?secret=q70OxXcdsS#?secret=q0i57KuxlF\" data-secret=\"q0i57KuxlF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.6 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.6.0/\">https://developer.wordpress.org/reference/since/6.6.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-9bd75783906267b91255ee59d7f76693\" style=\"background:linear-gradient(135deg,rgb(189,21,50) 0%,rgb(248,68,11) 100%)\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements. Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/06/wordpress-6-6-rc1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em>&nbsp;de WordPress 6.6</a>.&nbsp;<br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/16.0.1/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/06/25/wordpress-6-6-field-guide/\"><em><bdo lang=\"en\" dir=\"ltr\">Field Guide</bdo></em> de WP 6.6</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Bénard</a>, <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl</a>, <a href=\"https://profiles.wordpress.org/juliobox/\">Julio</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny</a>, <a href=\"https://profiles.wordpress.org/clementpolito/\">Clément</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3125\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fr.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096031\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 09 Sep 2025 10:13:02 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Fri, 11 Jul 2025 09:26:12 GMT\";s:4:\"link\";s:61:\"<https://fr.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1753188033;s:21:\"cache_expiration_time\";i:1757455982;s:23:\"__cache_expiration_time\";i:1757455982;}", "off");
INSERT INTO `cupoptions` VALUES("4008", "_transient_timeout_feed_b0b1001e5bc3fbacad8b49ec075d19a5", "1757455982", "off");
INSERT INTO `cupoptions` VALUES("4009", "_transient_feed_b0b1001e5bc3fbacad8b49ec075d19a5", "a:6:{s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"feed\";a:1:{i:0;a:6:{s:4:\"data\";s:126:\"\n    \n    \n    \n    \n    \n    \n\n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"subtitle\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:43:\"https://fluxplanet.wpfr.net/feed/wp-planet/\";s:3:\"rel\";s:4:\"self\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://fluxplanet.wpfr.net/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2025-09-09T10:12:34+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"\n        WP RSS Aggregator\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"uri\";s:27:\"https://wprssaggregator.com\";s:7:\"version\";s:7:\"4.23.13\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"entry\";a:10:{i:0;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://beapi.fr/blog/exploiter-un-reseau-multisite-wordpress-au-quotidien/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"Exploiter un réseau multisite WordPress au quotidien\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:75:\"https://beapi.fr/blog/exploiter-un-reseau-multisite-wordpress-au-quotidien/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-09-08T12:12:24.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-09-08T12:12:24.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:407:\"Vous avez activé le mode multisite sur WordPress ? Bravo ! Mais ce n’est que le début : une fois la structure en place, encore faut-il savoir la piloter au quotidien. Dans ce second article, on entre dans le concret : gestion du réseau, création de sites, attribution des rôles, mutualisation des thèmes et des […]\nThe post Exploiter un réseau multisite WordPress au quotidien appeared first on .\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:12756:\"\n        \n<p>Vous avez activé le mode multisite sur WordPress ? Bravo ! Mais ce n’est que le début : une fois la structure en place, encore faut-il savoir la piloter au quotidien.</p>\n\n\n\n<p>Dans ce second article, on entre dans le concret : gestion du réseau, création de sites, attribution des rôles, mutualisation des thèmes et des extensions, mapping de domaines, optimisation des performances, sécurité… Autant de sujets à maîtriser pour tirer pleinement parti de cette architecture.</p>\n\n\n\n<p>🔗 <em><a href=\"https://beapi.fr/blog/comprendre-et-activer-le-multisite-wordpress/\">Vous n’avez pas lu le premier article ? Commencez par le guide d’activation.</a></em></p>\n\n\n\n<h2 class=\"wp-block-heading\">Gérer un multisite WordPress</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Interface d&rsquo;administration du réseau</h3>\n\n\n\n<p>Une fois le multisite activé, vous disposez de nouveaux outils de gestion pour administrer efficacement votre réseau de sites. L&rsquo;interface d&rsquo;administration du multisite se divise en plusieurs sections clés :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Tableau de bord du réseau</strong> (vue d&rsquo;ensemble, statistiques globales du réseau, mises à jour disponibles)</li>\n\n\n\n<li><strong>Sites</strong> (liste complète des sites du réseau, création ou suppression, activation/désactivation des sites)</li>\n\n\n\n<li><strong>Utilisateurs</strong> (Gestion centralisée des comptes utilisateurs, attribution des rôles par site, suppression d&rsquo;utilisateurs du réseau)</li>\n\n\n\n<li><strong>Thèmes</strong> (Activation/désactivation des thèmes pour tout le réseau, installation de nouveaux thèmes, gestion des thèmes disponibles par site)</li>\n\n\n\n<li><strong>Extensions</strong> (Gestion des extensions pour tout le réseau, contrôle des extensions disponibles)</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Création de nouveaux sites</h3>\n\n\n\n<p>Pour ajouter un site à votre réseau :</p>\n\n\n\n<p>1. Allez dans <strong>Réseau &gt; Sites &gt; Ajouter</strong></p>\n\n\n\n<p>2. Renseignez les informations du site :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Adresse du site</strong> : sous-domaine ou sous-répertoire</li>\n\n\n\n<li><strong>Titre du site</strong> : nom affiché du site</li>\n\n\n\n<li><strong>Adresse email de l&rsquo;administrateur</strong> : compte qui gérera ce site</li>\n</ul>\n\n\n\n<p>Le nouveau site est immédiatement accessible et son administrateur reçoit un email de notification avec ses identifiants.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Gestion des utilisateurs et des rôles</h3>\n\n\n\n<p>Le multisite WordPress introduit une hiérarchie de rôles spécifique :</p>\n\n\n\n<figure class=\"wp-block-table\"><table class=\"has-fixed-layout\"><tbody><tr><td><strong>Rôles</strong></td><td><strong>Permissions</strong></td></tr><tr><td><strong>Super-administrateur</strong></td><td>Contrôle total du réseau : création/suppression de sites, gestion des utilisateurs, installation de thèmes/extensions</td></tr><tr><td><strong>Administrateur de site</strong></td><td>Administration complète d&rsquo;un site spécifique : contenu, utilisateurs, thèmes autorisés, extensions</td></tr><tr><td><strong>Autres rôles </strong></td><td>Éditeur, Auteur, Contributeur, Abonné conservent leurs permissions habituelles mais limitées à leur(s) site(s)</td></tr></tbody></table></figure>\n\n\n\n<h4 class=\"wp-block-heading\">Bonnes pratiques pour la gestion des utilisateurs :</h4>\n\n\n\n<p>✅ <strong>Limitez le nombre de super-administrateurs</strong> : N&rsquo;accordez ce rôle qu&rsquo;aux personnes ayant réellement besoin de gérer l&rsquo;ensemble du réseau</p>\n\n\n\n<p>✅ <strong>Utilisez des comptes utilisateurs partagés</strong> : Un même utilisateur peut avoir différents rôles sur différents sites du réseau</p>\n\n\n\n<h3 class=\"wp-block-heading\">Gestion des thèmes et extensions</h3>\n\n\n\n<h4 class=\"wp-block-heading\">Thèmes :</h4>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Seuls les super-administrateurs peuvent installer de nouveaux thèmes</li>\n\n\n\n<li>Les thèmes doivent être « activés pour le réseau » avant d&rsquo;être utilisables</li>\n\n\n\n<li>Chaque site peut choisir parmi les thèmes autorisés par le super-administrateur</li>\n</ul>\n\n\n\n<h4 class=\"wp-block-heading\">Extensions :</h4>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Deux types d&rsquo;activation : « Réseau » (tous les sites) ou « Site par site »</li>\n\n\n\n<li>Les extensions réseau ne peuvent être désactivées que par le super-administrateur</li>\n\n\n\n<li>Certaines extensions sont spécialement conçues pour les environnements multisite</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Peut-on avoir plusieurs noms de domaine dans un multisite ?</h3>\n\n\n\n<p>Oui, il est possible d&rsquo;avoir plusieurs noms de domaine dans un réseau multisite WordPress, mais cela nécessite une configuration avancée appelée <strong>domain mapping</strong>. Voici quelques solutions adaptées pour les domaines multiples :</p>\n\n\n\n<p><strong>1. Extension WordPress MU Domain Mapping</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Permet d&rsquo;associer des domaines personnalisés aux sites du réseau</li>\n\n\n\n<li>Exemple : <code>site1.monreseau.com</code> devient <code>mondomaine1.com</code></li>\n\n\n\n<li>Configuration au niveau serveur nécessaire</li>\n</ul>\n\n\n\n<p><strong>2. Extension Mercator (solution moderne)</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Alternative moderne au domain mapping classique</li>\n\n\n\n<li>Meilleure intégration avec WordPress moderne</li>\n\n\n\n<li>Gestion plus flexible des redirections</li>\n</ul>\n\n\n\n<p><strong>3. Configuration manuelle</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Modification des constantes WordPress</li>\n\n\n\n<li>Gestion des redirections au niveau serveur</li>\n\n\n\n<li>Solution pour les développeurs expérimentés</li>\n</ul>\n\n\n\n<div style=\"height:63px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Prérequis techniques pour les domaines multiples :</strong> </h4>\n\n\n\n<p>✅ <strong>Accès à la configuration DNS</strong> des domaines à mapper </p>\n\n\n\n<p>✅ <strong>Certificats SSL</strong> pour chaque domaine </p>\n\n\n\n<p>✅ <strong>Configuration serveur appropriée</strong> (Apache/Nginx) </p>\n\n\n\n<p>✅ <strong>Mise à jour des constantes WordPress</strong> dans wp-config.php</p>\n\n\n\n<div style=\"height:63px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Exemple de configuration pour domaines multiples :</strong></h4>\n\n\n\n<pre class=\"wp-block-code\"><code>// Dans wp-config.php\ndefine(\'DOMAIN_CURRENT_SITE\', \'monreseau.com\');\ndefine(\'SUBDOMAIN_INSTALL\', true);\ndefine(\'MULTISITE\', true);\n// Configuration des domaines autorisés\ndefine(\'WP_ALLOW_MULTISITE\', true);\ndefine(\'COOKIE_DOMAIN\', \'.monreseau.com\');\n\n</code></pre>\n\n\n\n<h3 class=\"wp-block-heading\">Les extensions dédiées au multisite</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong><a href=\"https://fr.wordpress.org/plugins/multisite-enhancements/\">L&rsquo;extension Multisite Enhancements</a></strong> simplifie la gestion du multisite en apportant des informations et outils pratiques</li>\n\n\n\n<li><strong>Nos extensions open-source</strong> “<a href=\"https://github.com/BeAPI/bea-content-sync-fusion\">Content Sync Fusion”</a> et ”<a href=\"https://github.com/BeAPI/multisite-shared-blocks\">Multisite Shared Block</a>” facilitent le partage de contenus</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Bonnes pratiques et points d&rsquo;attention</h2>\n\n\n\n<h3 class=\"wp-block-heading\">Sécurité du réseau multisite</h3>\n\n\n\n<p>La sécurité d&rsquo;un réseau multisite WordPress nécessite une attention particulière car une faille peut affecter tous les sites du réseau.</p>\n\n\n\n<p><strong>Mesures de sécurité essentielles :</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Limitez drastiquement le nombre de super-administrateurs</li>\n\n\n\n<li>Utilisez des mots de passe robustes et l&rsquo;authentification à deux facteurs</li>\n\n\n\n<li>Auditez régulièrement les comptes utilisateurs et leurs permissions</li>\n\n\n\n<li>Utilisez des extensions de sécurité adaptées aux multisites</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\">Optimisation des performances</h3>\n\n\n\n<p>Un réseau multisite mal optimisé peut rapidement devenir lent, en particulier lorsqu&rsquo;il contient plusieurs centaines de sites. <strong>Optimisations recommandées :</strong></p>\n\n\n\n<div style=\"height:63px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h4 class=\"wp-block-heading\">1. Cache et CDN</h4>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Utilisez un plugin de cache compatible multisite (W3 Total Cache, WP Rocket)</li>\n\n\n\n<li>Configurez un CDN pour distribuer les ressources statiques</li>\n\n\n\n<li>Implémentez la compression GZIP au niveau serveur</li>\n</ul>\n\n\n\n<div style=\"height:63px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h4 class=\"wp-block-heading\">2. Désactivation de fonctionnalités non essentielles </h4>\n\n\n\n<p>Pour prévenir d&rsquo;éventuels problèmes de performances, il est possible de désactiver certaines fonctionnalités non essentielles :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Désactiver l&rsquo;affichage des icônes des sites dans la barre d&rsquo;outils</strong>. Utiliser pour cela le filtre : <code>add_filter( \'wp_admin_bar_show_site_icons\', \'__return_false\' )</code></li>\n</ul>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Désactiver l&rsquo;affichage dans la barre d&rsquo;outils </strong>de la liste des sites auxquels l&rsquo;utilisateur a accès, si ce dernier a par exemple accès à plus de 10 sites :</li>\n</ul>\n\n\n\n<pre class=\"wp-block-code\"><code>add_action( \'admin_bar_menu\', function( $wp_admin_bar ) {\n    if ( count( $wp_admin_bar-&gt;user-&gt;blogs ) &gt; 10 ) {\n       $wp_admin_bar-&gt;user-&gt;blogs = &#091;];\n    }\n    return $wp_admin_bar;\n });</code></pre>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Remplacer la gestion native des crons WordPress </strong>par un outil plus puissant comme <a href=\"https://github.com/humanmade/Cavalcade\">Cavalcade</a> </li>\n\n\n\n<li><strong>Désactiver les crons non utilisés</strong></li>\n</ul>\n\n\n\n<div style=\"height:63px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h4 class=\"wp-block-heading\">3. Gestion des médias</h4>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Optimisez les images avant upload</li>\n\n\n\n<li>Utilisez des formats modernes (WebP, AVIF)</li>\n\n\n\n<li>Configurez le lazy loading pour les médias</li>\n\n\n\n<li>N&rsquo;uploadez pas sur chaque site les médias destinés à être partagés</li>\n</ul>\n\n\n\n<div style=\"height:63px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h4 class=\"wp-block-heading\">4. Maintenance</h4>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Optimisez régulièrement les tables de votre base de données</li>\n\n\n\n<li>Nettoyez régulièrement les anciens fichiers journaux (logs) et vérifiez que certaines extensions ne viennent pas les remplir inutilement.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Conclusion</h2>\n\n\n\n<p>Le multisite WordPress est un excellent levier pour industrialiser la gestion de plusieurs sites, à condition de poser un cadre technique solide et de le faire vivre dans la durée. Rôles et droits bien définis, outils de supervision adaptés, bonnes pratiques de performance et de sécurité… Tout cela permet de garder un réseau fluide, fiable et évolutif.</p>\n\n\n\n<p>📘 Mais ce modèle suppose un niveau élevé de standardisation. Si vos besoins incluent davantage de personnalisation ou des logiques de séparation plus poussées, d’autres approches d’usine à sites sont possibles. Elles sont décrites <a href=\"https://beapi.fr/livre-blanc-industrialisation-usine-a-sites/\">dans notre livre blanc dédié.</a></p>\n\n\n\n<div class=\"wp-block-group alignfull has-grey-100-light-gradient-background has-background is-layout-flow wp-container-core-group-is-layout-1 wp-block-group-is-layout-flow\" style=\"margin-top:var(--wp--preset--spacing--120);margin-bottom:var(--wp--preset--spacing--120)\">\n<h2 class=\"wp-block-heading has-text-align-center has-huge-font-size\" style=\"font-style:normal;font-weight:300\">Besoin d&rsquo;aide pour<span class=\"has-italic-serif\"> stabiliser ou faire évoluer</span> votre plateforme ?</h2>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-1 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://beapi.fr/contact/\">Parlons-en !</a></div>\n</div>\n</div>\n<p>The post <a href=\"https://beapi.fr/blog/exploiter-un-reseau-multisite-wordpress-au-quotidien/\">Exploiter un réseau multisite WordPress au quotidien</a> appeared first on <a href=\"https://beapi.fr\"></a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Ingrid Azéma\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://beapi.fr/blog/categories/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BeAPI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:1;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wpmarmite.com/exemple-site-web-therapeute/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"11 exemples inspirants de sites web de thérapeutes et comment créer le vôtre en un temps record\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:50:\"https://wpmarmite.com/exemple-site-web-therapeute/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-09-04T08:09:33.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-09-04T08:09:33.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:474:\"Vous êtes thérapeute, psychologue, sophrologue ou praticien du bien-être ? Vous rêvez de créer un site internet qui reflète parfaitement votre savoir-faire pour augmenter votre visibilité et votre notoriété en ligne ? Être thérapeute, c’est offrir un espace d’écoute, de...\n11 exemples inspirants de sites web de thérapeutes et comment créer le vôtre en un temps record est un article de WPMarmite, le blog qui vous aide à tirer le meilleur de WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:832:\"\n        <p><img width=\"1500\" height=\"830\" src=\"https://wpmarmite.com/wp-content/uploads/2024/04/creation-site-internet-therapeute.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"Créer un site internet de thérapeute\" //></p>\n<p>Vous êtes thérapeute, psychologue, sophrologue ou praticien du bien-être ? Vous rêvez de créer un site internet qui reflète parfaitement votre savoir-faire pour augmenter votre visibilité et votre notoriété en ligne ? Être thérapeute, c’est offrir un espace d’écoute, de...</p>\n<p><a href=\"https://wpmarmite.com/exemple-site-web-therapeute/\">11 exemples inspirants de sites web de thérapeutes et comment créer le vôtre en un temps record</a> est un article de <a href=\"https://wpmarmite.com\">WPMarmite</a>, le blog qui vous aide à tirer le meilleur de WordPress.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Équipe WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"http://feedpress.me/WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP Marmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:2;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://whodunit.consulting/compositions-synchronisees-gutenberg-attention-contenu-virtuel/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Compositions synchronisées dans Gutenberg : attention au contenu virtuel !\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:91:\"https://whodunit.consulting/compositions-synchronisees-gutenberg-attention-contenu-virtuel/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-09-03T23:57:47.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-09-03T23:57:47.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:315:\"Les compositions synchronisées de Gutenberg sont pratiques, mais leur contenu est totalement virtuel, et n\'appartient pas réellement à la page. Un inconvénient à connaitre !\nL’article Compositions synchronisées dans Gutenberg : attention au contenu virtuel ! est apparu en premier sur Whodunit Consulting.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:14755:\"\n        <figure style=\"margin-top:0;margin-bottom:var(--wp--preset--spacing--40)\" class=\"wp-block-post-featured-image\"><img width=\"1600\" height=\"960\" src=\"https://whodunit.consulting/wp-content/uploads/2025/09/composition-synchronisee-gutenberg-contenu-virtuel-attention-seo.png\" class=\"attachment-post-thumbnail size-post-thumbnail wp-post-image\" alt=\"\" style=\"object-fit:cover\" //></figure>\n\n\n<p>Lorsque l&rsquo;on crée une composition avec l&rsquo;éditeur Gutenberg, plusieurs solutions s&rsquo;offrent à nous&nbsp;:</p>\n\n\n\n<ol style=\"list-style-type:upper-alpha\" class=\"wp-block-list\">\n<li style=\"margin-bottom:var(--wp--preset--spacing--10)\">Créer une <strong>composition « normale »</strong>, c&rsquo;est-à-dire un agencement de blocs enregistré en base de données avec leur contenu, qu&rsquo;on peut ensuite appeler sur n&rsquo;importe quelle page. On est ensuite libre de modifier ou non ce contenu, mais chaque occurrence de la composition est indépendante des autres, et elle est totalement intégrée au contenu de la page en cours d&rsquo;édition.</li>\n\n\n\n<li>Créer une <strong>composition «&nbsp;synchronisée&nbsp;» :</strong> c&rsquo;est une composition où les blocs, leur mise en forme et leur contenu, sont totalement synchronisés sur toutes les occurrences de la composition sur le site. Toute modification des blocs de la composition se fera sur toutes les pages où celle-ci est utilisée.</li>\n</ol>\n\n\n\n<p class=\"has-x-small-font-size\" id=\"source0\" style=\"border-right-style:none;border-right-width:0px;border-bottom-style:none;border-bottom-width:0px;border-left-color:var(--wp--preset--color--contrast);border-left-width:1px;padding-left:var(--wp--preset--spacing--10)\">À noter&nbsp;: les compositions synchronisées et les blocs réutilisables, c&rsquo;est la même chose&nbsp;! <br>L&rsquo;ancienne terminologie «&nbsp;bloc réutilisable&nbsp;» a été abandonnée au profit de «&nbsp;composition synchronisée&nbsp;» lors de la sortie de WordPress&nbsp;6.3 <a href=\"#note0\">[1]</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img width=\"1024\" height=\"770\" src=\"https://whodunit.consulting/wp-content/uploads/2025/09/creation-composition-synchronisee-gutenberg-1024x770.png\" alt=\"Capture d\'écran des options de création d\'une composition sur l\'interface de Gutenberg, l\'éditeur de contenu de WordPress\" class=\"wp-image-4368\" //><figcaption class=\"wp-element-caption\">Interface permettant de créer une composition à partir d&rsquo;un ensemble de blocs sur Gutenberg. L&rsquo;option « Synchronisée » permet de définir une composition gérée de manière synchronisée sur plusieurs emplacements.</figcaption></figure>\n\n\n\n<p>Ce qu&rsquo;il faut savoir, c&rsquo;est que si les <strong>compositions synchronisées</strong> sont très utiles pour ne pas avoir à modifier chaque occurence d&rsquo;une composition de blocs qui serait utilisée sur plusieurs pages, elles présentent aussi un inconvénient majeur&nbsp;: <strong>le contenu d&rsquo;une composition synchronisée n&rsquo;appartient pas réellement à la page</strong>.</p>\n\n\n\n<p>Il s&rsquo;agit en réalité d&rsquo;un appel de contenu. Un peu comme dans une page d&rsquo;archive d&rsquo;actualités&nbsp;: les articles qui remontent dans la liste ne font pas réellement partie du contenu de la page, c&rsquo;est totalement dynamique.</p>\n\n\n\n<p class=\"is-style-text-remarque has-contrast-2-color has-text-color has-link-color has-base-font-size wp-elements-a9e6288a18a9a83f8d923341c95975b3 is-style-text-remarque--1\"><strong>Le contenu d&rsquo;une composition synchronisée est virtuel</strong>&nbsp;: ce n&rsquo;est qu&rsquo;un identifiant pointant vers un contenu externe à la page.</p>\n\n\n\n<div style=\"height:2em\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large has-custom-border\"><a href=\"https://whodunit.consulting/wp-content/uploads/2025/09/composition-synchronisee-virtuelle-wordpress-gutenberg-editeur.png\" target=\"_blank\" rel=\" noreferrer noopener\"><img width=\"1024\" height=\"613\" data-id=\"4311\" src=\"https://whodunit.consulting/wp-content/uploads/2025/09/composition-synchronisee-virtuelle-wordpress-gutenberg-editeur-1024x613.png\" alt=\"Capture d\'écran de l\'ajout d\'une composition synchronisée dans l\'éditeur Gutenberg (cliquer pour ouvrir l\'image dans un nouvel onglet)\" class=\"has-border-color has-contrast-border-color wp-image-4311\" style=\"border-width:1px\" //></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large has-custom-border\"><a href=\"https://whodunit.consulting/wp-content/uploads/2025/09/composition-synchronisee-virtuelle-wordpress-gutenberg-code.png\" target=\"_blank\" rel=\" noreferrer noopener\"><img width=\"1024\" height=\"569\" data-id=\"4310\" src=\"https://whodunit.consulting/wp-content/uploads/2025/09/composition-synchronisee-virtuelle-wordpress-gutenberg-code-1024x569.png\" alt=\"Capture d\'écran du code source d\'une composition syncrhonisée dans l\'éditeur Gutenberg, montrant que l\'élément est inséré de façon virtuelle, uniquement en faisant référence à son identifiant (cliquer pour ouvrir l\'image dans un nouvel onglet)\" class=\"has-border-color has-contrast-border-color wp-image-4310\" style=\"border-width:1px\" //></a></figure>\n<figcaption class=\"blocks-gallery-caption wp-element-caption\">La 1ère capture montre l&rsquo;ajout d&rsquo;une composition synchronisée dans une page. <br>La 2ème capture montre le code HTML de cette page tel qu&rsquo;il est enregistré en base de données. <br>On observe que dans le code source de la page, le contenu textuel de la composition n&rsquo;apparait pas&nbsp;: on retrouve simplement un appel dynamique à l&rsquo;identifiant de la composition.<br><em>(cliquer sur les images pour les agrandir dans un nouvel onglet)</em></figcaption></figure>\n\n\n\n<h2 class=\"wp-block-heading\">La <mark class=\"has-inline-color has-contrast-2-color\">logique de synchronisation</mark> des compositions de blocs Gutenberg dans WordPress</h2>\n\n\n\n<p id=\"source1\">Techniquement, cette problématique est liée au mode de fonctionnement des compositions&nbsp;: dès lors qu&rsquo;elles sont synchronisées, le contenu n&rsquo;appartient plus à la page, c&rsquo;est juste une remontée d&rsquo;un contenu tiers totalement virtuel, enregistré dans le <abbr title=\"Custom Post Type\"><bdo lang=\"en\" dir=\"ltr\">CPT</bdo></abbr> <code>wp_block</code> <a href=\"#note1\">[2]</a>.</p>\n\n\n\n<p>Ainsi, si vous avez une composition synchonisée dans votre page, <strong>son contenu textuel sera ignoré</strong> par de nombreux éléments de WordPress qui interagissent habituellement avec le contenu&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Le texte de la composition ne sera pas utilisé pour générer l&rsquo;extrait de la publication&nbsp;: la fonction <code>the_excerpt()</code> n&rsquo;en tient pas compte.</li>\n\n\n\n<li>Son texte ne remontera pas dans Yoast (ou autre extension SEO), par exemple pour générer la méta description de la page.</li>\n\n\n\n<li>Son texte n&rsquo;apparaitra pas non plus dans les partages sur les réseaux sociaux.</li>\n\n\n\n<li>Le moteur de recherche du site ne tiendra pas compte du contenu de la composition lors de la recherche des mots-clés demandés.</li>\n\n\n\n<li>Si vous utilisez une extension ou un bout de code estimant le temps de lecture de la page, le calcul ne tiendra pas compte du contenu de la compo.</li>\n</ul>\n\n\n\n<p class=\"is-style-text-remarque has-contrast-2-color has-text-color has-link-color has-base-font-size wp-elements-857fa9d2b91b327e8ec4ea949a237d44 is-style-text-remarque--3\">Pour WordPress, le contenu d&rsquo;une composition synchronisée n&rsquo;appartient tout simplement pas à la page dans laquelle il est inséré.</p>\n\n\n\n<div style=\"height:2em\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Pas de vrai <mark class=\"has-inline-color has-contrast-2-color\">risque SEO</mark> si les compositions de blocs sont bien utilisées</h2>\n\n\n\n<p class=\"is-style-default has-contrast-color has-text-color has-link-color has-base-font-size wp-elements-d6a9488d37a1efcc0c3b47598c01cdad\">Les moteurs d&rsquo;indexation comme Google ou n&rsquo;importe quel moteur <abbr title=\"intelligence artificielle\">IA</abbr> prennent en compte le HTML généré <em>in fine</em> dans la page. Pour eux la composition fait donc bien partie de la page puisqu&rsquo;elle est chargé en <bdo lang=\"en\" dir=\"ltr\"><em>front</em></bdo> au même titre que le reste du contenu. Ouf !</p>\n\n\n\n<p class=\"is-style-default has-contrast-color has-text-color has-link-color has-base-font-size wp-elements-82fc998017ae65edb6eea3a88f0f4930\">Le seul risque SEO éventuel d&rsquo;une composition synchronisée, c&rsquo;est le risque de contenu dupliqué, mais celui se pose dès lors que l&rsquo;on répète des blocs de contenus similaires d&rsquo;une page à l&rsquo;autre.</p>\n\n\n\n<p>Parfois ça peut être adapté, notamment pour des éléments qu&rsquo;on retrouvre systématiquement en pied d&rsquo;article comme par exemple un <em><bdo lang=\"en\" dir=\"ltr\">call to action</bdo></em> d&rsquo;inscription à une newsletter.</p>\n\n\n\n<p>Si l&rsquo;on se fiche qu&rsquo;il ne soit pas considéré comme faisant partie des contenus de la page, qu&rsquo;il s&rsquo;agit d&rsquo;un contenu transverse comme pourrait l&rsquo;être l&rsquo;entête ou le pied de page du site, alors l&rsquo;usage d&rsquo;une composition syncronisée peut alors être envisagé.</p>\n\n\n\n<p><em>Mais attention à bien anticiper les conséquences en amont…</em></p>\n\n\n\n<div style=\"height:2em\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading\">Un <mark class=\"has-inline-color has-contrast-2-color\">risque à anticiper</mark> au cas par cas</h2>\n\n\n\n<p id=\"source3_1\">Avec les collègues de l&rsquo;<a href=\"https://whodunit.fr\">agence Whodunit</a>, nous avons rencontré sur un projet récent l&rsquo;exemple d&rsquo;un chapo qui était géré via une composition synchronisée avec surcharge possible du contenu. Car oui, le problème concerne aussi les compos synchronisées avec surcharge <a href=\"#note3_1\">[3]</a>.</p>\n\n\n\n<p>Malheureusement, le texte saisi dans la composition n&rsquo;était pas utilisé pour l&rsquo;extrait de contenu affiché sur les pages d&rsquo;archives et dans la méta description.</p>\n\n\n\n<p>Il a donc fallu repasser manuellement sur tous les contenus du site pour refaire ce chapo afin qu&rsquo;il soit réellement intégré à la page, à l&rsquo;aide d&rsquo;une composition non synchronisée. Un travail pas forcément anticipé.</p>\n\n\n\n<p class=\"is-style-text-emphase is-style-text-emphase--4\" style=\"margin-top:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30)\">Conclusion : il faut être sûr de soi lorsque l&rsquo;on utilise une composition synchronisée, et mieux vaut souvent éviter de les utiliser en début de contenu.</p>\n\n\n\n<div style=\"height:1em\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading has-large-font-size\">La possibilité de <mark class=\"has-inline-color has-contrast-2-color\">détacher une composition synchronisée</mark> après insertion</h2>\n\n\n\n<p id=\"source2\">Il faut noter qu&rsquo;il est toujours possible de «&nbsp;détacher&nbsp;» une composition synchronisée après l&rsquo;avoir insérée.</p>\n\n\n\n<p id=\"source4\">Cela a pour effet de la transformer en composition non synchronisée dont le contenu appartient entièrement à la page en cours d&rsquo;édition <a href=\"#note4\">[4]</a>.</p>\n\n\n\n<p class=\"is-style-text-remarque has-contrast-2-color has-text-color has-link-color has-medium-font-size wp-elements-adf39ddca58b4b72ad27c3b73e187e28 is-style-text-remarque--5\">Par défaut, mieux vaut utiliser des compositions non synchronisées.<br>Pour les quelques cas où on sait que le composant s&rsquo;y prête vraiment, on peut utiliser des compos synchronisées, en ayant bien en tête que leur contenu n&rsquo;appartiendra à la page que virtuellement.</p>\n\n\n\n<div style=\"height:1em\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h2 class=\"wp-block-heading has-large-font-size\">Des précisions à ajouter dans la <mark class=\"has-inline-color has-contrast-2-color\">documentation officielle</mark> de WordPress</h2>\n\n\n\n<p id=\"source5\">Cette différence fondamentale entre compositions Gutenberg « synchronisées » et « non synchronisées » n&rsquo;apparait à ce jour jamais vraiment dans la documentation officielle de WordPress <a href=\"#note5\">[5]</a>. Outre cet article, je vais dont également ajouter un encart expliquant ces inconvénients potentiels sur la doc.</p>\n\n\n\n<div style=\"height:2em\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" //>\n\n\n\n<h2 class=\"wp-block-heading has-small-font-size\">Notes et références</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li id=\"note0\"><a href=\"#source0\">[1]</a> Pour en savoir plus sur ce renommage, <a href=\"https://github.com/WordPress/gutenberg/pull/51144\">consulter la <em><bdo lang=\"en\" dir=\"ltr\">pull request</bdo></em> correspondante sur le dépôt GitHub du projet Gutenberg (en anglais)</a>.</li>\n\n\n\n<li id=\"note1\"><a href=\"#source1\">[2]</a> Voir la déclaration du type de publication <code>wp_block</code> <a href=\"https://github.com/WordPress/wordpress-develop/blob/6.8/src/wp-includes/post.php#L281\">dans le code source de WordPress (en anglais)</a>.</li>\n\n\n\n<li id=\"note3_1\"><a href=\"#source3_1\">[3]</a> Il s&rsquo;agit d&rsquo;un mécanisme un peu plus technique : <a href=\"https://developer.wordpress.org/news/2024/06/an-introduction-to-overrides-in-synced-patterns/\">cet article (en anglais) explique le principe des compositions synchronisées avec surcharge</a>.</li>\n\n\n\n<li id=\"note4\"><a href=\"#source2\">[4]</a> Voir la <a href=\"https://fr.wordpress.org/support/article/les-blocs-reutilisables/#detacher-les-compositions\">section «&nbsp;Détacher une composition synchronisée&nbsp;» sur la documentation de WordPress en français</a>.</li>\n\n\n\n<li id=\"note5\"><a href=\"#source5\">[5]</a> Voir la page <a href=\"https://fr.wordpress.org/support/article/comparing-patterns-template-parts-and-reusable-blocks/\">«&nbsp;Différencier les compositions synchronisées et non synchronisées&nbsp;» sur la documentation de référence de WP en français</a>.</li>\n</ul>\n<p>L’article <a href=\"https://whodunit.consulting/compositions-synchronisees-gutenberg-attention-contenu-virtuel/\">Compositions synchronisées dans Gutenberg : attention au contenu virtuel !</a> est apparu en premier sur <a href=\"https://whodunit.consulting\">Whodunit Consulting</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Jean-Baptiste Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://whodunit.consulting/category/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Whodunit Consulting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:3;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://blog.o2switch.fr/mu-plugins-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"MU-plugins WordPress : à quoi servent-ils et comment les utiliser ?\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:46:\"https://blog.o2switch.fr/mu-plugins-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-09-03T06:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-09-03T06:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:205:\"Les mu-plugins (must-use) sont des mini extensions chargées automatiquement par WordPress. Idéals pour des réglages permanents et indépendants du thème. Guide rapide + 5 exemples prêts à l’emploi.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:219:\"\n        Les mu-plugins (must-use) sont des mini extensions chargées automatiquement par WordPress. Idéals pour des réglages permanents et indépendants du thème. Guide rapide + 5 exemples prêts à l’emploi.\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Éric Martin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://blog.o2switch.fr/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"O2switch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:4;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://yesweblog.fr/afficher-taxonomie-dans-colonnes-admin-acf/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"Afficher une taxonomie dans les colonnes admin avec ACF\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:64:\"https://yesweblog.fr/afficher-taxonomie-dans-colonnes-admin-acf/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-08-30T13:30:43.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-08-30T13:30:43.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:433:\"Nouvel Article\nACD à savoir Advanced Custom Fields est de loin l’extension phare qui permet de créer des groupes de champs, de types de publications (ou CPT) ainsi que des taxonomies (catégories et étiquettes). C’est un plugin très étendu qui en l’occurrence autorise l’ajout de nouvelles taxonomies sur un site web WordPress. Dès une première prise en […]\n- Yes We Blog ! - Webmaster WordPress - Griselidis Gaillet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:524:\"\n        <p>Nouvel Article</p>\n<p>ACD à savoir Advanced Custom Fields est de loin l&#8217;extension phare qui permet de créer des groupes de champs, de types de publications (ou CPT) ainsi que des taxonomies (catégories et étiquettes). C&#8217;est un plugin très étendu qui en l&#8217;occurrence autorise l&#8217;ajout de nouvelles taxonomies sur un site web WordPress. Dès une première prise en [&#8230;]</p>\n<p>- <a href=\"https://yesweblog.fr\">Yes We Blog ! - Webmaster WordPress - Griselidis Gaillet</a></p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Griselidis Gaillet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://yesweblog.fr/category/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Yes we blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:5;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://kinsta.com/fr/blog/themes-bloc-internationalisation/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"Guide du développeur : Rendre les thèmes WordPress multilingues\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:60:\"https://kinsta.com/fr/blog/themes-bloc-internationalisation/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-08-25T06:28:39.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-08-25T06:28:39.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:293:\"Les thèmes de blocs traduisent WordPress différemment d’une approche typique. Les fichiers de modèles PHP traditionnels avec des fonctions de traduction ne fonctionnent pas avec les ...\nThe post Guide du développeur : Rendre les thèmes WordPress multilingues appeared first on Kinsta®.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:437:\"\n        <p>Les thèmes de blocs traduisent WordPress différemment d&#8217;une approche typique. Les fichiers de modèles PHP traditionnels avec des fonctions de traduction ne fonctionnent pas avec les ...</p>\n<p>The post <a href=\"https://kinsta.com/fr/blog/themes-bloc-internationalisation/\">Guide du développeur : Rendre les thèmes WordPress multilingues</a> appeared first on <a href=\"https://kinsta.com/fr\">Kinsta®</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Jeremy Holcombe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://kinsta.com/fr/sujets/developpement-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Kinsta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:6;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://holdmywp.com/checklist-extensions-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Des extensions de qualité  pour bien construire son site WordPress en 2025\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:52:\"https://holdmywp.com/checklist-extensions-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-08-11T06:40:03.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-08-11T06:40:03.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:191:\"Les extensions référencées ici sont celles avec lesquelles je travaille régulièrement. Cette liste propose une sélection d\'extensions de qualité pour bien construire un site WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:26287:\"\n        \n<p>Depuis que <a href=\"https://holdmywp.com/creation-de-site-wordpress/\" title=\"Site sur mesure\">je développe des sites avec WordPress</a>, j’ai testé et utilisé beaucoup, beaucoup, beaaaauuuuuucoup d’extensions différentes pour répondre à des besoins récurrents : prise de contact, <a href=\"https://holdmywp.com/checklist-securite-wordpress/\" title=\"Check-list de sécurité WordPress\">sécurité</a>, performance, contenus personnalisés… Le dépôt officiel regorge de solutions intéressantes. Les extensions référencées ici sont celles avec lesquelles je travaille régulièrement. Cette liste propose une sélection d’extensions de qualité pour bien construire un site WordPress.</p>\n\n\n\n<p>Toutes ces extensions sont gratuites, bien maintenues, efficaces immédiatement et bénéficient pour la plupart de versions professionnelles payantes.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"#checklist\">Consulter la liste ↓</a></div>\n</div>\n\n\n<h2 class=\"wp-block-heading\" id=\"comment-selectionner-une-extension-wordpress\">Comment sélectionner une extension WordPress ?</h2>\n\n\n<p>Cette approche permet aux utilisateurs novices comme plus avancés de faire leur première sélection.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"une-extension-un-besoin\">Une extension = un besoin</h3>\n\n\n<p>Sur le dépôt, on trouve beaucoup d’extensions «&nbsp;couteaux-suisses&nbsp;»&nbsp;: elles font plein de trucs. Je ne suis pas fan de cette approche : en général, leurs fonctionnalités supplémentaires sont moins bien faites que celles d’extensions plus petites et spécialisées.</p>\n\n\n\n<p>J’essaye toujours de sélectionner une extension qui répond à un besoin précis.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"bien-pensee-et-non-invasive\">Bien pensée et non invasive</h3>\n\n<h4 class=\"wp-block-heading\" id=\"la-page-doption\">La page d’option</h4>\n\n\n<p>Une <strong>page d’option</strong> ? Oui, mais… Si l’extension ajoute une page d’option dédiée dans la barre latérale de l’interface d’administration, ce n’est pas un énième tableau de bord inutile. Un genre de stand personnel de l’éditeur qui permet juste de télécharger ses autres extensions. Une page d’option doit servir un usage avancé de l’extension qu’on utilise, sinon la place des <strong>réglages</strong> est dans le menu… réglages, effectivement.</p>\n\n\n<h4 class=\"wp-block-heading\" id=\"stop-a-la-pub\">Stop à la pub !</h4>\n\n\n<p>L’éditeur ne prend pas ton interface d’administration pour sa guérite publicitaire. Si une version professionnelle est disponible, elle est proposée uniquement sur la page de réglage de l’extension, elle n’envahit pas le reste de l’interface d’administration.</p>\n\n\n<h4 class=\"wp-block-heading\" id=\"il-y-a-une-charte\">Il y a une charte</h4>\n\n\n<p>La conception graphique de la page de réglage de l&rsquo;extension <strong>s&rsquo;intègre au mieux à la charte graphique native</strong> de l&rsquo;interface d&rsquo;administration de WordPress permettant une gestion claire et fluide.</p>\n\n\n<h4 class=\"wp-block-heading\" id=\"cerise-sur-le-gateau\">Cerise sur le gâteau</h4>\n\n\n<p>Une extension non invasive ne surcharge pas le tableau de bord avec des widgets non pertinents. Je dis bonus, car il est facile de désactiver ces widgets dans le menu « options de l&rsquo;écran ». Mais un utilisateur novice n&rsquo;est pas forcément au courant.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"lediteur-est-reactif-sur-la-page-de-support\">L&rsquo;éditeur est réactif sur la page de support</h3>\n\n\n<p>Tu hésites entre deux extensions pour un même besoin ? Une petite visite de l&rsquo;<strong>onglet support</strong> sur leurs pages respectives peut te permettre de les départager. Consulte les réponses de l&rsquo;éditeur/du développeur aux questions des utilisateurs.</p>\n\n\n\n<p>Si peu de demandes restent sans réponse ou non résolues, c&rsquo;est bon signe !</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"ta-base-de-donnees-nest-pas-une-poubelle\">Ta base de données n&rsquo;est pas une poubelle</h3>\n\n\n<p>Je trouve intéressant de jeter un rapide coup d&rsquo;œil à sa base de donnée après l&rsquo;installation d&rsquo;une extension. Si celle-ci a pris 15 tables après l&rsquo;installation, l&rsquo;extension responsable n&rsquo;est pas forcément très légère.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"selectionner-une-extension-de-qualite\">Sélectionner une extension de qualité</h3>\n\n\n<p>Pour résumer rapidement, voici <strong>quelques critères</strong> pour sélectionner une extension WordPress :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Elle répond à un besoin précis.</li>\n\n\n\n<li>Elle est non invasive.</li>\n\n\n\n<li>L’éditeur est réactif sur la page de support.</li>\n\n\n\n<li>Elle ne surcharge pas la base de données.</li>\n\n\n\n<li>Et bien entendu, elle fonctionne !</li>\n</ul>\n\n\n\n<p>En suivant ces critères et en testant, j&rsquo;ai composé ma petite check-list d&rsquo;extensions WordPress pour des sites internet simples ou plus avancés.</p>\n\n\n<h2 class=\"wp-block-heading\" id=\"un-socle-robuste-et-leger\">Un socle robuste et léger</h2>\n\n\n<p>Commençons par la base : pour faire un premier site, <strong>WordPress se suffit à lui-même</strong>. Surtout aujourd&rsquo;hui avec Gutenberg et l&rsquo;éditeur de site. Mais pour tous les sites sur lesquels je travaille, je mets en place cette première base. Les extensions de ce socle respectent tous mes critères de sélection.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"performances\">Performances</h3>\n\n\n<p>Une première sélection d&rsquo;extensions qui améliore rapidement les performances de ton site pour tes visiteurs et dans l&rsquo;interface d&rsquo;administration. J&rsquo;ai détaillé leurs fonctionnements dans mon article : <a href=\"https://holdmywp.com/cache-wordpress-super-rapide/\" title=\"Un cache WordPress super rapide (et gratuit) sans WP Rocket\">Un cache WordPress super rapide (et gratuit) sans WP Rocket</a>.</p>\n\n\n<h4 class=\"wp-block-heading\" id=\"autoptimize\">Autoptimize</h4>\n\n\n<p>Optimise et agrège les ressources statiques de ton site WordPress (CSS, JS, HTML…).</p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/autoptimize/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Autoptimize\">Autoptimize</a> par <a href=\"https://profiles.wordpress.org/optimizingmatters/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">Optimizing Matters</a></p>\n\n\n<h4 class=\"wp-block-heading\" id=\"cache-enabler\">Cache enabler</h4>\n\n\n<p>Active un cache de page afin de servir des fichiers HTML pour les pages déjà calculées. </p>\n\n\n\n<p>Mon guide de configuration : <a href=\"https://holdmywp.com/comment-configurer-cache-enabler/\" title=\"Comment configurer Cache Enabler\">Comment configurer Cache Enabler</a></p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/cache-enabler/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Cache Enabler\">Cache Enabler</a> par <a href=\"https://profiles.wordpress.org/keycdn/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"KeyCDN\">KeyCDN</a></p>\n\n\n<h4 class=\"wp-block-heading\" id=\"sqlite-object-cache\">SQLite Object Cache</h4>\n\n\n<p>Active un système de cache objet avec SQLite3 ou APCU. </p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/sqlite-object-cache/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"SQLite Object Cache\">SQLite Object Cache</a> par <a href=\"https://profiles.wordpress.org/olliejones/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Oliver Jones\">Oliver Jones</a></p>\n\n\n<h4 class=\"wp-block-heading\" id=\"zenpress\">ZenPress</h4>\n\n\n<p>Ma première extension officielle, je l&rsquo;ai conçue pour alléger ton site WordPress en désactivant des fonctionnalités obsolètes (legacy), supprimer ou masquer des publicités, et appliquer un ensemble de <strong>bonnes pratiques</strong> de performances et de sécurité dès l&rsquo;activation.</p>\n\n\n\n<p>Le code est ouvert et accessible à tous sur <a href=\"https://github.com/quentin-ld/zenpress\" target=\"_blank\" rel=\"noopener nofollow\" title=\"github\">github</a>.</p>\n\n\n\n<p>➡️ <a href=\"https://holdmywp.com/zenpress/\" title=\"ZenPress – Unbloat, Performance &amp; Security\">ZenPress — Unbloat, Performance &amp; Security</a> par <a href=\"https://profiles.wordpress.org/quentinldd/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Quentin Le Duff\">Quentin Le Duff</a></p>\n\n\n\n<div class=\"wp-block-group has-fg-2-background-color has-background has-global-padding is-layout-constrained wp-block-group-is-layout-constrained\" style=\"border-top-color:var(--wp--preset--color--violet);border-top-width:0.18rem;border-right-color:var(--wp--preset--color--violet);border-right-width:0.18rem;border-bottom-color:var(--wp--preset--color--violet);border-bottom-width:0.18rem;border-left-color:var(--wp--preset--color--violet);border-left-width:0.96rem\">\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-bd3f9bef wp-block-group-is-layout-flex\">\n<div class=\"wp-block-group has-bg-0-color has-text-color has-link-color wp-elements-7e04d43aa399da37ac6c60a62204e66c is-vertical is-layout-flex wp-container-core-group-is-layout-43ece9da wp-block-group-is-layout-flex\" style=\"padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)\">\n<p class=\"has-bg-0-color has-text-color has-link-color has-outfit-font-family has-large-font-size wp-elements-17ca34d4cb992131934b342e15a269c5\" style=\"font-style:normal;font-weight:700\">Besoin de plus de performances ?</p>\n\n\n\n<p>Découvre <strong>ZenPress</strong>, mon extension ultralégère gratuite pour débarrasser ton site WordPress des fonctions inutiles et des publicités, améliorer la sécurité et les performances.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-left is-layout-flex wp-container-core-buttons-is-layout-0076338b wp-block-buttons-is-layout-flex\" style=\"margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://wordpress.org/plugins/zenpress/\" target=\"_blank\" rel=\"noreferrer noopener\">Page WordPress.org</a></div>\n\n\n\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://holdmywp.com/zenpress/\">Documentation</a></div>\n</div>\n</div>\n</div>\n</div>\n\n\n<h3 class=\"wp-block-heading\" id=\"securite\">Sécurité</h3>\n\n\n<p><strong>WordPress en lui-même est sécurisé</strong>, quand une vulnérabilité est découverte, elle est immédiatement corrigée par l&rsquo;équipe de contributeur et mise en ligne. La majorité des vulnérabilités sont introduites par des éléments extérieurs : <strong>extensions</strong>, <strong>thèmes</strong>, et <strong>pratiques utilisateurs</strong>.</p>\n\n\n\n<p>J&rsquo;ai détaillé une petite check-list pour renforcer la sécurité de son site : <a href=\"https://holdmywp.com/checklist-securite-wordpress/\" title=\"Check-list de sécurité WordPress\">Check-list de sécurité WordPress</a>. On ne peut pas éliminer tout risque, mais on peut faire de son mieux pour les réduire.</p>\n\n\n<h4 class=\"wp-block-heading\" id=\"bbq-firewall\">BBQ Firewall</h4>\n\n\n<p>Petit pare-feu très léger qui bloque une vaste gamme de requêtes malveillantes.</p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/block-bad-queries/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"BBQ Firewall\">BBQ Firewall</a> par <a href=\"https://profiles.wordpress.org/specialk/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Jeff Starr\">Jeff Starr</a></p>\n\n\n<h4 class=\"wp-block-heading\" id=\"header-security-advanced\">Header Security Advanced</h4>\n\n\n<p>Configure automatiquement des en-têtes de réponse HTTP.</p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/headers-security-advanced-hsts-wp/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Headers Security Advanced &amp; HSTS WP\">Headers Security Advanced &amp; HSTS WP</a> par <a href=\"https://profiles.wordpress.org/unicorn03/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Andrea Ferro\">Andrea Ferro</a></p>\n\n\n<h4 class=\"wp-block-heading\" id=\"wps-hide-login\">WPS Hide Login</h4>\n\n\n<p>Déplace la page de connexion de WordPress sur un autre URL sur-mesure. Permets d&rsquo;éviter énormément d&rsquo;attaques automatiques sur la page de connexion du site.</p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/wps-hide-login/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"WPS Hide Login\">WPS Hide Login</a> par <a href=\"https://profiles.wordpress.org/tabrisrp/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Remy Perona\">Remy Perona</a></p>\n\n\n<h3 class=\"wp-block-heading\" id=\"seo\">SEO</h3>\n\n\n<p><strong>WordPress est bien conçue</strong> pour permettre le référencement des contenus publiés par les moteurs de recherche. J&rsquo;ajoute une extension dédiée pour pouvoir ajuster plus finement ce fonctionnement.</p>\n\n\n<h4 class=\"wp-block-heading\" id=\"slim-seo\">Slim SEO</h4>\n\n\n<p>Fait la même chose que les grosses extensions SEO, les publicités en moins !</p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/slim-seo/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Slim SEO\">Slim SEO</a> par <a href=\"https://profiles.wordpress.org/rilwis/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Ahn Tran\">Ahn Tran</a></p>\n\n\n<h3 class=\"wp-block-heading\" id=\"suivi-statistique\">Suivi statistique</h3>\n\n\n<p>En général, on aime bien savoir si son site est consulté, et quelles pages sont populaires.</p>\n\n\n<h4 class=\"wp-block-heading\" id=\"koko-analytics\">Koko Analytics</h4>\n\n\n<p>Cette extension permet plusieurs configurations pour visualiser les volumes de visites sur son site. C&rsquo;est une extension légère et autohébergée que je trouve suffisante avant de passer à des solutions lourdes plus invasives.</p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/koko-analytics/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Koko Analytics\">Koko Analytics</a> par <a href=\"https://profiles.wordpress.org/dvankooten/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">Danny van Kooten</a></p>\n\n\n<h3 class=\"wp-block-heading\" id=\"un-petit-socle-pour-bien-demarrer\">Un petit socle pour bien démarrer</h3>\n\n\n<p>Cette première liste d&rsquo;extensions améliore ton site sans le surcharger et conserve l&rsquo;expérience native.</p>\n\n\n\n<div id=\"checklist\" class=\"wp-block-group has-bg-0-color has-fg-2-background-color has-text-color has-background has-link-color wp-elements-baecf4966c05e808e63f709a7b1f426d has-global-padding is-layout-constrained wp-container-core-group-is-layout-d7ffc722 wp-block-group-is-layout-constrained\" style=\"border-style:none;border-width:0px;padding-top:2rem;padding-right:2rem;padding-bottom:2rem;padding-left:2rem\">\n<p>✅ Autoptimize</p>\n\n\n\n<p>✅ BBQ Firewall</p>\n\n\n\n<p>✅ Cache enabler</p>\n\n\n\n<p>✅ Header Security Advanced</p>\n\n\n\n<p>✅ Koko Analytics</p>\n\n\n\n<p>✅ SQLite Object Cache</p>\n\n\n\n<p>✅ Slim SEO</p>\n\n\n\n<p>✅ ZenPress</p>\n\n\n\n<p>✅ WPS Hide Login</p>\n</div>\n\n\n<h2 class=\"wp-block-heading\" id=\"extensions-additionnelles-selon-les-besoins\">Extensions additionnelles selon les besoins</h2>\n\n\n<p>Sélection d&rsquo;extensions catégorisée par besoin. Resté et approuvé, il n&rsquo;y a plus qu&rsquo;à piocher ! Quand des extensions dérogent à certains de mes critères de sélection, elles compensent par leur qualité de fonctionnement.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"amelioration-de-la-qualite-de-vie\">Amélioration de la qualité de vie</h3>\n\n\n<p>Pour fluidifier l&rsquo;utilisation de son site et améliorer certains fonctionnements natifs.</p>\n\n\n<h4 class=\"wp-block-heading\" id=\"admin-menu-editor\">Admin Menu Editor</h4>\n\n\n<p>Très pratique pour réorganiser la barre latérale d&rsquo;administration, quand on commence à avoir pas mal de contenus personnalisés et de pages d&rsquo;options.</p>\n\n\n\n<p>➡️ <a href=\"https://fr.wordpress.org/plugins/admin-menu-editor/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Admin Menu Editor\">Admin Menu Editor</a> par <a href=\"https://profiles.wordpress.org/whiteshadow/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Janis Elsts\">Janis Elsts</a></p>\n\n\n<h4 class=\"wp-block-heading\" id=\"yoast-duplicate-post\">Yoast Duplicate Post</h4>\n\n\n<p>Permets de dupliquer rapidement des contenus (articles, pages…) .</p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/duplicate-post/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Yoast Duplicate Post\">Yoast Duplicate Post</a> par <a href=\"https://profiles.wordpress.org/yoast/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Team Yoast\">Team Yoast</a></p>\n\n\n<h3 class=\"wp-block-heading\" id=\"formulaires\">Formulaires</h3>\n\n\n<p>Premier besoin d&rsquo;interaction avec un site.</p>\n\n\n<h4 class=\"wp-block-heading\" id=\"contact-form-7-cf7\">Contact Form 7 (CF7)</h4>\n\n\n<p>Permets de créer tes premiers formulaires de contact, cette extension gratuite fait très bien l&rsquo;affaire pour des formulaires simples en restant léger.</p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/contact-form-7/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Contact Form 7\">Contact Form 7</a> par <a href=\"https://profiles.wordpress.org/takayukister/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Takayuki Miyoshi\">Takayuki Miyoshi</a></p>\n\n\n<h4 class=\"wp-block-heading\" id=\"flamingo\">Flamingo</h4>\n\n\n<p>Pour enregistrer et de visualiser les demandes reçues via tes formulaires de contact CF7 directement dans l&rsquo;interface d&rsquo;administration de WordPress.</p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/flamingo/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Flamingo\">Flamingo</a> par <a href=\"https://profiles.wordpress.org/takayukister/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Takayuki Miyoshi\">Takayuki Miyoshi</a></p>\n\n\n<h3 class=\"wp-block-heading\" id=\"protection-des-formulaires\">Protection des formulaires</h3>\n\n\n<p>Les formulaires sont le premier <strong>besoin d&rsquo;interaction</strong> et aussi un vecteur d&rsquo;attaque, en particulier de spams automatisés (commentaires, inscription, démarchage frauduleux dans l&rsquo;espace de contact…).</p>\n\n\n<h4 class=\"wp-block-heading\" id=\"akismet\">Akismet</h4>\n\n\n<p>La solution propulsée par Automattic pour protéger les formulaires natifs de WordPress, elle a aussi une intégration pour protéger les formulaires CF7. Attention, les messages soumis sont traités par un serveur externe, ce qui peut poser un problème par rapport au RGPD.</p>\n\n\n\n<p>➡️ <a href=\"https://fr.wordpress.org/plugins/akismet/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Akismet Anti-spam: Spam Protection\">Akismet Anti-spam: Spam Protection</a> par <a href=\"https://profiles.wordpress.org/automattic/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Automattic\">Automattic</a></p>\n\n\n<h4 class=\"wp-block-heading\" id=\"honeypot-for-contact-form-7\">Honeypot for Contact form 7</h4>\n\n\n<p>J&rsquo;ai fait un guide pour utiliser cette extension : <a href=\"https://holdmywp.com/configurer-honeypot-for-contact-form-7/\" title=\"Comment configurer Honeypot for Contact Form 7\">Comment configurer Honeypot for Contact form 7</a>. Malheureusement, elle a récemment été fardé d&rsquo;un nouveau tableau de bord inutile pour vendre les solutions de l&rsquo;éditeur. Si cela ne te pose pas de problème, elle est toujours très efficace.</p>\n\n\n\n<p>➡️ <a href=\"https://fr.wordpress.org/plugins/contact-form-7-honeypot/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Honeypot for Contact Form 7 (CF7 Apps)\">Honeypot for Contact Form 7 (CF7 Apps)</a> par <a href=\"https://profiles.wordpress.org/saadiqbal/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">Saad Iqbal</a></p>\n\n\n<h4 class=\"wp-block-heading\" id=\"wp-armour-une-alternative-jquery-a-akismet\">WP Armour : Une alternative JQuery à  Akismet</h4>\n\n\n<p>Très bonne alternative locale à Akismet, tout fonctionne efficacement en local. Par contre, le code de l&rsquo;extension repose sur jQuery et le charge sur l&rsquo;interface publique. Si ton site repose déjà sur jQuery cela n&rsquo;impactera pas les performances, par contre s&rsquo;il ne l&rsquo;utilise pas cela peut être dommage de charger la libraire JS uniquement pour ça.</p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/honeypot/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"WP Armour – Honeypot Anti Spam\">WP Armour – Honeypot Anti Spam</a> par <a href=\"https://profiles.wordpress.org/dnesscarkey/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">Dnesscarkey</a></p>\n\n\n<h3 class=\"wp-block-heading\" id=\"gestion-de-contenu-personnalise\">Gestion de contenu personnalisé</h3>\n\n\n<p>WordPress permet de créer des <strong>types de contenus supplémentaires</strong> : les « custom post types ». Ces extensions permettent de gérer ces contenus supplémentaires et des champs associés depuis l&rsquo;interface d&rsquo;administration. Fait ton choix !</p>\n\n\n<h4 class=\"wp-block-heading\" id=\"le-challenger-pods\">Le challenger : Pods</h4>\n\n\n<p>Cette petite extension est une alternative à ACF très complète et bien intégrée à Gutenberg. Pods permet aussi facilement de créer des mises en page sur mesure, des blocs et des compositions basés sur ses champs additionnels. Une extension complémentaire de cache conçue pour les sites hébergés avec formules faibles en ressources est disponible.</p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/pods/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Pods — Custom Content Types and Fields\">Pods — Custom Content Types and Fields</a> par <a href=\"https://profiles.wordpress.org/sc0ttkclark/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Scott Kingsley Clark\">Scott Kingsley Clark</a></p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/pods-alternative-cache/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Pods Alternative Cache\">Pods Alternative Cache</a>  par <a href=\"https://profiles.wordpress.org/keraweb/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Jory Hogeveen\">Jory Hogeveen</a></p>\n\n\n<h4 class=\"wp-block-heading\" id=\"la-reference-acf\">La référence : ACF</h4>\n\n\n<p>On ne la présente plus, c&rsquo;est le poids lourd des extensions permettant de gérer ses contenus personnalisés. Si tu es quelqu&rsquo;un plus tourné vers le « no-code », elle correspondra mieux à tes besoins.</p>\n\n\n\n<p>➡️ <a href=\"https://wordpress.org/plugins/advanced-custom-fields/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Advanced Custom Fields\">Advanced Custom Fields</a> par <a href=\"https://profiles.wordpress.org/wpengine/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"WP Engine\">WP Engine</a></p>\n\n\n<h3 class=\"wp-block-heading\" id=\"maintenance\">Maintenance</h3>\n\n\n<p>Les extensions de <a href=\"https://holdmywp.com/maintenance-wordpress/\" title=\"Maintenance WordPress\">maintenance</a> listées ici permettent de faciliter la <strong>gestion quotidienne</strong> de ton site pour toutes les actions courantes.</p>\n\n\n<h4 class=\"wp-block-heading\" id=\"sauvegarde